/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.servlet;

import java.net.ConnectException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.web.category.CategoryList;
import org.opennms.web.category.RTCPostSubscriber;
import org.opennms.web.servlet.ServletInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializerServletContextListener
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(InitializerServletContextListener.class);
    private Timer rtcCheckTimer = null;

    public void contextInitialized(ServletContextEvent event) {
        try {
            ServletInitializer.init(event.getServletContext());
            LOG.info("Initialized servlet systems successfully");
        }
        catch (ServletException e) {
            LOG.error("Error while initializing servlet systems: {}", (Object)e, (Object)e);
        }
        catch (Throwable e) {
            LOG.error("Error while initializing user, group, or view factory: {}", (Object)e, (Object)e);
        }
        try {
            this.rtcCheckTimer = new Timer();
            this.rtcCheckTimer.schedule((TimerTask)new RTCPostSubscriberTimerTask(), new Date(), 130000L);
        }
        catch (ServletException e) {
            LOG.error("Error while initializing RTC check timer: {}", (Object)e, (Object)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        try {
            ServletInitializer.destroy(event.getServletContext());
            LOG.info("Destroyed servlet systems successfully");
        }
        catch (ServletException e) {
            LOG.error("Error while destroying servlet systems: {}", (Object)e, (Object)e);
        }
        if (this.rtcCheckTimer != null) {
            this.rtcCheckTimer.cancel();
            this.rtcCheckTimer = null;
        }
    }

    public class RTCPostSubscriberTimerTask
    extends TimerTask {
        private CategoryList m_categorylist = new CategoryList();

        @Override
        public void run() {
            try {
                if (!this.m_categorylist.isDisconnected()) {
                    return;
                }
            }
            catch (Throwable e) {
                LOG.error("Error checking if OpenNMS is disconnected: {}", (Object)e, (Object)e);
                return;
            }
            LOG.info("OpenNMS is disconnected -- attempting RTC POST subscription");
            try {
                RTCPostSubscriber.subscribeAll("WebConsoleView");
                LOG.info("RTC POST subscription event sent successfully");
            }
            catch (EventProxyException e) {
                if (e.getCause() instanceof ConnectException) {
                    LOG.info("RTC POST failed due to ConnectException: {}", (Object)e.getCause().toString());
                } else {
                    LOG.error("Error subscribing to RTC POSTs: {}", (Object)e, (Object)e);
                }
            }
            catch (Throwable e) {
                LOG.error("Error subscribing to RTC POSTs: {}", (Object)e, (Object)e);
            }
        }
    }
}

