/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.logging.Logging;
import org.opennms.core.resource.Vault;
import org.opennms.netmgt.config.ViewsDisplayFactory;
import org.opennms.netmgt.config.viewsdisplay.Section;
import org.opennms.netmgt.config.viewsdisplay.View;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.web.api.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTCPostSubscriber {
    private static final String LOGGING_PREFIX = "rtc";
    private static final Logger LOG = LoggerFactory.getLogger(RTCPostSubscriber.class);
    protected EventProxy m_proxy = Util.createEventProxy();
    protected String m_url;
    protected String m_username = "rtc";
    protected String m_password = "rtc";

    public static void sendSubscribeEvent(final EventProxy proxy, final String url, final String username, final String password, final String categoryName) throws IllegalArgumentException, EventProxyException {
        block4: {
            if (proxy == null || url == null || username == null || password == null || categoryName == null) {
                throw new IllegalArgumentException("Cannot take null parameters.");
            }
            try {
                Logging.withPrefix((String)LOGGING_PREFIX, (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/rtc/subscribe", "RTCPostSubscriber");
                        bldr.setHost("host");
                        bldr.addParam("url", url);
                        bldr.addParam("user", username);
                        bldr.addParam("passwd", password);
                        bldr.addParam("catlabel", categoryName);
                        proxy.send(bldr.getEvent());
                        LOG.info("Subscription requested for {} to {}", (Object)username, (Object)url);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                if (e instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)e;
                }
                if (!(e instanceof EventProxyException)) break block4;
                throw (EventProxyException)e;
            }
        }
    }

    public static void sendUnsubscribeEvent(final EventProxy proxy, final String url) throws IllegalArgumentException, EventProxyException {
        block4: {
            if (proxy == null || url == null) {
                throw new IllegalArgumentException("Cannot take null parameters.");
            }
            try {
                Logging.withPrefix((String)LOGGING_PREFIX, (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/rtc/unsubscribe", "RTCPostSubscriber");
                        bldr.setHost("host");
                        bldr.addParam("url", url);
                        proxy.send(bldr.getEvent());
                        LOG.info("Unsubscription sent for {}", (Object)url);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                if (e instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)e;
                }
                if (!(e instanceof EventProxyException)) break block4;
                throw (EventProxyException)e;
            }
        }
    }

    public String subscribe(String categoryName) throws IllegalArgumentException, EventProxyException {
        if (categoryName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.initFromRtcPropertyFile(categoryName);
        RTCPostSubscriber.sendSubscribeEvent(this.m_proxy, this.m_url, this.m_username, this.m_password, categoryName);
        return this.m_url;
    }

    public void unsubscribe() throws IllegalArgumentException, EventProxyException {
        RTCPostSubscriber.sendUnsubscribeEvent(this.m_proxy, this.m_url);
    }

    public void close() {
        this.m_proxy = null;
    }

    protected void initFromRtcPropertyFile(final String categoryName) {
        if (categoryName == null) {
            throw new IllegalArgumentException("categoryName can not be null");
        }
        String username = Vault.getProperty((String)"opennms.rtc-client.http-post.username");
        if (username != null) {
            this.m_username = username;
        }
        Logging.withPrefix((String)LOGGING_PREFIX, (Runnable)new Runnable(){

            @Override
            public void run() {
                String baseUrl;
                String password = Vault.getProperty((String)"opennms.rtc-client.http-post.password");
                if (password != null) {
                    RTCPostSubscriber.this.m_password = password;
                }
                if ((baseUrl = Vault.getProperty((String)"opennms.rtc-client.http-post.base-url")) == null) {
                    baseUrl = "http://localhost:8080/opennms/rtc/post";
                }
                RTCPostSubscriber.this.m_url = baseUrl.endsWith("/") ? baseUrl + Util.encode(categoryName) : baseUrl + "/" + Util.encode(categoryName);
                LOG.debug("RTCPostSubscriber initialized: url={}, user={}", (Object)RTCPostSubscriber.this.m_url, (Object)RTCPostSubscriber.this.m_username);
            }
        });
    }

    public static void subscribeAll(final String viewName) throws IOException, MarshalException, ValidationException, EventProxyException {
        if (viewName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        try {
            Logging.withPrefix((String)LOGGING_PREFIX, (Callable)new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    ViewsDisplayFactory.init();
                    ViewsDisplayFactory factory = ViewsDisplayFactory.getInstance();
                    View view = factory.getView(viewName);
                    if (view != null) {
                        RTCPostSubscriber subscriber = new RTCPostSubscriber();
                        try {
                            for (Section section : view.getSectionCollection()) {
                                for (String categoryName : section.getCategoryCollection()) {
                                    subscriber.subscribe(categoryName);
                                    LOG.info("Sent subscription event to RTC for category: {}", (Object)categoryName);
                                }
                            }
                        }
                        finally {
                            subscriber.close();
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

