/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.opennms.core.utils.ThreadCategory;

public class DependencyCheckingContextListener
implements ServletContextListener {
    private static final String IGNORE_ERRORS_PROPERTY = "dontBlameOpenNMS";
    private static final String IGNORE_ERRORS_MESSAGE = "but don't blame OpenNMS for any errors that occur without switching back to a supported JVM and setting the property back to 'false', first.";

    public void contextDestroyed(ServletContextEvent event) {
    }

    public void contextInitialized(ServletContextEvent event) {
        Boolean skipJvm = new Boolean(System.getProperty("opennms.skipjvmcheck"));
        if (!skipJvm.booleanValue()) {
            this.checkJvmName(event.getServletContext());
        }
    }

    private void checkJvmName(ServletContext context) {
        String systemProperty = "java.vm.name";
        String[] acceptableProperties = new String[]{"HotSpot(TM)", "BEA JRockit", "OpenJDK"};
        String vmName = System.getProperty("java.vm.name");
        if (vmName == null) {
            this.logAndOrDie(context, "System property 'java.vm.name' is not set so we can't figure out if this version of Java is supported");
        }
        boolean ok = false;
        for (String systemPropertyMatch : acceptableProperties) {
            if (!vmName.contains(systemPropertyMatch)) continue;
            ok = true;
        }
        if (ok) {
            this.log().info("System property 'java.vm.name' appears to contain a suitable JVM signature ('" + vmName + "') -- congratulations!  ;)");
        } else {
            this.logAndOrDie(context, "System property 'java.vm.name' does not contain a suitable JVM signature ('" + vmName + "').  OpenNMS recommends the official Sun JVM.");
        }
    }

    private void logAndOrDie(ServletContext context, String message) {
        String webXmlPath = context.getRealPath("/WEB-INF/web.xml");
        if (!Boolean.parseBoolean(context.getInitParameter(IGNORE_ERRORS_PROPERTY))) {
            String howToFixMessage = "You can edit " + webXmlPath + " and change the value for the '" + IGNORE_ERRORS_PROPERTY + "' context parameter from 'false' to 'true', " + IGNORE_ERRORS_MESSAGE;
            this.log().fatal(message);
            this.log().fatal(howToFixMessage);
            throw new RuntimeException(message + "  " + howToFixMessage);
        }
        this.log().warn(message);
        this.log().warn("Context parameter 'dontBlameOpenNMS' is set in " + webXmlPath + ", so the above warning is not fatal,  " + IGNORE_ERRORS_MESSAGE);
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

