/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.vtdxml;

import com.ximpleware.AutoPilot;
import com.ximpleware.NavException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.protocols.xml.collector.AbstractXmlCollectionHandler;
import org.opennms.protocols.xml.collector.UrlFactory;
import org.opennms.protocols.xml.collector.XmlCollectionAttributeType;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.opennms.protocols.xml.collector.XmlCollectionSet;
import org.opennms.protocols.xml.collector.XmlSingleInstanceCollectionResource;
import org.opennms.protocols.xml.config.Request;
import org.opennms.protocols.xml.config.XmlGroup;
import org.opennms.protocols.xml.config.XmlObject;
import org.opennms.protocols.xml.config.XmlSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVTDXmlCollectionHandler
extends AbstractXmlCollectionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractVTDXmlCollectionHandler.class);

    private String getResourceName(VTDNav resource, XmlGroup group) throws XPathParseException {
        if (group.hasMultipleResourceKey()) {
            ArrayList<String> keys = new ArrayList<String>();
            for (String key : group.getXmlResourceKey().getKeyXpathList()) {
                LOG.debug("getResourceName: getting key for resource's name using {}", (Object)key);
                resource.push();
                AutoPilot ap = new AutoPilot();
                ap.bind(resource);
                ap.selectXPath(key);
                keys.add(ap.evalXPathToString());
                resource.pop();
            }
            return StringUtils.join(keys, (String)"_");
        }
        if (group.getKeyXpath() == null) {
            return "node";
        }
        LOG.debug("getResourceName: getting key for resource's name using {}", (Object)group.getKeyXpath());
        resource.push();
        AutoPilot ap = new AutoPilot();
        ap.bind(resource);
        ap.selectXPath(group.getKeyXpath());
        String s = ap.evalXPathToString();
        resource.pop();
        return s;
    }

    protected void fillCollectionSet(CollectionAgent agent, XmlCollectionSet collectionSet, XmlSource source, VTDNav document) throws ParseException, XPathParseException, XPathEvalException, NavException {
        XmlSingleInstanceCollectionResource nodeResource = new XmlSingleInstanceCollectionResource(agent);
        AutoPilot resAP = new AutoPilot(document);
        for (XmlGroup group : source.getXmlGroups()) {
            LOG.debug("fillCollectionSet: getting resources for XML group {} using XPATH {}", (Object)group.getName(), (Object)group.getResourceXpath());
            Date timestamp = this.getTimeStamp(document, group);
            resAP.selectXPath(group.getResourceXpath());
            while (resAP.evalXPath() != -1) {
                String resourceName = this.getResourceName(document, group);
                LOG.debug("fillCollectionSet: processing XML resource {}", (Object)resourceName);
                Object collectionResource = group.getResourceType().equalsIgnoreCase("node") ? nodeResource : this.getCollectionResource(agent, resourceName, group.getResourceType(), timestamp);
                LOG.debug("fillCollectionSet: processing resource {}", collectionResource);
                AttributeGroupType attribGroupType = new AttributeGroupType(group.getName(), group.getIfType());
                for (XmlObject object : group.getXmlObjects()) {
                    XmlCollectionAttributeType attribType = new XmlCollectionAttributeType(object, attribGroupType);
                    document.push();
                    AutoPilot ap = new AutoPilot();
                    ap.bind(document);
                    ap.selectXPath(object.getXpath());
                    String value = ap.evalXPathToString();
                    document.pop();
                    collectionResource.setAttributeValue(attribType, value);
                }
                this.processXmlResource((XmlCollectionResource)collectionResource, attribGroupType);
                collectionSet.getCollectionResources().add(collectionResource);
            }
        }
    }

    protected Date getTimeStamp(VTDNav document, XmlGroup group) throws XPathParseException {
        if (group.getTimestampXpath() == null) {
            return null;
        }
        String pattern = group.getTimestampFormat() == null ? "yyyy-MM-dd HH:mm:ss" : group.getTimestampFormat();
        LOG.debug("getTimeStamp: retrieving custom timestamp to be used when updating RRDs using XPATH {} and pattern {}", (Object)group.getTimestampXpath(), (Object)pattern);
        document.push();
        AutoPilot ap = new AutoPilot();
        ap.bind(document);
        ap.selectXPath(group.getTimestampXpath());
        String value = ap.evalXPathToString();
        document.pop();
        if (value == null || value.isEmpty()) {
            LOG.warn("getTimeStamp: can't find the custom timestamp using XPATH {}", (Object)group.getTimestampXpath());
            return null;
        }
        Date date = null;
        try {
            DateTimeFormatter dtf = DateTimeFormat.forPattern((String)pattern);
            DateTime dateTime = dtf.parseDateTime(value);
            date = dateTime.toDate();
        }
        catch (Exception e) {
            LOG.warn("getTimeStamp: can't convert custom timetime {} using pattern {}", (Object)value, (Object)pattern);
            date = DateTime.now().toDate();
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VTDNav getVTDXmlDocument(String urlString, Request request) throws Exception {
        VTDNav vTDNav;
        InputStream is = null;
        URLConnection c = null;
        try {
            URL url = UrlFactory.getUrl((String)urlString, (Request)request);
            LOG.debug("getXmlDocument: got url");
            c = url.openConnection();
            LOG.debug("getXmlDocument: got connection");
            is = c.getInputStream();
            LOG.debug("getXmlDocument: got input stream");
            VTDNav nav = this.getVTDXmlDocument(is, request);
            LOG.debug("getXmlDocument: returning VTDNav");
            vTDNav = nav;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            UrlFactory.disconnect(c);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        UrlFactory.disconnect((URLConnection)c);
        return vTDNav;
    }

    protected VTDNav getVTDXmlDocument(InputStream is, Request request) throws Exception {
        is = this.preProcessHtml(request, is);
        is = this.applyXsltTransformation(request, is);
        VTDGen vg = new VTDGen();
        vg.setDoc(IOUtils.toByteArray((InputStream)is));
        vg.parse(true);
        VTDNav nav = vg.getNav();
        return nav;
    }
}

