/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.vtdxml;

import com.ximpleware.VTDNav;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.protocols.sftp.Sftp3gppUrlConnection;
import org.opennms.protocols.xml.collector.Sftp3gppUtils;
import org.opennms.protocols.xml.collector.UrlFactory;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.opennms.protocols.xml.collector.XmlCollectionSet;
import org.opennms.protocols.xml.config.Request;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.config.XmlSource;
import org.opennms.protocols.xml.vtdxml.AbstractVTDXmlCollectionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sftp3gppVTDXmlCollectionHandler
extends AbstractVTDXmlCollectionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Sftp3gppVTDXmlCollectionHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlCollectionSet collect(CollectionAgent agent, XmlDataCollection collection, Map<String, Object> parameters) throws CollectionException {
        XmlCollectionSet xmlCollectionSet;
        XmlCollectionSet collectionSet = new XmlCollectionSet();
        collectionSet.setCollectionTimestamp(new Date());
        collectionSet.setStatus(0);
        Map params = this.filterParameters(parameters);
        DateTime startTime = new DateTime();
        Sftp3gppUrlConnection connection = null;
        try {
            ResourcePath resourcePath = ResourcePath.get((String[])new String[]{Integer.toString(agent.getNodeId())});
            for (XmlSource source : collection.getXmlSources()) {
                if (!source.getUrl().startsWith("sftp.3gpp")) {
                    throw new CollectionException("The 3GPP SFTP Collection Handler can only use the protocol sftp.3gpp");
                }
                String urlStr = this.parseUrl(source.getUrl(), agent, collection.getXmlRrd().getStep(), params);
                Request request = this.parseRequest(source.getRequest(), agent, collection.getXmlRrd().getStep(), params);
                URL url = UrlFactory.getUrl((String)urlStr, (Request)request);
                String lastFile = Sftp3gppUtils.getLastFilename((ResourceStorageDao)this.getResourceStorageDao(), (String)this.getServiceName(), (ResourcePath)resourcePath, (String)url.getPath());
                connection = (Sftp3gppUrlConnection)url.openConnection();
                if (lastFile == null) {
                    lastFile = connection.get3gppFileName();
                    LOG.debug("collect(single): retrieving file from {}{}{} from {}", new Object[]{url.getPath(), Character.valueOf(File.separatorChar), lastFile, agent.getHostAddress()});
                    VTDNav doc = this.getVTDXmlDocument(urlStr, request);
                    this.fillCollectionSet(agent, collectionSet, source, doc);
                    Sftp3gppUtils.setLastFilename((ResourceStorageDao)this.getResourceStorageDao(), (String)this.getServiceName(), (ResourcePath)resourcePath, (String)url.getPath(), (String)lastFile);
                    Sftp3gppUtils.deleteFile((Sftp3gppUrlConnection)connection, (String)lastFile);
                    continue;
                }
                connection.connect();
                List files = connection.getFileList();
                long lastTs = connection.getTimeStampFromFile(lastFile);
                boolean collected = false;
                for (String fileName : files) {
                    if (connection.getTimeStampFromFile(fileName) <= lastTs) continue;
                    LOG.debug("collect(multiple): retrieving file {} from {}", (Object)fileName, (Object)agent.getHostAddress());
                    InputStream is = connection.getFile(fileName);
                    try {
                        VTDNav doc = this.getVTDXmlDocument(is, request);
                        this.fillCollectionSet(agent, collectionSet, source, doc);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)is);
                    }
                    Sftp3gppUtils.setLastFilename((ResourceStorageDao)this.getResourceStorageDao(), (String)this.getServiceName(), (ResourcePath)resourcePath, (String)url.getPath(), (String)fileName);
                    Sftp3gppUtils.deleteFile((Sftp3gppUrlConnection)connection, (String)fileName);
                    collected = true;
                }
                if (collected) continue;
                LOG.warn("collect: could not find any file after {} on {}", (Object)lastFile, (Object)agent);
            }
            collectionSet.setStatus(1);
            xmlCollectionSet = collectionSet;
        }
        catch (Exception e) {
            try {
                collectionSet.setStatus(2);
                throw new CollectionException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                String status = collectionSet.getStatus() == 1 ? "finished" : "failed";
                DateTime endTime = new DateTime();
                LOG.debug("collect: {} collection {}: duration: {} ms", new Object[]{status, collection.getName(), endTime.getMillis() - startTime.getMillis()});
                UrlFactory.disconnect(connection);
                throw throwable;
            }
        }
        String status = collectionSet.getStatus() == 1 ? "finished" : "failed";
        DateTime endTime = new DateTime();
        LOG.debug("collect: {} collection {}: duration: {} ms", new Object[]{status, collection.getName(), endTime.getMillis() - startTime.getMillis()});
        UrlFactory.disconnect(connection);
        return xmlCollectionSet;
    }

    protected void fillCollectionSet(String urlString, Request request, CollectionAgent agent, XmlCollectionSet collectionSet, XmlSource source) throws Exception {
    }

    protected void processXmlResource(XmlCollectionResource resource, AttributeGroupType attribGroupType) {
        Sftp3gppUtils.processXmlResource((XmlCollectionResource)resource, (AttributeGroupType)attribGroupType);
    }
}

