/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.vmware;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.provision.persist.RequisitionRequest;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.service.vmware.RequisitionXmlAdapter;
import org.opennms.netmgt.provision.service.vmware.VmwareImportRequestAttribute;

@XmlRootElement(name="vmware-requisition-request")
@XmlAccessorType(value=XmlAccessType.NONE)
public class VmwareImportRequest
implements RequisitionRequest {
    private static final String VMWARE_HOSTSYSTEM_SERVICES = "hostSystemServices";
    private static final String VMWARE_VIRTUALMACHINE_SERVICES = "virtualMachineServices";
    private static final List<String> DEFAULT_HOST_SYSTEM_SERVICES = Arrays.asList("VMware-ManagedEntity", "VMware-HostSystem", "VMwareCim-HostSystem");
    private static final List<String> DEFAULT_VIRTUAL_MACHINE_SERVICES = Arrays.asList("VMware-ManagedEntity", "VMware-VirtualMachine");
    @XmlAttribute(name="hostname")
    private String hostname = null;
    @XmlAttribute(name="username")
    private String username = null;
    @XmlAttribute(name="password")
    private String password = null;
    @XmlAttribute(name="location")
    private String location = null;
    @XmlAttribute(name="foreign-source")
    private String foreignSource = null;
    @XmlAttribute(name="import-vm-powered-on")
    private boolean importVMPoweredOn = true;
    @XmlAttribute(name="import-vm-powered-off")
    private boolean importVMPoweredOff = false;
    @XmlAttribute(name="import-vm-suspended")
    private boolean importVMSuspended = false;
    @XmlAttribute(name="import-host-powered-on")
    private boolean importHostPoweredOn = true;
    @XmlAttribute(name="import-host-powered-off")
    private boolean importHostPoweredOff = false;
    @XmlAttribute(name="import-host-standby")
    private boolean importHostStandBy = false;
    @XmlAttribute(name="import-host-unknown")
    private boolean importHostUnknown = false;
    @XmlAttribute(name="persist-ipv4")
    private boolean persistIPv4 = true;
    @XmlAttribute(name="persist-ipv6")
    private boolean persistIPv6 = true;
    @XmlAttribute(name="persist-vms")
    private boolean persistVMs = true;
    @XmlAttribute(name="persist-hosts")
    private boolean persistHosts = true;
    @XmlAttribute(name="topology-port-groups")
    private boolean topologyPortGroups = false;
    @XmlAttribute(name="topology-networks")
    private boolean topologyNetworks = true;
    @XmlAttribute(name="topology-datastores")
    private boolean topologyDatastores = true;
    @XmlElement(name="host-system-service")
    private List<String> hostSystemServices = null;
    @XmlElement(name="virtual-machine-service")
    private List<String> virtualMachineServices = null;
    @XmlElement(name="custom-attribute")
    private List<VmwareImportRequestAttribute> customAttributes = new ArrayList<VmwareImportRequestAttribute>();
    @XmlAttribute(name="old-key")
    private String oldKey;
    @XmlAttribute(name="old-key")
    private String oldValue;
    @XmlElement(name="existing-requisition")
    @XmlJavaTypeAdapter(value=RequisitionXmlAdapter.class)
    private Requisition existingRequisition;
    @XmlAttribute(name="timeout")
    private int timeout = 3000;
    @XmlAttribute(name="cim-timeout")
    private int cimTimeout = 3000;

    public VmwareImportRequest() {
    }

    public VmwareImportRequest(Map<String, String> params) {
        String path;
        this.setHostname(params.get("host"));
        this.setUsername(params.get("username"));
        this.setPassword(params.get("password"));
        this.setLocation(params.get("location"));
        if (params.containsKey("timeout")) {
            try {
                this.setTimeout(Integer.parseInt(params.get("timeout")));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Error parsing timeout parameter", e);
            }
        }
        if (params.containsKey("cimTimeout")) {
            try {
                this.setCimTimeout(Integer.parseInt(params.get("cimTimeout")));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Error parsing cimTimeout parameter", e);
            }
        }
        boolean importVMOnly = VmwareImportRequest.queryParameter(params, "importVMOnly", false);
        boolean importHostOnly = VmwareImportRequest.queryParameter(params, "importHostOnly", false);
        if (importHostOnly && importVMOnly) {
            throw new IllegalArgumentException("importHostOnly and importVMOnly can't be true simultaneously");
        }
        if (importHostOnly) {
            this.setPersistVMs(false);
        }
        if (importVMOnly) {
            this.setPersistHosts(false);
        }
        boolean importIPv4Only = VmwareImportRequest.queryParameter(params, "importIPv4Only", false);
        boolean importIPv6Only = VmwareImportRequest.queryParameter(params, "importIPv6Only", false);
        if (importIPv4Only && importIPv6Only) {
            throw new IllegalArgumentException("importIPv4Only and importIPv6Only can't be true simultaneously");
        }
        if (importIPv4Only) {
            this.setPersistIPv6(false);
        }
        if (importIPv6Only) {
            this.setPersistIPv4(false);
        }
        this.setTopologyPortGroups(VmwareImportRequest.queryParameter(params, "topologyPortGroups", false));
        this.setTopologyNetworks(VmwareImportRequest.queryParameter(params, "topologyNetworks", true));
        this.setTopologyDatastores(VmwareImportRequest.queryParameter(params, "topologyDatastores", true));
        this.setImportVMPoweredOn(VmwareImportRequest.queryParameter(params, "importVMPoweredOn", true));
        this.setImportVMPoweredOff(VmwareImportRequest.queryParameter(params, "importVMPoweredOff", false));
        this.setImportVMSuspended(VmwareImportRequest.queryParameter(params, "importVMSuspended", false));
        this.setImportHostPoweredOn(VmwareImportRequest.queryParameter(params, "importHostPoweredOn", true));
        this.setImportHostPoweredOff(VmwareImportRequest.queryParameter(params, "importHostPoweredOff", false));
        this.setImportHostStandBy(VmwareImportRequest.queryParameter(params, "importHostStandBy", false));
        this.setImportHostUnknown(VmwareImportRequest.queryParameter(params, "importHostUnknown", false));
        if (VmwareImportRequest.queryParameter(params, "importHostAll", false)) {
            this.setImportHostPoweredOn(true);
            this.setImportHostPoweredOff(true);
            this.setImportHostStandBy(true);
            this.setImportHostUnknown(true);
        }
        if (VmwareImportRequest.queryParameter(params, "importVMAll", false)) {
            this.setImportVMPoweredOff(true);
            this.setImportVMPoweredOn(true);
            this.setImportVMSuspended(true);
        }
        if ((path = params.get("path")) == null) {
            throw new IllegalArgumentException("path is required");
        }
        path = path.replaceAll("^/", "");
        String[] pathElements = (path = path.replaceAll("/$", "")).split("/");
        if (pathElements.length == 1) {
            if ("".equals(pathElements[0])) {
                this.setForeignSource("vmware-" + this.getHostname());
            } else {
                this.setForeignSource(pathElements[0]);
            }
        } else {
            throw new IllegalArgumentException("Error processing path element of URL (vmware://host[/foreign-source]?keyA=valueA;keyB=valueB;...)");
        }
        if (params.get(VMWARE_HOSTSYSTEM_SERVICES) != null) {
            this.setHostSystemServices(Arrays.asList(params.get(VMWARE_HOSTSYSTEM_SERVICES).split(",")));
        }
        if (params.get(VMWARE_VIRTUALMACHINE_SERVICES) != null) {
            this.setVirtualMachineServices(Arrays.asList(params.get(VMWARE_VIRTUALMACHINE_SERVICES).split(",")));
        }
        HashMap<String, String> customAttributes = new HashMap<String, String>();
        for (String k : params.keySet()) {
            if (!k.startsWith("_")) continue;
            customAttributes.put(k, params.get(k));
        }
        this.setCustomAttributes(customAttributes);
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getForeignSource() {
        return this.foreignSource;
    }

    public void setForeignSource(String foreignSource) {
        this.foreignSource = foreignSource;
    }

    public boolean isImportVMPoweredOn() {
        return this.importVMPoweredOn;
    }

    public void setImportVMPoweredOn(boolean importVMPoweredOn) {
        this.importVMPoweredOn = importVMPoweredOn;
    }

    public boolean isImportVMPoweredOff() {
        return this.importVMPoweredOff;
    }

    public void setImportVMPoweredOff(boolean importVMPoweredOff) {
        this.importVMPoweredOff = importVMPoweredOff;
    }

    public boolean isImportVMSuspended() {
        return this.importVMSuspended;
    }

    public void setImportVMSuspended(boolean importVMSuspended) {
        this.importVMSuspended = importVMSuspended;
    }

    public boolean isImportHostPoweredOn() {
        return this.importHostPoweredOn;
    }

    public void setImportHostPoweredOn(boolean importHostPoweredOn) {
        this.importHostPoweredOn = importHostPoweredOn;
    }

    public boolean isImportHostPoweredOff() {
        return this.importHostPoweredOff;
    }

    public void setImportHostPoweredOff(boolean importHostPoweredOff) {
        this.importHostPoweredOff = importHostPoweredOff;
    }

    public boolean isImportHostStandBy() {
        return this.importHostStandBy;
    }

    public void setImportHostStandBy(boolean importHostStandBy) {
        this.importHostStandBy = importHostStandBy;
    }

    public boolean isImportHostUnknown() {
        return this.importHostUnknown;
    }

    public void setImportHostUnknown(boolean importHostUnknown) {
        this.importHostUnknown = importHostUnknown;
    }

    public boolean isPersistIPv4() {
        return this.persistIPv4;
    }

    public void setPersistIPv4(boolean persistIPv4) {
        this.persistIPv4 = persistIPv4;
    }

    public boolean isPersistIPv6() {
        return this.persistIPv6;
    }

    public void setPersistIPv6(boolean persistIPv6) {
        this.persistIPv6 = persistIPv6;
    }

    public boolean isPersistVMs() {
        return this.persistVMs;
    }

    public void setPersistVMs(boolean persistVMs) {
        this.persistVMs = persistVMs;
    }

    public boolean isPersistHosts() {
        return this.persistHosts;
    }

    public void setPersistHosts(boolean persistHosts) {
        this.persistHosts = persistHosts;
    }

    public boolean isTopologyPortGroups() {
        return this.topologyPortGroups;
    }

    public void setTopologyPortGroups(boolean topologyPortGroups) {
        this.topologyPortGroups = topologyPortGroups;
    }

    public boolean isTopologyNetworks() {
        return this.topologyNetworks;
    }

    public void setTopologyNetworks(boolean topologyNetworks) {
        this.topologyNetworks = topologyNetworks;
    }

    public boolean isTopologyDatastores() {
        return this.topologyDatastores;
    }

    public void setTopologyDatastores(boolean topologyDatastores) {
        this.topologyDatastores = topologyDatastores;
    }

    public List<String> getHostSystemServices() {
        return this.hostSystemServices != null ? this.hostSystemServices : DEFAULT_HOST_SYSTEM_SERVICES;
    }

    public void setHostSystemServices(List<String> hostSystemServices) {
        this.hostSystemServices = hostSystemServices;
    }

    public List<String> getVirtualMachineServices() {
        return this.virtualMachineServices != null ? this.virtualMachineServices : DEFAULT_VIRTUAL_MACHINE_SERVICES;
    }

    public void setVirtualMachineServices(List<String> virtualMachineServices) {
        this.virtualMachineServices = virtualMachineServices;
    }

    public List<VmwareImportRequestAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public Map<String, String> getCustomAttributesMap() {
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        for (VmwareImportRequestAttribute attr : this.customAttributes) {
            attributesMap.put(attr.getKey(), attr.getValue());
        }
        return attributesMap;
    }

    public void setCustomAttributes(List<VmwareImportRequestAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public void setCustomAttributes(Map<String, String> customAttributes) {
        this.customAttributes = customAttributes.entrySet().stream().map(e -> new VmwareImportRequestAttribute((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    public String getOldKey() {
        return this.oldKey;
    }

    public void setOldKey(String oldKey) {
        this.oldKey = oldKey;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public Requisition getExistingRequisition() {
        return this.existingRequisition;
    }

    public void setExistingRequisition(Requisition existingRequisition) {
        this.existingRequisition = existingRequisition;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getCimTimeout() {
        return this.cimTimeout;
    }

    public void setCimTimeout(int cimTimeout) {
        this.cimTimeout = cimTimeout;
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.username, this.password, this.location, this.foreignSource, this.importVMPoweredOn, this.importVMPoweredOff, this.importVMSuspended, this.importHostPoweredOn, this.importHostPoweredOff, this.importHostStandBy, this.importHostUnknown, this.persistIPv4, this.persistIPv6, this.persistVMs, this.persistHosts, this.topologyPortGroups, this.topologyNetworks, this.topologyDatastores, this.hostSystemServices, this.virtualMachineServices, this.customAttributes, this.oldKey, this.oldValue, this.existingRequisition, this.timeout, this.cimTimeout);
    }

    public boolean equals(Object other) {
        if (!(other instanceof VmwareImportRequest)) {
            return false;
        }
        VmwareImportRequest castOther = (VmwareImportRequest)other;
        return Objects.equals(this.hostname, castOther.hostname) && Objects.equals(this.username, castOther.username) && Objects.equals(this.password, castOther.password) && Objects.equals(this.location, castOther.location) && Objects.equals(this.foreignSource, castOther.foreignSource) && Objects.equals(this.importVMPoweredOn, castOther.importVMPoweredOn) && Objects.equals(this.importVMPoweredOff, castOther.importVMPoweredOff) && Objects.equals(this.importVMSuspended, castOther.importVMSuspended) && Objects.equals(this.importHostPoweredOn, castOther.importHostPoweredOn) && Objects.equals(this.importHostPoweredOff, castOther.importHostPoweredOff) && Objects.equals(this.importHostStandBy, castOther.importHostStandBy) && Objects.equals(this.importHostUnknown, castOther.importHostUnknown) && Objects.equals(this.persistIPv4, castOther.persistIPv4) && Objects.equals(this.persistIPv6, castOther.persistIPv6) && Objects.equals(this.persistVMs, castOther.persistVMs) && Objects.equals(this.persistHosts, castOther.persistHosts) && Objects.equals(this.topologyPortGroups, castOther.topologyPortGroups) && Objects.equals(this.topologyNetworks, castOther.topologyNetworks) && Objects.equals(this.topologyDatastores, castOther.topologyDatastores) && Objects.equals(this.hostSystemServices, castOther.hostSystemServices) && Objects.equals(this.virtualMachineServices, castOther.virtualMachineServices) && Objects.equals(this.customAttributes, castOther.customAttributes) && Objects.equals(this.oldKey, castOther.oldKey) && Objects.equals(this.oldValue, castOther.oldValue) && Objects.equals(this.existingRequisition, castOther.existingRequisition) && Objects.equals(this.timeout, castOther.timeout) && Objects.equals(this.cimTimeout, castOther.cimTimeout);
    }

    private static boolean queryParameter(Map<String, String> parms, String key, boolean defaultValue) {
        if (parms.get(key) == null) {
            return defaultValue;
        }
        String value = parms.get(key).toLowerCase();
        return "yes".equals(value) || "true".equals(value) || "on".equals(value) || "1".equals(value);
    }
}

