/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import com.google.common.base.Strings;
import com.vmware.vim25.mo.ManagedEntity;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collectd.vmware.vijava.VmwarePerformanceValues;
import org.opennms.netmgt.collection.api.AbstractRemoteServiceCollector;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.DeferredGenericTypeResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.vmware.VmwareServer;
import org.opennms.netmgt.config.vmware.vijava.Attrib;
import org.opennms.netmgt.config.vmware.vijava.VmwareCollection;
import org.opennms.netmgt.config.vmware.vijava.VmwareGroup;
import org.opennms.netmgt.dao.VmwareConfigDao;
import org.opennms.netmgt.dao.VmwareDatacollectionConfigDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.protocols.vmware.VmwareViJavaAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareCollector
extends AbstractRemoteServiceCollector {
    private static final Logger logger = LoggerFactory.getLogger(VmwareCollector.class);
    private static final String VMWARE_COLLECTION_KEY = "vmwareCollection";
    private static final String VMWARE_MGMT_SERVER_KEY = "vmwareManagementServer";
    private static final String VMWARE_MGED_OBJECT_ID_KEY = "vmwareManagedObjectId";
    private static final String VMWARE_SERVER_KEY = "vmwareServer";
    private static final Map<String, Class<?>> TYPE_MAP = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, Class<VmwareCollection>>("vmwareCollection", VmwareCollection.class), new AbstractMap.SimpleEntry<String, Class<VmwareServer>>("vmwareServer", VmwareServer.class)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Class)e.getValue())));
    private NodeDao m_nodeDao = null;
    private VmwareDatacollectionConfigDao m_vmwareDatacollectionConfigDao;
    private VmwareConfigDao m_vmwareConfigDao = null;

    public VmwareCollector() {
        super(TYPE_MAP);
    }

    public void initialize() throws CollectionInitializationException {
        if (this.m_nodeDao == null) {
            this.m_nodeDao = (NodeDao)BeanUtils.getBean((String)"daoContext", (String)"nodeDao", NodeDao.class);
        }
        if (this.m_nodeDao == null) {
            logger.error("Node dao should be a non-null value.");
        }
        if (this.m_vmwareDatacollectionConfigDao == null) {
            this.m_vmwareDatacollectionConfigDao = (VmwareDatacollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"vmwareDatacollectionConfigDao", VmwareDatacollectionConfigDao.class);
        }
        if (this.m_vmwareDatacollectionConfigDao == null) {
            logger.error("vmwareDatacollectionConfigDao should be a non-null value.");
        }
        if (this.m_vmwareConfigDao == null) {
            this.m_vmwareConfigDao = (VmwareConfigDao)BeanUtils.getBean((String)"daoContext", (String)"vmwareConfigDao", VmwareConfigDao.class);
        }
    }

    public Map<String, Object> getRuntimeAttributes(CollectionAgent agent, Map<String, Object> parameters) {
        HashMap<String, Object> runtimeAttributes = new HashMap<String, Object>();
        OnmsNode onmsNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(agent.getNodeId()));
        if (onmsNode == null) {
            throw new IllegalArgumentException(String.format("VmwareCollector: No node found with id: %d", agent.getNodeId()));
        }
        String vmwareManagementServer = onmsNode.getAssetRecord().getVmwareManagementServer();
        if (Strings.isNullOrEmpty((String)vmwareManagementServer)) {
            throw new IllegalArgumentException(String.format("VmwareCollector: No management server is set on node with id %d.", onmsNode.getId()));
        }
        runtimeAttributes.put(VMWARE_MGMT_SERVER_KEY, vmwareManagementServer);
        String vmwareManagedObjectId = onmsNode.getForeignId();
        if (Strings.isNullOrEmpty((String)vmwareManagedObjectId)) {
            throw new IllegalArgumentException(String.format("VmwareCollector: No foreign id is set on node with id %d.", onmsNode.getId()));
        }
        runtimeAttributes.put(VMWARE_MGED_OBJECT_ID_KEY, vmwareManagedObjectId);
        String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", (String)ParameterMap.getKeyedString(parameters, (String)"vmware-collection", null));
        VmwareCollection collection = this.m_vmwareDatacollectionConfigDao.getVmwareCollection(collectionName);
        if (collection == null) {
            throw new IllegalArgumentException(String.format("VmwareCollector: No collection found with name '%s'.", collectionName));
        }
        runtimeAttributes.put(VMWARE_COLLECTION_KEY, collection);
        Map<String, VmwareServer> serverMap = this.m_vmwareConfigDao.getServerMap();
        if (serverMap == null) {
            throw new IllegalStateException(String.format("VmwareCollector: Error getting vmware-config.xml's server map.", new Object[0]));
        }
        VmwareServer vmwareServer = serverMap.get(vmwareManagementServer);
        if (vmwareServer == null) {
            throw new IllegalStateException(String.format("VmwareCollector: Error getting credentials for VMware management server: %s", vmwareManagementServer));
        }
        runtimeAttributes.put(VMWARE_SERVER_KEY, vmwareServer);
        return runtimeAttributes;
    }

    public CollectionSet collect(CollectionAgent agent, Map<String, Object> parameters) throws CollectionException {
        VmwareCollection collection = (VmwareCollection)parameters.get(VMWARE_COLLECTION_KEY);
        String vmwareManagementServer = (String)parameters.get(VMWARE_MGMT_SERVER_KEY);
        String vmwareManagedObjectId = (String)parameters.get(VMWARE_MGED_OBJECT_ID_KEY);
        VmwareServer vmwareServer = (VmwareServer)parameters.get(VMWARE_SERVER_KEY);
        CollectionSetBuilder builder = new CollectionSetBuilder(agent);
        builder.withStatus(CollectionStatus.FAILED);
        VmwareViJavaAccess vmwareViJavaAccess = new VmwareViJavaAccess(vmwareServer);
        if (collection.getVmwareGroup().length < 1) {
            logger.info("No groups to collect. Returning empty collection set.");
            builder.withStatus(CollectionStatus.SUCCEEDED);
            return builder.build();
        }
        try {
            vmwareViJavaAccess.connect();
        }
        catch (MalformedURLException e) {
            logger.warn("Error connecting VMware management server '{}': '{}' exception: {} cause: '{}'", new Object[]{vmwareManagementServer, e.getMessage(), e.getClass().getName(), e.getCause()});
            return builder.build();
        }
        catch (RemoteException e) {
            logger.warn("Error connecting VMware management server '{}': '{}' exception: {} cause: '{}'", new Object[]{vmwareManagementServer, e.getMessage(), e.getClass().getName(), e.getCause()});
            return builder.build();
        }
        int timeout = ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)3000);
        if (!vmwareViJavaAccess.setTimeout(timeout)) {
            logger.warn("Error setting connection timeout for VMware management server '{}'", (Object)vmwareManagementServer);
        }
        ManagedEntity managedEntity = vmwareViJavaAccess.getManagedEntityByManagedObjectId(vmwareManagedObjectId);
        VmwarePerformanceValues vmwarePerformanceValues = null;
        try {
            vmwarePerformanceValues = vmwareViJavaAccess.queryPerformanceValues(managedEntity);
        }
        catch (RemoteException e) {
            logger.warn("Error retrieving performance values from VMware management server '" + vmwareManagementServer + "' for managed object '" + vmwareManagedObjectId + "'", (Object)e.getMessage());
            vmwareViJavaAccess.disconnect();
            return builder.build();
        }
        for (VmwareGroup vmwareGroup : collection.getVmwareGroup()) {
            NodeLevelResource nodeResource = new NodeLevelResource(agent.getNodeId());
            if ("node".equalsIgnoreCase(vmwareGroup.getResourceType())) {
                for (Attrib attrib : vmwareGroup.getAttrib()) {
                    if (!vmwarePerformanceValues.hasSingleValue(attrib.getName())) {
                        logger.debug("Warning! No single value for '{}' defined as single instance attribute for node {}", (Object)attrib.getName(), (Object)agent.getNodeId());
                        continue;
                    }
                    Long value = vmwarePerformanceValues.getValue(attrib.getName());
                    logger.debug("Storing single instance value {}='{}' for node {}", new Object[]{attrib.getName(), value, agent.getNodeId()});
                    AttributeType type = attrib.getType();
                    if (type.isNumeric()) {
                        builder.withNumericAttribute((Resource)nodeResource, vmwareGroup.getName(), attrib.getAlias(), (Number)value, type);
                        continue;
                    }
                    builder.withStringAttribute((Resource)nodeResource, vmwareGroup.getName(), attrib.getAlias(), String.valueOf(value));
                }
                continue;
            }
            TreeSet<String> instanceSet = new TreeSet<String>();
            HashMap<String, DeferredGenericTypeResource> resources = new HashMap<String, DeferredGenericTypeResource>();
            for (Attrib attrib : vmwareGroup.getAttrib()) {
                if (!vmwarePerformanceValues.hasInstances(attrib.getName())) {
                    logger.debug("Warning! No multi instance value for '{}' defined as multi instance attribute for node {}", (Object)attrib.getName(), (Object)agent.getNodeId());
                    continue;
                }
                Set<String> newInstances = vmwarePerformanceValues.getInstances(attrib.getName());
                for (String instance : newInstances) {
                    if (!instanceSet.contains(instance)) {
                        resources.put(instance, new DeferredGenericTypeResource(nodeResource, vmwareGroup.getResourceType(), instance));
                        instanceSet.add(instance);
                    }
                    AttributeType type = attrib.getType();
                    Long value = vmwarePerformanceValues.getValue(attrib.getName(), instance);
                    logger.debug("Storing multi instance value {}[{}='{}' for node {}", new Object[]{attrib.getName(), instance, value, agent.getNodeId()});
                    if (type.isNumeric()) {
                        builder.withNumericAttribute((Resource)resources.get(instance), vmwareGroup.getName(), attrib.getAlias(), (Number)value, type);
                        continue;
                    }
                    builder.withStringAttribute((Resource)resources.get(instance), vmwareGroup.getName(), attrib.getAlias(), Long.toString(value));
                }
            }
            for (String instance : instanceSet) {
                logger.debug("Storing multi instance value {}[{}='{}' for node {}", new Object[]{vmwareGroup.getResourceType() + "Name", instance, instance, agent.getNodeId()});
                builder.withStringAttribute((Resource)resources.get(instance), vmwareGroup.getName(), vmwareGroup.getResourceType() + "Name", instance);
            }
        }
        builder.withStatus(CollectionStatus.SUCCEEDED);
        vmwareViJavaAccess.disconnect();
        return builder.build();
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_vmwareDatacollectionConfigDao.getRrdRepository(collectionName);
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }
}

