/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import java.io.File;
import java.util.List;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.netmgt.config.vmware.vijava.VmwareCollection;
import org.opennms.netmgt.config.vmware.vijava.VmwareDatacollectionConfig;
import org.opennms.netmgt.dao.VmwareDatacollectionConfigDao;
import org.opennms.netmgt.rrd.RrdRepository;

public class VmwareDatacollectionConfigDaoJaxb
extends AbstractJaxbConfigDao<VmwareDatacollectionConfig, VmwareDatacollectionConfig>
implements VmwareDatacollectionConfigDao {
    public VmwareDatacollectionConfigDaoJaxb() {
        super(VmwareDatacollectionConfig.class, "Vmware Data Collection Configuration");
    }

    @Override
    public VmwareDatacollectionConfig getConfig() {
        return (VmwareDatacollectionConfig)this.getContainer().getObject();
    }

    public VmwareDatacollectionConfig translateConfig(VmwareDatacollectionConfig jaxbConfig) {
        return jaxbConfig;
    }

    @Override
    public VmwareCollection getVmwareCollection(String collectionName) {
        VmwareCollection[] collections = this.getConfig().getVmwareCollection();
        VmwareCollection collection = null;
        for (VmwareCollection coll : collections) {
            if (!coll.getName().equalsIgnoreCase(collectionName)) continue;
            collection = coll;
            break;
        }
        if (collection == null) {
            throw new IllegalArgumentException("getVmwareCollection: collection name: " + collectionName + " specified in collectd configuration not found in Vmware collection configuration.");
        }
        return collection;
    }

    @Override
    public RrdRepository getRrdRepository(String collectionName) {
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File(this.getRrdPath()));
        repo.setRraList(this.getRRAList(collectionName));
        repo.setStep(this.getStep(collectionName));
        repo.setHeartBeat(2 * this.getStep(collectionName));
        return repo;
    }

    private int getStep(String cName) {
        VmwareCollection collection = this.getVmwareCollection(cName);
        if (collection != null) {
            return collection.getRrd().getStep();
        }
        return -1;
    }

    private List<String> getRRAList(String cName) {
        VmwareCollection collection = this.getVmwareCollection(cName);
        if (collection != null) {
            return collection.getRrd().getRraCollection();
        }
        return null;
    }

    @Override
    public String getRrdPath() {
        String rrdPath = this.getConfig().getRrdRepository();
        if (rrdPath == null) {
            throw new RuntimeException("Configuration error, failed to retrieve path to RRD repository.");
        }
        if (rrdPath.endsWith(File.separator)) {
            rrdPath = rrdPath.substring(0, rrdPath.length() - File.separator.length());
        }
        return rrdPath;
    }
}

