/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.vmware;

import com.vmware.vim25.mo.ServiceInstance;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.protocols.vmware.ServiceInstancePoolEntry;

public class ServiceInstancePool {
    private final long HOUSEKEEPING_INTERVAL = PropertiesUtils.getProperty((Properties)System.getProperties(), (String)"org.opennms.protocols.vmware.housekeepingInterval", (long)300000L);
    private final Map<String, ServiceInstancePoolEntry> serviceInstancePoolEntries = new ConcurrentHashMap<String, ServiceInstancePoolEntry>();
    private final Timer timer = new Timer("ServiceInstancePool-Timer", false);

    public ServiceInstancePool() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ServiceInstancePool.this.expire();
            }
        }, this.HOUSEKEEPING_INTERVAL, this.HOUSEKEEPING_INTERVAL);
    }

    private synchronized void expire() {
        Iterator<Map.Entry<String, ServiceInstancePoolEntry>> mapIterator = this.serviceInstancePoolEntries.entrySet().iterator();
        while (mapIterator.hasNext()) {
            Map.Entry<String, ServiceInstancePoolEntry> mapEntry = mapIterator.next();
            mapEntry.getValue().expire(this.HOUSEKEEPING_INTERVAL);
            if (!mapEntry.getValue().isUnused()) continue;
            mapIterator.remove();
        }
    }

    protected boolean validate(ServiceInstance serviceInstance) {
        if (serviceInstance == null || serviceInstance.getSessionManager() == null) {
            return false;
        }
        return serviceInstance.getSessionManager().getCurrentSession() != null;
    }

    protected ServiceInstance create(String hostname, String username, String password) throws MalformedURLException, RemoteException {
        return new ServiceInstance(new URL("https://" + hostname + "/sdk"), username, password);
    }

    public synchronized ServiceInstance retain(String host, String username, String password) throws MalformedURLException, RemoteException {
        return this.serviceInstancePoolEntries.computeIfAbsent(host + "/" + username + "/" + password, k -> new ServiceInstancePoolEntry(this, host, username, password)).retain();
    }

    public synchronized void release(ServiceInstance serviceInstance) {
        if (serviceInstance == null) {
            return;
        }
        for (Map.Entry<String, ServiceInstancePoolEntry> entry : this.serviceInstancePoolEntries.entrySet()) {
            entry.getValue().release(serviceInstance);
        }
    }

    public int lockedEntryCount(String key) {
        return this.serviceInstancePoolEntries.containsKey(key) ? this.serviceInstancePoolEntries.get(key).lockedEntryCount() : 0;
    }

    public int unlockedEntryCount(String key) {
        return this.serviceInstancePoolEntries.containsKey(key) ? this.serviceInstancePoolEntries.get(key).unlockedEntryCount() : 0;
    }

    public int lockedEntryCount() {
        return this.serviceInstancePoolEntries.values().stream().mapToInt(e -> e.lockedEntryCount()).sum();
    }

    public int unlockedEntryCount() {
        return this.serviceInstancePoolEntries.values().stream().mapToInt(e -> e.unlockedEntryCount()).sum();
    }
}

