/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.vmware.vim25.HostRuntimeInfo;
import com.vmware.vim25.HostSystemPowerState;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.VirtualMachine;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Map;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractVmwareMonitor;
import org.opennms.protocols.vmware.VmwareViJavaAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable(value={DistributionContext.DAEMON})
public class VmwareMonitor
extends AbstractVmwareMonitor {
    private final Logger logger = LoggerFactory.getLogger(VmwareMonitor.class);
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        boolean ignoreStandBy = VmwareMonitor.getKeyedBoolean(parameters, (String)"ignoreStandBy", (Boolean)false);
        String vmwareManagementServer = VmwareMonitor.getKeyedString(parameters, (String)"vmwareManagementServer", null);
        String vmwareManagedEntityType = VmwareMonitor.getKeyedString(parameters, (String)"vmwareManagedEntityType", null);
        String vmwareManagedObjectId = VmwareMonitor.getKeyedString(parameters, (String)"vmwareManagedObjectId", null);
        String vmwareMangementServerUsername = VmwareMonitor.getKeyedString(parameters, (String)"vmwareMangementServerUsername", null);
        String vmwareMangementServerPassword = VmwareMonitor.getKeyedString(parameters, (String)"vmwareMangementServerPassword", null);
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        PollStatus serviceStatus = PollStatus.unknown();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            VmwareViJavaAccess vmwareViJavaAccess = new VmwareViJavaAccess(vmwareManagementServer, vmwareMangementServerUsername, vmwareMangementServerPassword);
            try {
                vmwareViJavaAccess.connect();
            }
            catch (MalformedURLException e) {
                this.logger.warn("Error connecting VMware management server '{}': '{}' exception: {} cause: '{}'", new Object[]{vmwareManagementServer, e.getMessage(), e.getClass().getName(), e.getCause()});
                return PollStatus.unavailable((String)("Error connecting VMware management server '" + vmwareManagementServer + "'"));
            }
            catch (RemoteException e) {
                this.logger.warn("Error connecting VMware management server '{}': '{}' exception: {} cause: '{}'", new Object[]{vmwareManagementServer, e.getMessage(), e.getClass().getName(), e.getCause()});
                return PollStatus.unavailable((String)("Error connecting VMware management server '" + vmwareManagementServer + "'"));
            }
            if (!vmwareViJavaAccess.setTimeout(tracker.getConnectionTimeout())) {
                this.logger.warn("Error setting connection timeout for VMware management server '{}'", (Object)vmwareManagementServer);
            }
            String powerState = "unknown";
            if ("HostSystem".equals(vmwareManagedEntityType)) {
                HostSystem hostSystem = vmwareViJavaAccess.getHostSystemByManagedObjectId(vmwareManagedObjectId);
                if (hostSystem == null) {
                    return PollStatus.unknown((String)"hostSystem=null");
                }
                HostRuntimeInfo hostRuntimeInfo = hostSystem.getRuntime();
                if (hostRuntimeInfo == null) {
                    return PollStatus.unknown((String)"hostRuntimeInfo=null");
                }
                HostSystemPowerState hostSystemPowerState = hostRuntimeInfo.getPowerState();
                if (hostSystemPowerState == null) {
                    return PollStatus.unknown((String)"hostSystemPowerState=null");
                }
                powerState = hostSystemPowerState.toString();
            } else if ("VirtualMachine".equals(vmwareManagedEntityType)) {
                VirtualMachine virtualMachine = vmwareViJavaAccess.getVirtualMachineByManagedObjectId(vmwareManagedObjectId);
                if (virtualMachine == null) {
                    return PollStatus.unknown((String)"virtualMachine=null");
                }
                VirtualMachineRuntimeInfo virtualMachineRuntimeInfo = virtualMachine.getRuntime();
                if (virtualMachineRuntimeInfo == null) {
                    return PollStatus.unknown((String)"virtualMachineRuntimeInfo=null");
                }
                VirtualMachinePowerState virtualMachinePowerState = virtualMachineRuntimeInfo.getPowerState();
                if (virtualMachinePowerState == null) {
                    return PollStatus.unknown((String)"virtualMachinePowerState=null");
                }
                powerState = virtualMachinePowerState.toString();
            } else {
                this.logger.warn("Error getting '{}' for '{}'", (Object)vmwareManagedEntityType, (Object)vmwareManagedObjectId);
                vmwareViJavaAccess.disconnect();
                return serviceStatus;
            }
            serviceStatus = "poweredOn".equals(powerState) ? PollStatus.available() : (ignoreStandBy && "standBy".equals(powerState) ? PollStatus.up() : PollStatus.unavailable((String)("The system's state is '" + powerState + "'")));
            vmwareViJavaAccess.disconnect();
            tracker.nextAttempt();
        }
        return serviceStatus;
    }
}

