/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opennms.netmgt.dao.api.BridgeBridgeLinkDao;
import org.opennms.netmgt.dao.api.BridgeMacLinkDao;
import org.opennms.netmgt.dao.api.BridgeTopologyDao;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.topology.Bridge;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.opennms.netmgt.model.topology.SharedSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeTopologyDaoInMemory
implements BridgeTopologyDao {
    volatile Set<BroadcastDomain> m_domains;
    private static final Logger LOG = LoggerFactory.getLogger(BridgeTopologyDaoInMemory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(BroadcastDomain domain) {
        Set<BroadcastDomain> set = this.m_domains;
        synchronized (set) {
            this.m_domains.add(domain);
        }
    }

    public synchronized void load(BridgeBridgeLinkDao bridgeBridgeLinkDao, BridgeMacLinkDao bridgeMacLinkDao) {
        this.m_domains = this.getAllPersisted(bridgeBridgeLinkDao, bridgeMacLinkDao);
    }

    public List<SharedSegment> getBridgeNodeSharedSegments(BridgeBridgeLinkDao bridgeBridgeLinkDao, BridgeMacLinkDao bridgeMacLinkDao, int nodeid) {
        Object segment;
        ArrayList<SharedSegment> segments = new ArrayList<SharedSegment>();
        HashSet<Integer> designated = new HashSet<Integer>();
        block0: for (BridgeBridgeLink link : bridgeBridgeLinkDao.findByNodeId(Integer.valueOf(nodeid))) {
            for (SharedSegment segment2 : segments) {
                if (!segment2.containsPort(link.getNode().getId(), link.getBridgePort()) && !segment2.containsPort(link.getDesignatedNode().getId(), link.getDesignatedPort())) continue;
                segment2.add(link);
                designated.add(link.getDesignatedNode().getId());
                continue block0;
            }
            segment = new SharedSegment();
            segment.add(link);
            segment.setDesignatedBridge(link.getDesignatedNode().getId());
            segments.add((SharedSegment)segment);
        }
        designated.add(nodeid);
        for (Integer curNodeId : designated) {
            block3: for (BridgeBridgeLink link : bridgeBridgeLinkDao.findByDesignatedNodeId(curNodeId)) {
                for (SharedSegment segment3 : segments) {
                    if (!segment3.containsPort(link.getNode().getId(), link.getBridgePort()) && !segment3.containsPort(link.getDesignatedNode().getId(), link.getDesignatedPort())) continue;
                    segment3.add(link);
                    continue block3;
                }
                SharedSegment segment4 = new SharedSegment();
                segment4.add(link);
                segment4.setDesignatedBridge(link.getDesignatedNode().getId());
                segments.add(segment4);
            }
        }
        block5: for (BridgeBridgeLink link : bridgeMacLinkDao.findByNodeId(Integer.valueOf(nodeid))) {
            link.setBridgeDot1qTpFdbStatus(BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED);
            for (SharedSegment segment2 : segments) {
                if (!segment2.containsMac(link.getMacAddress()) && !segment2.containsPort(link.getNode().getId(), link.getBridgePort())) continue;
                segment2.add((BridgeMacLink)link);
                continue block5;
            }
            segment = new SharedSegment();
            segment.add((BridgeMacLink)link);
            segment.setDesignatedBridge(link.getNode().getId());
            segments.add((SharedSegment)segment);
        }
        return segments;
    }

    public SharedSegment getHostNodeSharedSegment(BridgeBridgeLinkDao bridgeBridgeLinkDao, BridgeMacLinkDao bridgeMacLinkDao, String mac) {
        List links = bridgeMacLinkDao.findByMacAddress(mac);
        if (links.size() == 0) {
            return new SharedSegment();
        }
        BridgeMacLink link = (BridgeMacLink)links.get(0);
        for (SharedSegment segment : this.getBridgeNodeSharedSegments(bridgeBridgeLinkDao, bridgeMacLinkDao, link.getNode().getId())) {
            if (!segment.containsPort(link.getNode().getId(), link.getBridgePort())) continue;
            return segment;
        }
        return new SharedSegment();
    }

    public Set<BroadcastDomain> getAllPersisted(BridgeBridgeLinkDao bridgeBridgeLinkDao, BridgeMacLinkDao bridgeMacLinkDao) {
        ArrayList<SharedSegment> bblsegments = new ArrayList<SharedSegment>();
        HashMap<Integer, Set> rootnodetodomainnodemap = new HashMap<Integer, Set>();
        for (BridgeBridgeLink link : bridgeBridgeLinkDao.findAll()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getAllPersisted: Parsing BridgeBridgeLink: {}", (Object)link.printTopology());
            }
            boolean segmentnotfound = true;
            for (SharedSegment bblsegment : bblsegments) {
                if (!bblsegment.containsPort(link.getDesignatedNode().getId(), link.getDesignatedPort())) continue;
                bblsegment.add(link);
                segmentnotfound = false;
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("getAllPersisted: found Bridge Bridge Link Shared Segment: {}", (Object)bblsegment.printTopology());
                break;
            }
            if (segmentnotfound) {
                SharedSegment bblsegment = new SharedSegment();
                bblsegment.add(link);
                bblsegment.setDesignatedBridge(link.getDesignatedNode().getId());
                bblsegments.add(bblsegment);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getAllPersisted: created new Bridge Bridge Link Shared Segment: {}", (Object)bblsegment.printTopology());
                }
            }
            if (rootnodetodomainnodemap.containsKey(link.getDesignatedNode().getId())) {
                ((Set)rootnodetodomainnodemap.get(link.getDesignatedNode().getId())).add(link.getNode().getId());
                if (rootnodetodomainnodemap.containsKey(link.getNode().getId())) {
                    ((Set)rootnodetodomainnodemap.get(link.getDesignatedNode().getId())).addAll((Collection)rootnodetodomainnodemap.remove(link.getNode().getId()));
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("getAllPersisted: designated {} is root, dependency set: {}", (Object)link.getDesignatedNode().getId(), rootnodetodomainnodemap.get(link.getDesignatedNode().getId()));
                continue;
            }
            if (rootnodetodomainnodemap.containsKey(link.getNode().getId())) {
                Set dependentsnode = (Set)rootnodetodomainnodemap.remove(link.getNode().getId());
                dependentsnode.add(link.getNode().getId());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getAllPersisted: node {} is root, dependency set: {}", (Object)link.getNode().getId(), (Object)dependentsnode);
                }
                Object rootdesignated = null;
                for (Integer rootid : rootnodetodomainnodemap.keySet()) {
                    if (!((Set)rootnodetodomainnodemap.get(rootid)).contains(link.getDesignatedNode().getId())) continue;
                    rootdesignated = rootid;
                    break;
                }
                if (rootdesignated != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getAllPersisted: node {} found root: {}", (Object)link.getNode().getId(), rootdesignated);
                    }
                    dependentsnode.add(link.getDesignatedNode().getId());
                    ((Set)rootnodetodomainnodemap.get(rootdesignated)).addAll(dependentsnode);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("getAllPersisted: node {} found root: {}, dependency set: {}", new Object[]{link.getNode().getId(), rootdesignated, rootnodetodomainnodemap.get(rootdesignated)});
                    continue;
                }
                rootnodetodomainnodemap.put(link.getDesignatedNode().getId(), dependentsnode);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("getAllPersisted: node {} created root: {}, dependency set: {}", new Object[]{link.getNode().getId(), link.getDesignatedNode().getId(), rootnodetodomainnodemap.get(link.getDesignatedNode().getId())});
                continue;
            }
            Integer rootdesignated = null;
            for (Integer n : rootnodetodomainnodemap.keySet()) {
                if (!((Set)rootnodetodomainnodemap.get(n)).contains(link.getDesignatedNode().getId())) continue;
                rootdesignated = n;
                break;
            }
            if (rootdesignated != null) {
                ((Set)rootnodetodomainnodemap.get(rootdesignated)).add(link.getNode().getId());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("getAllPersisted: designatednode {} found root: {}, dependency set: {}", new Object[]{link.getDesignatedNode().getId(), rootdesignated, rootnodetodomainnodemap.get(rootdesignated)});
                continue;
            }
            rootnodetodomainnodemap.put(link.getDesignatedNode().getId(), new HashSet());
            ((Set)rootnodetodomainnodemap.get(link.getDesignatedNode().getId())).add(link.getNode().getId());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("getAllPersisted: designatednode {} : {}", (Object)link.getDesignatedNode().getId(), rootnodetodomainnodemap.get(link.getDesignatedNode().getId()));
        }
        LOG.debug("getAllPersisted: bridge topology set: {}", rootnodetodomainnodemap);
        ArrayList<SharedSegment> bmlsegments = new ArrayList<SharedSegment>();
        HashMap mactobridgeportbbl = new HashMap();
        block4: for (Object link : bridgeMacLinkDao.findAll()) {
            link.setBridgeDot1qTpFdbStatus(BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getAllPersisted: Parsing BridgeMacLink: {}", (Object)link.printTopology());
            }
            for (SharedSegment sharedSegment : bblsegments) {
                if (!sharedSegment.containsPort(link.getNode().getId(), link.getBridgePort())) continue;
                if (!mactobridgeportbbl.containsKey(link.getMacAddress())) {
                    mactobridgeportbbl.put(link.getMacAddress(), new ArrayList());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getAllPersisted: Found BridgeBridgeLink Segment: {}", (Object)sharedSegment.printTopology());
                }
                ((List)mactobridgeportbbl.get(link.getMacAddress())).add(link);
                continue block4;
            }
            if (!rootnodetodomainnodemap.containsKey(link.getNode().getId())) {
                boolean norootnodetodomainmapentry = true;
                for (Set nodes : rootnodetodomainnodemap.values()) {
                    if (!nodes.contains(link.getNode().getId())) continue;
                    norootnodetodomainmapentry = false;
                    break;
                }
                if (norootnodetodomainmapentry) {
                    rootnodetodomainnodemap.put(link.getNode().getId(), new HashSet());
                }
            }
            for (SharedSegment sharedSegment : bmlsegments) {
                if (!sharedSegment.containsPort(link.getNode().getId(), link.getBridgePort())) continue;
                sharedSegment.add((BridgeMacLink)link);
                if (!LOG.isDebugEnabled()) continue block4;
                LOG.debug("getAllPersisted: found Bridge Mac Link Shared Segment: {}", (Object)sharedSegment.printTopology());
                continue block4;
            }
            SharedSegment bmlsegment = new SharedSegment();
            bmlsegment.add((BridgeMacLink)link);
            bmlsegment.setDesignatedBridge(link.getNode().getId());
            if (LOG.isDebugEnabled()) {
                LOG.debug("getAllPersisted: created new Bridge Mac Link Shared Segment: {}", (Object)bmlsegment.printTopology());
            }
            bmlsegments.add(bmlsegment);
        }
        ArrayList forwarders = new ArrayList();
        for (String macaddress : mactobridgeportbbl.keySet()) {
            LOG.debug("getAllPersisted: assigning mac {} to Bridge Bridge Link Shared Segment", (Object)macaddress);
            for (SharedSegment segment : bblsegments) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getAllPersisted: parsing Bridge Bridge Link Shared Segment {}", (Object)segment.printTopology());
                }
                ArrayList bblfoundonsegment = new ArrayList();
                for (BridgeMacLink link : (List)mactobridgeportbbl.get(macaddress)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getAllPersisted: parsing Bridge Mac Link {}", (Object)link.printTopology());
                    }
                    if (!segment.containsPort(link.getNode().getId(), link.getBridgePort())) continue;
                    bblfoundonsegment.add(link);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("getAllPersisted: adding Bridge Mac Link {}", (Object)link.printTopology());
                }
                if (bblfoundonsegment.size() == segment.getBridgePortsOnSegment().size()) {
                    Iterator iterator = bblfoundonsegment.iterator();
                    while (iterator.hasNext()) {
                        BridgeMacLink link;
                        link = (BridgeMacLink)iterator.next();
                        segment.add(link);
                    }
                    continue;
                }
                forwarders.addAll(bblfoundonsegment);
            }
        }
        CopyOnWriteArraySet<BroadcastDomain> domains = new CopyOnWriteArraySet<BroadcastDomain>();
        for (Integer n : rootnodetodomainnodemap.keySet()) {
            BroadcastDomain domain = new BroadcastDomain();
            domain.addBridge(new Bridge(n));
            for (Integer nodeid : (Set)rootnodetodomainnodemap.get(n)) {
                domain.addBridge(new Bridge(nodeid));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getAllPersisted: created new Broadcast Domain: {}", (Object)domain.getBridgeNodesOnDomain());
            }
            domains.add(domain);
        }
        block14: for (SharedSegment sharedSegment : bblsegments) {
            for (BroadcastDomain cdomain : domains) {
                if (!cdomain.containsAtleastOne(sharedSegment.getBridgeIdsOnSegment())) continue;
                cdomain.loadTopologyEntry(sharedSegment);
                continue block14;
            }
        }
        block16: for (SharedSegment sharedSegment : bmlsegments) {
            for (BroadcastDomain cdomain : domains) {
                if (!cdomain.containsAtleastOne(sharedSegment.getBridgeIdsOnSegment())) continue;
                cdomain.loadTopologyEntry(sharedSegment);
                continue block16;
            }
        }
        block18: for (BridgeMacLink bridgeMacLink : forwarders) {
            for (BroadcastDomain domain : domains) {
                if (!domain.containBridgeId(bridgeMacLink.getNode().getId().intValue())) continue;
                domain.addForwarding(bridgeMacLink);
                continue block18;
            }
        }
        for (BroadcastDomain broadcastDomain : domains) {
            if (LOG.isDebugEnabled()) {
                LOG.info("getAllPersisted: loading root Broadcast Domain: {}", (Object)broadcastDomain.getBridgeNodesOnDomain());
            }
            broadcastDomain.loadTopologyRoot();
        }
        return domains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(BroadcastDomain domain) {
        Set<BroadcastDomain> set = this.m_domains;
        synchronized (set) {
            this.m_domains.remove(domain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BroadcastDomain get(int nodeid) {
        Set<BroadcastDomain> set = this.m_domains;
        synchronized (set) {
            for (BroadcastDomain domain : this.m_domains) {
                if (!domain.containBridgeId(nodeid)) continue;
                return domain;
            }
        }
        return null;
    }

    public synchronized Set<BroadcastDomain> getAll() {
        return this.m_domains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        Set<BroadcastDomain> set = this.m_domains;
        synchronized (set) {
            this.m_domains.removeIf(BroadcastDomain::isEmpty);
        }
    }
}

