/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.netmgt.config.ackd.AckdConfiguration;
import org.opennms.netmgt.config.ackd.Parameter;
import org.opennms.netmgt.config.ackd.Reader;
import org.opennms.netmgt.config.ackd.ReaderSchedule;
import org.opennms.netmgt.dao.api.AckdConfigurationDao;
import org.springframework.dao.DataAccessResourceFailureException;

public class DefaultAckdConfigurationDao
extends AbstractJaxbConfigDao<AckdConfiguration, AckdConfiguration>
implements AckdConfigurationDao {
    public DefaultAckdConfigurationDao() {
        super(AckdConfiguration.class, "Ackd Configuration");
    }

    public AckdConfiguration getConfig() {
        return (AckdConfiguration)this.getContainer().getObject();
    }

    public AckdConfiguration translateConfig(AckdConfiguration config) {
        return config;
    }

    public Boolean acknowledgmentMatch(List<String> messageText) {
        String expression = this.getConfig().getAckExpression();
        return this.matcher(messageText, expression);
    }

    public Boolean clearMatch(List<String> messageText) {
        String expression = this.getConfig().getClearExpression();
        return this.matcher(messageText, expression);
    }

    public Boolean escalationMatch(List<String> messageText) {
        String expression = this.getConfig().getEscalateExpression();
        return this.matcher(messageText, expression);
    }

    public Boolean unAcknowledgmentMatch(List<String> messageText) {
        String expression = this.getConfig().getUnackExpression();
        return this.matcher(messageText, expression);
    }

    private Boolean matcher(List<String> messageText, String expression) {
        Boolean matches = Boolean.FALSE;
        if (expression.startsWith("~")) {
            String text;
            Matcher m;
            expression = expression.startsWith("~") ? expression.substring(1) : expression;
            Pattern p = Pattern.compile(expression);
            Iterator<String> iterator = messageText.iterator();
            while (iterator.hasNext() && !(matches = Boolean.valueOf((m = p.matcher(text = iterator.next())).matches())).booleanValue()) {
            }
        } else {
            for (String text : messageText) {
                matches = expression.equalsIgnoreCase(text);
            }
        }
        return matches;
    }

    public Reader getReader(String readerName) {
        Reader readerByName = null;
        List readers = this.getConfig().getReaders().getReaderCollection();
        for (Reader reader : readers) {
            if (!readerName.equals(reader.getReaderName())) continue;
            readerByName = reader;
        }
        return readerByName;
    }

    public ReaderSchedule getReaderSchedule(String readerName) {
        ReaderSchedule schedule = null;
        Reader reader = this.getReader(readerName);
        if (reader != null) {
            schedule = reader.getReaderSchedule();
        }
        return schedule;
    }

    public boolean isReaderEnabled(String readerName) {
        boolean enabled = false;
        Reader reader = this.getReader(readerName);
        if (reader != null) {
            enabled = reader.isEnabled();
        }
        return enabled;
    }

    public void reloadConfiguration() throws DataAccessResourceFailureException {
        this.getContainer().reload();
    }

    public int getEnabledReaderCount() {
        int cnt = 0;
        for (Reader reader : this.getConfig().getReaders().getReaderCollection()) {
            if (!reader.isEnabled()) continue;
            ++cnt;
        }
        return cnt;
    }

    public List<Parameter> getParametersForReader(String name) {
        return this.getReader(name).getParameterCollection();
    }
}

