/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import com.google.common.base.Strings;
import com.vmware.vim25.HostRuntimeInfo;
import com.vmware.vim25.HostSystemPowerState;
import com.vmware.vim25.mo.HostSystem;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collection.api.AbstractRemoteServiceCollector;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.dto.CollectionSetDTO;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.DeferredGenericTypeResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.vmware.VmwareServer;
import org.opennms.netmgt.config.vmware.cim.Attrib;
import org.opennms.netmgt.config.vmware.cim.VmwareCimCollection;
import org.opennms.netmgt.config.vmware.cim.VmwareCimGroup;
import org.opennms.netmgt.dao.VmwareCimDatacollectionConfigDao;
import org.opennms.netmgt.dao.VmwareConfigDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.protocols.vmware.VmwareViJavaAccess;
import org.sblim.wbem.cim.CIMObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareCimCollector
extends AbstractRemoteServiceCollector {
    private static final Logger logger = LoggerFactory.getLogger(VmwareCimCollector.class);
    private static final String VMWARE_COLLECTION_KEY = "vmwareCollection";
    private static final String VMWARE_MGMT_SERVER_KEY = "vmwareManagementServer";
    private static final String VMWARE_MGED_OBJECT_ID_KEY = "vmwareManagedObjectId";
    private static final String VMWARE_SERVER_KEY = "vmwareServer";
    private static final Map<String, Class<?>> TYPE_MAP = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, Class<VmwareCimCollection>>("vmwareCollection", VmwareCimCollection.class), new AbstractMap.SimpleEntry<String, Class<VmwareServer>>("vmwareServer", VmwareServer.class)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Class)e.getValue())));
    private NodeDao m_nodeDao = null;
    private VmwareCimDatacollectionConfigDao m_vmwareCimDatacollectionConfigDao;
    private VmwareConfigDao m_vmwareConfigDao = null;

    public VmwareCimCollector() {
        super(TYPE_MAP);
    }

    public void initialize() throws CollectionInitializationException {
        if (this.m_nodeDao == null) {
            this.m_nodeDao = (NodeDao)BeanUtils.getBean((String)"daoContext", (String)"nodeDao", NodeDao.class);
        }
        if (this.m_nodeDao == null) {
            logger.error("Node dao should be a non-null value.");
        }
        if (this.m_vmwareCimDatacollectionConfigDao == null) {
            this.m_vmwareCimDatacollectionConfigDao = (VmwareCimDatacollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"vmwareCimDatacollectionConfigDao", VmwareCimDatacollectionConfigDao.class);
        }
        if (this.m_nodeDao == null) {
            logger.error("vmwareCimDatacollectionConfigDao should be a non-null value.");
        }
        if (this.m_vmwareConfigDao == null) {
            this.m_vmwareConfigDao = (VmwareConfigDao)BeanUtils.getBean((String)"daoContext", (String)"vmwareConfigDao", VmwareConfigDao.class);
        }
    }

    public Map<String, Object> getRuntimeAttributes(CollectionAgent agent, Map<String, Object> parameters) {
        HashMap<String, Object> runtimeAttributes = new HashMap<String, Object>();
        OnmsNode onmsNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(agent.getNodeId()));
        if (onmsNode == null) {
            throw new IllegalArgumentException(String.format("VmwareCollector: No node found with id: %d", agent.getNodeId()));
        }
        String vmwareManagementServer = onmsNode.getAssetRecord().getVmwareManagementServer();
        if (Strings.isNullOrEmpty((String)vmwareManagementServer)) {
            throw new IllegalArgumentException(String.format("VmwareCollector: No management server is set on node with id %d.", onmsNode.getId()));
        }
        runtimeAttributes.put(VMWARE_MGMT_SERVER_KEY, vmwareManagementServer);
        String vmwareManagedObjectId = onmsNode.getForeignId();
        if (Strings.isNullOrEmpty((String)vmwareManagedObjectId)) {
            throw new IllegalArgumentException(String.format("VmwareCollector: No foreign id is set on node with id %d.", onmsNode.getId()));
        }
        runtimeAttributes.put(VMWARE_MGED_OBJECT_ID_KEY, vmwareManagedObjectId);
        String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", (String)ParameterMap.getKeyedString(parameters, (String)"vmware-collection", null));
        VmwareCimCollection collection = this.m_vmwareCimDatacollectionConfigDao.getVmwareCimCollection(collectionName);
        if (collection == null) {
            throw new IllegalArgumentException(String.format("VmwareCollector: No collection found with name '%s'.", collectionName));
        }
        runtimeAttributes.put(VMWARE_COLLECTION_KEY, collection);
        Map<String, VmwareServer> serverMap = this.m_vmwareConfigDao.getServerMap();
        if (serverMap == null) {
            throw new IllegalStateException(String.format("VmwareCollector: Error getting vmware-config.xml's server map.", new Object[0]));
        }
        VmwareServer vmwareServer = serverMap.get(vmwareManagementServer);
        if (vmwareServer == null) {
            throw new IllegalStateException(String.format("VmwareCollector: Error getting credentials for VMware management server: %s", vmwareManagementServer));
        }
        runtimeAttributes.put(VMWARE_SERVER_KEY, vmwareServer);
        return runtimeAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionSet collect(CollectionAgent agent, Map<String, Object> parameters) throws CollectionException {
        VmwareCimCollection collection = (VmwareCimCollection)parameters.get(VMWARE_COLLECTION_KEY);
        String vmwareManagementServer = (String)parameters.get(VMWARE_MGMT_SERVER_KEY);
        String vmwareManagedObjectId = (String)parameters.get(VMWARE_MGED_OBJECT_ID_KEY);
        VmwareServer vmwareServer = (VmwareServer)parameters.get(VMWARE_SERVER_KEY);
        CollectionSetBuilder builder = new CollectionSetBuilder(agent);
        builder.withStatus(CollectionStatus.FAILED);
        VmwareViJavaAccess vmwareViJavaAccess = new VmwareViJavaAccess(vmwareServer);
        int timeout = ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)-1);
        if (timeout > 0 && !vmwareViJavaAccess.setTimeout(timeout)) {
            logger.warn("Error setting connection timeout for VMware management server '{}'", (Object)vmwareManagementServer);
        }
        if (collection.getVmwareCimGroup().length < 1) {
            logger.info("No groups to collect. Returning empty collection set.");
            builder.withStatus(CollectionStatus.SUCCEEDED);
            return builder.build();
        }
        try {
            vmwareViJavaAccess.connect();
        }
        catch (MalformedURLException e) {
            logger.warn("Error connecting VMware management server '{}': '{}' exception: {} cause: '{}'", new Object[]{vmwareManagementServer, e.getMessage(), e.getClass().getName(), e.getCause()});
            return builder.build();
        }
        catch (RemoteException e) {
            logger.warn("Error connecting VMware management server '{}': '{}' exception: {} cause: '{}'", new Object[]{vmwareManagementServer, e.getMessage(), e.getClass().getName(), e.getCause()});
            return builder.build();
        }
        HostSystem hostSystem = vmwareViJavaAccess.getHostSystemByManagedObjectId(vmwareManagedObjectId);
        String powerState = null;
        if (hostSystem == null) {
            logger.debug("hostSystem=null");
        } else {
            HostRuntimeInfo hostRuntimeInfo = hostSystem.getRuntime();
            if (hostRuntimeInfo == null) {
                logger.debug("hostRuntimeInfo=null");
            } else {
                HostSystemPowerState hostSystemPowerState = hostRuntimeInfo.getPowerState();
                if (hostSystemPowerState == null) {
                    logger.debug("hostSystemPowerState=null");
                } else {
                    powerState = hostSystemPowerState.toString();
                }
            }
        }
        logger.debug("The power state for host system '{}' is '{}'", (Object)vmwareManagedObjectId, powerState);
        if ("poweredOn".equals(powerState)) {
            HashMap<String, List<CIMObject>> cimObjects = new HashMap<String, List<CIMObject>>();
            for (VmwareCimGroup vmwareCimGroup : collection.getVmwareCimGroup()) {
                List<CIMObject> cimList;
                String cimClass = vmwareCimGroup.getCimClass();
                if (!cimObjects.containsKey(cimClass)) {
                    cimList = null;
                    try {
                        cimList = vmwareViJavaAccess.queryCimObjects(hostSystem, cimClass, InetAddressUtils.str((InetAddress)((InetAddress)agent.getAddress())));
                    }
                    catch (Exception e) {
                        logger.warn("Error retrieving CIM values from host system '{}'. Error message: '{}'", (Object)vmwareManagedObjectId, (Object)e.getMessage());
                        CollectionSetDTO collectionSetDTO = builder.build();
                        return collectionSetDTO;
                    }
                    finally {
                        vmwareViJavaAccess.disconnect();
                    }
                    cimObjects.put(cimClass, cimList);
                }
                if ((cimList = (List<CIMObject>)cimObjects.get(cimClass)) == null) {
                    logger.warn("Error getting objects of CIM class '{}' from host system '{}'", (Object)cimClass, (Object)vmwareManagedObjectId);
                    continue;
                }
                String keyAttribute = vmwareCimGroup.getKey();
                String attributeValue = vmwareCimGroup.getValue();
                String instanceAttribute = vmwareCimGroup.getInstance();
                for (CIMObject cimObject : cimList) {
                    String cimObjectValue;
                    boolean addObject = false;
                    addObject = keyAttribute != null && attributeValue != null ? attributeValue.equals(cimObjectValue = vmwareViJavaAccess.getPropertyOfCimObject(cimObject, keyAttribute)) : true;
                    if (!addObject) continue;
                    String instance = vmwareViJavaAccess.getPropertyOfCimObject(cimObject, instanceAttribute);
                    NodeLevelResource nodeResource = new NodeLevelResource(agent.getNodeId());
                    DeferredGenericTypeResource resource = new DeferredGenericTypeResource(nodeResource, vmwareCimGroup.getResourceType(), instance);
                    for (Attrib attrib : vmwareCimGroup.getAttrib()) {
                        AttributeType type = attrib.getType();
                        String value = vmwareViJavaAccess.getPropertyOfCimObject(cimObject, attrib.getName());
                        builder.withAttribute((Resource)resource, vmwareCimGroup.getName(), attrib.getAlias(), value, type);
                    }
                }
            }
            builder.withStatus(CollectionStatus.SUCCEEDED);
        }
        vmwareViJavaAccess.disconnect();
        return builder.build();
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_vmwareCimDatacollectionConfigDao.getRrdRepository(collectionName);
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }
}

