/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import com.vmware.vim25.HostRuntimeInfo;
import com.vmware.vim25.HostSystemPowerState;
import com.vmware.vim25.mo.HostSystem;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collectd.vmware.cim.VmwareCimCollectionAttributeType;
import org.opennms.netmgt.collectd.vmware.cim.VmwareCimCollectionSet;
import org.opennms.netmgt.collectd.vmware.cim.VmwareCimMultiInstanceCollectionResource;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.config.vmware.cim.Attrib;
import org.opennms.netmgt.config.vmware.cim.VmwareCimCollection;
import org.opennms.netmgt.config.vmware.cim.VmwareCimGroup;
import org.opennms.netmgt.dao.VmwareCimDatacollectionConfigDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.protocols.vmware.VmwareViJavaAccess;
import org.sblim.wbem.cim.CIMObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareCimCollector
implements ServiceCollector {
    private static Map<String, ValueModifier> valueModifiers = new HashMap<String, ValueModifier>();
    private final Logger logger = LoggerFactory.getLogger(VmwareCimCollector.class);
    private Map<String, AttributeGroupType> m_groupTypeList = new HashMap<String, AttributeGroupType>();
    private Map<String, VmwareCimCollectionAttributeType> m_attribTypeList = new HashMap<String, VmwareCimCollectionAttributeType>();
    private NodeDao m_nodeDao = null;
    VmwareCimDatacollectionConfigDao m_vmwareCimDatacollectionConfigDao;
    private static Map<Integer, String> sensorTypeMapping;
    private static Map<Integer, String> rateUnitMapping;
    private static Map<Integer, String> baseUnitMapping;

    public void initialize(Map<String, String> parameters) throws CollectionInitializationException {
        if (this.m_nodeDao == null) {
            this.m_nodeDao = (NodeDao)BeanUtils.getBean((String)"daoContext", (String)"nodeDao", NodeDao.class);
        }
        if (this.m_nodeDao == null) {
            this.logger.error("Node dao should be a non-null value.");
        }
        if (this.m_vmwareCimDatacollectionConfigDao == null) {
            this.m_vmwareCimDatacollectionConfigDao = (VmwareCimDatacollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"vmwareCimDatacollectionConfigDao", VmwareCimDatacollectionConfigDao.class);
        }
        if (this.m_nodeDao == null) {
            this.logger.error("vmwareCimDatacollectionConfigDao should be a non-null value.");
        }
        this.initializeRrdRepository();
    }

    private void initializeRrdRepository() {
        this.logger.debug("initializeRrdRepository: Initializing RRD repo from VmwareCimCollector...");
        this.initializeRrdDirs();
    }

    private void initializeRrdDirs() {
        File f = new File(this.m_vmwareCimDatacollectionConfigDao.getRrdPath());
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new RuntimeException("Unable to create RRD file repository.  Path doesn't already exist and could not make directory: " + this.m_vmwareCimDatacollectionConfigDao.getRrdPath());
        }
    }

    private void loadAttributeGroupList(VmwareCimCollection collection) {
        for (VmwareCimGroup vpm : collection.getVmwareCimGroup()) {
            AttributeGroupType attribGroupType1 = new AttributeGroupType(vpm.getName(), "all");
            this.m_groupTypeList.put(vpm.getName(), attribGroupType1);
        }
    }

    private void loadAttributeTypeList(VmwareCimCollection collection) {
        for (VmwareCimGroup vpm : collection.getVmwareCimGroup()) {
            for (Attrib attrib : vpm.getAttrib()) {
                AttributeGroupType attribGroupType = this.m_groupTypeList.get(vpm.getName());
                VmwareCimCollectionAttributeType attribType = new VmwareCimCollectionAttributeType(attrib, attribGroupType);
                this.m_attribTypeList.put(attrib.getName(), attribType);
            }
        }
    }

    public void initialize(CollectionAgent agent, Map<String, Object> parameters) throws CollectionInitializationException {
        OnmsNode onmsNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(agent.getNodeId()));
        String vmwareManagementServer = onmsNode.getAssetRecord().getVmwareManagementServer();
        String vmwareManagedEntityType = onmsNode.getAssetRecord().getVmwareManagedEntityType();
        String vmwareManagedObjectId = onmsNode.getForeignId();
        parameters.put("vmwareManagementServer", vmwareManagementServer);
        parameters.put("vmwareManagedEntityType", vmwareManagedEntityType);
        parameters.put("vmwareManagedObjectId", vmwareManagedObjectId);
    }

    public void release() {
    }

    public void release(CollectionAgent agent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> parameters) throws CollectionException {
        String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", (String)ParameterMap.getKeyedString(parameters, (String)"vmware-collection", null));
        VmwareCimCollection collection = this.m_vmwareCimDatacollectionConfigDao.getVmwareCimCollection(collectionName);
        String vmwareManagementServer = (String)parameters.get("vmwareManagementServer");
        String vmwareManagedObjectId = (String)parameters.get("vmwareManagedObjectId");
        if (vmwareManagementServer == null || vmwareManagedObjectId == null) {
            return null;
        }
        if ("".equals(vmwareManagementServer) || "".equals(vmwareManagedObjectId)) {
            return null;
        }
        this.loadAttributeGroupList(collection);
        this.loadAttributeTypeList(collection);
        VmwareCimCollectionSet collectionSet = new VmwareCimCollectionSet();
        collectionSet.setCollectionTimestamp(new Date());
        collectionSet.setStatus(2);
        VmwareViJavaAccess vmwareViJavaAccess = null;
        try {
            vmwareViJavaAccess = new VmwareViJavaAccess(vmwareManagementServer);
            int timeout = ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)-1);
            if (timeout > 0 && !vmwareViJavaAccess.setTimeout(timeout)) {
                this.logger.warn("Error setting connection timeout for VMware management server '{}'", (Object)vmwareManagementServer);
            }
        }
        catch (IOException e) {
            this.logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)vmwareManagementServer, (Object)e.getMessage());
            return collectionSet;
        }
        try {
            vmwareViJavaAccess.connect();
        }
        catch (MalformedURLException e) {
            this.logger.warn("Error connecting VMware management server '{}': '{}' exception: {} cause: '{}'", new Object[]{vmwareManagementServer, e.getMessage(), e.getClass().getName(), e.getCause()});
            return collectionSet;
        }
        catch (RemoteException e) {
            this.logger.warn("Error connecting VMware management server '{}': '{}' exception: {} cause: '{}'", new Object[]{vmwareManagementServer, e.getMessage(), e.getClass().getName(), e.getCause()});
            return collectionSet;
        }
        HostSystem hostSystem = vmwareViJavaAccess.getHostSystemByManagedObjectId(vmwareManagedObjectId);
        String powerState = null;
        if (hostSystem == null) {
            this.logger.debug("hostSystem=null");
        } else {
            HostRuntimeInfo hostRuntimeInfo = hostSystem.getRuntime();
            if (hostRuntimeInfo == null) {
                this.logger.debug("hostRuntimeInfo=null");
            } else {
                HostSystemPowerState hostSystemPowerState = hostRuntimeInfo.getPowerState();
                if (hostSystemPowerState == null) {
                    this.logger.debug("hostSystemPowerState=null");
                } else {
                    powerState = hostSystemPowerState.toString();
                }
            }
        }
        this.logger.debug("The power state for host system '{}' is '{}'", (Object)vmwareManagedObjectId, powerState);
        if ("poweredOn".equals(powerState)) {
            HashMap<String, List<CIMObject>> cimObjects = new HashMap<String, List<CIMObject>>();
            for (VmwareCimGroup vmwareCimGroup : collection.getVmwareCimGroup()) {
                List<CIMObject> cimList;
                String cimClass = vmwareCimGroup.getCimClass();
                if (!cimObjects.containsKey(cimClass)) {
                    cimList = null;
                    try {
                        cimList = vmwareViJavaAccess.queryCimObjects(hostSystem, cimClass, InetAddressUtils.str((InetAddress)((InetAddress)agent.getAddress())));
                    }
                    catch (Exception e) {
                        this.logger.warn("Error retrieving CIM values from host system '{}'. Error message: '{}'", (Object)vmwareManagedObjectId, (Object)e.getMessage());
                        VmwareCimCollectionSet vmwareCimCollectionSet = collectionSet;
                        return vmwareCimCollectionSet;
                    }
                    finally {
                        vmwareViJavaAccess.disconnect();
                    }
                    cimObjects.put(cimClass, cimList);
                }
                if ((cimList = (List<CIMObject>)cimObjects.get(cimClass)) == null) {
                    this.logger.warn("Error getting objects of CIM class '{}' from host system '{}'", (Object)cimClass, (Object)vmwareManagedObjectId);
                    continue;
                }
                String keyAttribute = vmwareCimGroup.getKey();
                String attributeValue = vmwareCimGroup.getValue();
                String instanceAttribute = vmwareCimGroup.getInstance();
                for (CIMObject cimObject : cimList) {
                    String cimObjectValue;
                    boolean addObject = false;
                    addObject = keyAttribute != null && attributeValue != null ? attributeValue.equals(cimObjectValue = vmwareViJavaAccess.getPropertyOfCimObject(cimObject, keyAttribute)) : true;
                    if (!addObject) continue;
                    String instance = vmwareViJavaAccess.getPropertyOfCimObject(cimObject, instanceAttribute);
                    VmwareCimMultiInstanceCollectionResource vmwareCollectionResource = new VmwareCimMultiInstanceCollectionResource(agent, instance, vmwareCimGroup.getResourceType());
                    for (Attrib attrib : vmwareCimGroup.getAttrib()) {
                        VmwareCimCollectionAttributeType attribType = this.m_attribTypeList.get(attrib.getName());
                        String value = vmwareViJavaAccess.getPropertyOfCimObject(cimObject, attrib.getName());
                        if (valueModifiers.containsKey(attrib.getName())) {
                            String modifiedValue = valueModifiers.get(attrib.getName()).modifyValue(attrib.getName(), value, cimObject, vmwareViJavaAccess);
                            this.logger.debug("Applying value modifier for instance value " + attrib.getName() + "[" + instance + "]='" + value + "' => '" + modifiedValue + "' for node " + agent.getNodeId());
                            value = modifiedValue;
                        }
                        vmwareCollectionResource.setAttributeValue((CollectionAttributeType)attribType, value);
                        this.logger.debug("Storing multi instance value " + attrib.getName() + "[" + instance + "]='" + value + "' for node " + agent.getNodeId());
                    }
                    collectionSet.getCollectionResources().add(vmwareCollectionResource);
                }
            }
            collectionSet.setStatus(1);
        }
        vmwareViJavaAccess.disconnect();
        return collectionSet;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_vmwareCimDatacollectionConfigDao.getRrdRepository(collectionName);
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    static {
        valueModifiers.put("SensorType", new ValueModifier(){

            @Override
            public String modifyValue(String name, String value, CIMObject cimObject, VmwareViJavaAccess vmwareViJavaAccess) {
                String modifiedValue;
                if (value != null && (modifiedValue = (String)sensorTypeMapping.get(Integer.valueOf(value))) != null) {
                    return modifiedValue;
                }
                return "null";
            }
        });
        valueModifiers.put("BaseUnits", new ValueModifier(){

            @Override
            public String modifyValue(String name, String value, CIMObject cimObject, VmwareViJavaAccess vmwareViJavaAccess) {
                String modifiedValue;
                if (value != null && (modifiedValue = (String)baseUnitMapping.get(Integer.valueOf(value))) != null) {
                    return modifiedValue;
                }
                return "null";
            }
        });
        valueModifiers.put("RateUnits", new ValueModifier(){

            @Override
            public String modifyValue(String name, String value, CIMObject cimObject, VmwareViJavaAccess vmwareViJavaAccess) {
                String modifiedValue;
                if (value != null && (modifiedValue = (String)rateUnitMapping.get(Integer.valueOf(value))) != null) {
                    return modifiedValue;
                }
                return "null";
            }
        });
        ValueModifier currentReadingModifier = new ValueModifier(){

            @Override
            public String modifyValue(String name, String value, CIMObject cimObject, VmwareViJavaAccess vmwareViJavaAccess) {
                if (value == null) {
                    return null;
                }
                return this.applyUnitModifier(value, vmwareViJavaAccess.getPropertyOfCimObject(cimObject, "UnitModifier"));
            }

            private String applyUnitModifier(String attributeValue, String unitModifier) {
                return String.valueOf(Double.valueOf(attributeValue) * Math.pow(10.0, Double.valueOf(unitModifier)));
            }
        };
        valueModifiers.put("CurrentReading", currentReadingModifier);
        valueModifiers.put("UpperThresholdCritical", currentReadingModifier);
        valueModifiers.put("LowerThresholdCritical", currentReadingModifier);
        valueModifiers.put("UpperThresholdNonCritical", currentReadingModifier);
        valueModifiers.put("LowerThresholdNonCritical", currentReadingModifier);
        valueModifiers.put("UpperThresholdFatal", currentReadingModifier);
        valueModifiers.put("LowerThresholdFatal", currentReadingModifier);
        valueModifiers.put("MaxReadable", currentReadingModifier);
        valueModifiers.put("MinReadable", currentReadingModifier);
        sensorTypeMapping = new HashMap<Integer, String>();
        sensorTypeMapping.put(0, "Unknown");
        sensorTypeMapping.put(1, "Other");
        sensorTypeMapping.put(2, "Temperature");
        sensorTypeMapping.put(3, "Voltage");
        sensorTypeMapping.put(4, "Current");
        sensorTypeMapping.put(5, "Tachometer");
        sensorTypeMapping.put(6, "Counter");
        sensorTypeMapping.put(7, "Switch");
        sensorTypeMapping.put(8, "Lock");
        sensorTypeMapping.put(9, "Humidity");
        sensorTypeMapping.put(10, "Smoke Detection");
        sensorTypeMapping.put(11, "Presence");
        sensorTypeMapping.put(12, "Air Flow");
        sensorTypeMapping.put(13, "Power Consumption");
        sensorTypeMapping.put(14, "Power Production");
        sensorTypeMapping.put(15, "Pressure");
        sensorTypeMapping.put(16, "Intrusion");
        sensorTypeMapping.put(17, "DMTF Reserved");
        sensorTypeMapping.put(18, "Vendor Reserved");
        rateUnitMapping = new HashMap<Integer, String>();
        rateUnitMapping.put(0, "None");
        rateUnitMapping.put(1, "Per MicroSecond");
        rateUnitMapping.put(2, "Per MilliSecond");
        rateUnitMapping.put(3, "Per Second");
        rateUnitMapping.put(4, "Per Minute");
        rateUnitMapping.put(5, "Per Hour");
        rateUnitMapping.put(6, "Per Day");
        rateUnitMapping.put(7, "Per Week");
        rateUnitMapping.put(8, "Per Month");
        rateUnitMapping.put(9, "Per Year");
        baseUnitMapping = new HashMap<Integer, String>();
        baseUnitMapping.put(0, "Unknown");
        baseUnitMapping.put(1, "Other");
        baseUnitMapping.put(2, "Degrees C");
        baseUnitMapping.put(3, "Degrees F");
        baseUnitMapping.put(4, "Degrees K");
        baseUnitMapping.put(5, "Volts");
        baseUnitMapping.put(6, "Amps");
        baseUnitMapping.put(7, "Watts");
        baseUnitMapping.put(8, "Joules");
        baseUnitMapping.put(9, "Coulombs");
        baseUnitMapping.put(10, "VA");
        baseUnitMapping.put(11, "Nits");
        baseUnitMapping.put(12, "Lumens");
        baseUnitMapping.put(13, "Lux");
        baseUnitMapping.put(14, "Candelas");
        baseUnitMapping.put(15, "kPa");
        baseUnitMapping.put(16, "PSI");
        baseUnitMapping.put(17, "Newtons");
        baseUnitMapping.put(18, "CFM");
        baseUnitMapping.put(19, "RPM");
        baseUnitMapping.put(20, "Hertz");
        baseUnitMapping.put(21, "Seconds");
        baseUnitMapping.put(22, "Minutes");
        baseUnitMapping.put(23, "Hours");
        baseUnitMapping.put(24, "Days");
        baseUnitMapping.put(25, "Weeks");
        baseUnitMapping.put(26, "Mils");
        baseUnitMapping.put(27, "Inches");
        baseUnitMapping.put(28, "Feet");
        baseUnitMapping.put(29, "Cubic Inches");
        baseUnitMapping.put(30, "Cubic Feet");
        baseUnitMapping.put(31, "Meters");
        baseUnitMapping.put(32, "Cubic Centimeters");
        baseUnitMapping.put(33, "Cubic Meters");
        baseUnitMapping.put(34, "Liters");
        baseUnitMapping.put(35, "Fluid Ounces");
        baseUnitMapping.put(36, "Radians");
        baseUnitMapping.put(37, "Steradians");
        baseUnitMapping.put(38, "Revolutions");
        baseUnitMapping.put(39, "Cycles");
        baseUnitMapping.put(40, "Gravities");
        baseUnitMapping.put(41, "Ounces");
        baseUnitMapping.put(42, "Pounds");
        baseUnitMapping.put(43, "Foot-Pounds");
        baseUnitMapping.put(44, "Ounce-Inches");
        baseUnitMapping.put(45, "Gauss");
        baseUnitMapping.put(46, "Gilberts");
        baseUnitMapping.put(47, "Henries");
        baseUnitMapping.put(48, "Farads");
        baseUnitMapping.put(49, "Ohms");
        baseUnitMapping.put(50, "Siemens");
        baseUnitMapping.put(51, "Moles");
        baseUnitMapping.put(52, "Becquerels");
        baseUnitMapping.put(53, "PPM (parts/million)");
        baseUnitMapping.put(54, "Decibels");
        baseUnitMapping.put(55, "DbA");
        baseUnitMapping.put(56, "DbC");
        baseUnitMapping.put(57, "Grays");
        baseUnitMapping.put(58, "Sieverts");
        baseUnitMapping.put(59, "Color Temperature Degrees K");
        baseUnitMapping.put(60, "Bits");
        baseUnitMapping.put(61, "Bytes");
        baseUnitMapping.put(62, "Words (data)");
        baseUnitMapping.put(63, "DoubleWords");
        baseUnitMapping.put(64, "QuadWords");
        baseUnitMapping.put(65, "Percentage");
        baseUnitMapping.put(66, "Pascals");
    }

    private static interface ValueModifier {
        public String modifyValue(String var1, String var2, CIMObject var3, VmwareViJavaAccess var4);
    }
}

