/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import com.vmware.vim25.mo.ManagedEntity;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collectd.vmware.vijava.VmwareCollectionAttributeType;
import org.opennms.netmgt.collectd.vmware.vijava.VmwareCollectionSet;
import org.opennms.netmgt.collectd.vmware.vijava.VmwareMultiInstanceCollectionResource;
import org.opennms.netmgt.collectd.vmware.vijava.VmwarePerformanceValues;
import org.opennms.netmgt.collectd.vmware.vijava.VmwareSingleInstanceCollectionResource;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.config.vmware.vijava.Attrib;
import org.opennms.netmgt.config.vmware.vijava.VmwareCollection;
import org.opennms.netmgt.config.vmware.vijava.VmwareGroup;
import org.opennms.netmgt.dao.VmwareDatacollectionConfigDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.protocols.vmware.VmwareViJavaAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareCollector
implements ServiceCollector {
    private final Logger logger = LoggerFactory.getLogger(VmwareCollector.class);
    private NodeDao m_nodeDao = null;
    private VmwareDatacollectionConfigDao m_vmwareDatacollectionConfigDao;

    public void initialize(Map<String, String> parameters) throws CollectionInitializationException {
        if (this.m_nodeDao == null) {
            this.m_nodeDao = (NodeDao)BeanUtils.getBean((String)"daoContext", (String)"nodeDao", NodeDao.class);
        }
        if (this.m_nodeDao == null) {
            this.logger.error("Node dao should be a non-null value.");
        }
        if (this.m_vmwareDatacollectionConfigDao == null) {
            this.m_vmwareDatacollectionConfigDao = (VmwareDatacollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"vmwareDatacollectionConfigDao", VmwareDatacollectionConfigDao.class);
        }
        if (this.m_vmwareDatacollectionConfigDao == null) {
            this.logger.error("vmwareDatacollectionConfigDao should be a non-null value.");
        }
        this.initializeRrdRepository();
    }

    private void initializeRrdRepository() {
        this.logger.debug("initializeRrdRepository: Initializing RRD repo from VmwareCollector...");
        this.initializeRrdDirs();
    }

    private void initializeRrdDirs() {
        File f = new File(this.m_vmwareDatacollectionConfigDao.getRrdPath());
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new RuntimeException("Unable to create RRD file repository.  Path doesn't already exist and could not make directory: " + this.m_vmwareDatacollectionConfigDao.getRrdPath());
        }
    }

    public void initialize(CollectionAgent agent, Map<String, Object> parameters) throws CollectionInitializationException {
        OnmsNode onmsNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(agent.getNodeId()));
        String vmwareManagementServer = onmsNode.getAssetRecord().getVmwareManagementServer();
        String vmwareManagedEntityType = onmsNode.getAssetRecord().getVmwareManagedEntityType();
        String vmwareManagedObjectId = onmsNode.getForeignId();
        parameters.put("vmwareManagementServer", vmwareManagementServer);
        parameters.put("vmwareManagedEntityType", vmwareManagedEntityType);
        parameters.put("vmwareManagedObjectId", vmwareManagedObjectId);
    }

    public void release() {
    }

    public void release(CollectionAgent agent) {
    }

    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> parameters) throws CollectionException {
        String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", (String)ParameterMap.getKeyedString(parameters, (String)"vmware-collection", null));
        VmwareCollection collection = this.m_vmwareDatacollectionConfigDao.getVmwareCollection(collectionName);
        String vmwareManagementServer = (String)parameters.get("vmwareManagementServer");
        String vmwareManagedObjectId = (String)parameters.get("vmwareManagedObjectId");
        if (vmwareManagementServer == null || vmwareManagedObjectId == null) {
            return null;
        }
        if ("".equals(vmwareManagementServer) || "".equals(vmwareManagedObjectId)) {
            return null;
        }
        VmwareCollectionSet collectionSet = new VmwareCollectionSet();
        collectionSet.setCollectionTimestamp(new Date());
        collectionSet.setStatus(2);
        VmwareViJavaAccess vmwareViJavaAccess = null;
        try {
            vmwareViJavaAccess = new VmwareViJavaAccess(vmwareManagementServer);
            int timeout = ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)-1);
            if (timeout > 0 && !vmwareViJavaAccess.setTimeout(timeout)) {
                this.logger.warn("Error setting connection timeout for VMware management server '{}'", (Object)vmwareManagementServer);
            }
        }
        catch (IOException e) {
            this.logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)vmwareManagementServer, (Object)e.getMessage());
            return collectionSet;
        }
        try {
            vmwareViJavaAccess.connect();
        }
        catch (MalformedURLException e) {
            this.logger.warn("Error connecting VMware management server '{}': '{}' exception: {} cause: '{}'", new Object[]{vmwareManagementServer, e.getMessage(), e.getClass().getName(), e.getCause()});
            return collectionSet;
        }
        catch (RemoteException e) {
            this.logger.warn("Error connecting VMware management server '{}': '{}' exception: {} cause: '{}'", new Object[]{vmwareManagementServer, e.getMessage(), e.getClass().getName(), e.getCause()});
            return collectionSet;
        }
        ManagedEntity managedEntity = vmwareViJavaAccess.getManagedEntityByManagedObjectId(vmwareManagedObjectId);
        VmwarePerformanceValues vmwarePerformanceValues = null;
        try {
            vmwarePerformanceValues = vmwareViJavaAccess.queryPerformanceValues(managedEntity);
        }
        catch (RemoteException e) {
            this.logger.warn("Error retrieving performance values from VMware management server '" + vmwareManagementServer + "' for managed object '" + vmwareManagedObjectId + "'", (Object)e.getMessage());
            vmwareViJavaAccess.disconnect();
            return collectionSet;
        }
        for (VmwareGroup vmwareGroup : collection.getVmwareGroup()) {
            VmwareCollectionAttributeType attribType;
            AttributeGroupType attribGroupType = new AttributeGroupType(vmwareGroup.getName(), "all");
            if ("node".equalsIgnoreCase(vmwareGroup.getResourceType())) {
                VmwareSingleInstanceCollectionResource vmwareCollectionResource = new VmwareSingleInstanceCollectionResource(agent);
                for (Attrib attrib : vmwareGroup.getAttrib()) {
                    if (!vmwarePerformanceValues.hasSingleValue(attrib.getName())) {
                        this.logger.debug("Warning! No single value for '{}' defined as single instance attribute for node {}", (Object)attrib.getName(), (Object)agent.getNodeId());
                        continue;
                    }
                    attribType = new VmwareCollectionAttributeType(attrib, attribGroupType);
                    this.logger.debug("Storing single instance value " + attrib.getName() + "='" + vmwarePerformanceValues.getValue(attrib.getName()) + "for node " + agent.getNodeId());
                    vmwareCollectionResource.setAttributeValue((CollectionAttributeType)attribType, String.valueOf(vmwarePerformanceValues.getValue(attrib.getName())));
                }
                collectionSet.getCollectionResources().add(vmwareCollectionResource);
                continue;
            }
            TreeSet<String> instanceSet = new TreeSet<String>();
            HashMap<String, VmwareMultiInstanceCollectionResource> resources = new HashMap<String, VmwareMultiInstanceCollectionResource>();
            for (Attrib attrib : vmwareGroup.getAttrib()) {
                if (!vmwarePerformanceValues.hasInstances(attrib.getName())) {
                    this.logger.debug("Warning! No multi instance value for '{}' defined as multi instance attribute for node {}", (Object)attrib.getName(), (Object)agent.getNodeId());
                    continue;
                }
                Set<String> newInstances = vmwarePerformanceValues.getInstances(attrib.getName());
                VmwareCollectionAttributeType attribType2 = new VmwareCollectionAttributeType(attrib, attribGroupType);
                for (String instance : newInstances) {
                    if (!instanceSet.contains(instance)) {
                        resources.put(instance, new VmwareMultiInstanceCollectionResource(agent, instance, vmwareGroup.getResourceType()));
                        instanceSet.add(instance);
                    }
                    ((VmwareMultiInstanceCollectionResource)((Object)resources.get(instance))).setAttributeValue((CollectionAttributeType)attribType2, String.valueOf(vmwarePerformanceValues.getValue(attrib.getName(), instance)));
                    this.logger.debug("Storing multi instance value " + attrib.getName() + "[" + instance + "]='" + vmwarePerformanceValues.getValue(attrib.getName(), instance) + "' for node " + agent.getNodeId());
                }
            }
            if (instanceSet.isEmpty()) continue;
            Attrib attrib = new Attrib();
            attrib.setName(vmwareGroup.getResourceType() + "Name");
            attrib.setAlias(vmwareGroup.getResourceType() + "Name");
            attrib.setType("String");
            for (String instance : instanceSet) {
                attribType = new VmwareCollectionAttributeType(attrib, attribGroupType);
                this.logger.debug("Storing multi instance value " + attrib.getName() + "[" + instance + "]='" + instance + "' for node " + agent.getNodeId());
                ((VmwareMultiInstanceCollectionResource)((Object)resources.get(instance))).setAttributeValue((CollectionAttributeType)attribType, instance);
            }
            for (String instance : resources.keySet()) {
                collectionSet.getCollectionResources().add(resources.get(instance));
            }
        }
        collectionSet.setStatus(1);
        vmwareViJavaAccess.disconnect();
        return collectionSet;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_vmwareDatacollectionConfigDao.getRrdRepository(collectionName);
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }
}

