/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.vmware.vijava;

import org.opennms.netmgt.collectd.vmware.vijava.VmwareCollectionResource;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.support.AbstractCollectionAttribute;

public class VmwareCollectionAttribute
extends AbstractCollectionAttribute {
    private final String m_value;

    public VmwareCollectionAttribute(VmwareCollectionResource resource, CollectionAttributeType attribType, String value) {
        super(attribType, (CollectionResource)resource);
        this.m_value = value;
    }

    public String getMetricIdentifier() {
        return "Vmware_" + this.m_attribType.getName();
    }

    public Double getNumericValue() {
        try {
            return Double.parseDouble(this.m_value);
        }
        catch (NullPointerException | NumberFormatException e) {
            return null;
        }
    }

    public String getStringValue() {
        return this.m_value;
    }

    public String toString() {
        return "VmwareCollectionAttribute " + this.getName() + "=" + this.m_value;
    }
}

