/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.vmware;

import com.vmware.vim25.GuestNicInfo;
import com.vmware.vim25.HostNetworkInfo;
import com.vmware.vim25.HostServiceTicket;
import com.vmware.vim25.HostVirtualNic;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.PerfEntityMetric;
import com.vmware.vim25.PerfEntityMetricBase;
import com.vmware.vim25.PerfMetricIntSeries;
import com.vmware.vim25.PerfMetricSeries;
import com.vmware.vim25.PerfQuerySpec;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.mo.HostNetworkSystem;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.PerformanceManager;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.util.MorUtil;
import com.vmware.vim25.ws.Client;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.collectd.vmware.vijava.VmwarePerformanceValues;
import org.opennms.netmgt.config.vmware.VmwareServer;
import org.opennms.netmgt.dao.VmwareConfigDao;
import org.opennms.protocols.vmware.ServiceInstancePool;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObject;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.client.CIMClient;
import org.sblim.wbem.client.PasswordCredential;
import org.sblim.wbem.client.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareViJavaAccess {
    private final Logger logger = LoggerFactory.getLogger(VmwareViJavaAccess.class);
    private VmwareConfigDao m_vmwareConfigDao = null;
    private String m_hostname = null;
    private String m_username = null;
    private String m_password = null;
    private ServiceInstance m_serviceInstance = null;
    private PerformanceManager m_performanceManager = null;
    private Map<Integer, PerfCounterInfo> m_perfCounterInfoMap = null;
    private Map<HostSystem, HostServiceTicket> m_hostServiceTickets = new HashMap<HostSystem, HostServiceTicket>();
    private Map<HostSystem, String> m_hostSystemCimUrls = new HashMap<HostSystem, String>();
    private static ServiceInstancePool m_serviceInstancePool = new ServiceInstancePool();

    public VmwareViJavaAccess(String hostname, String username, String password) {
        this.m_hostname = hostname;
        this.m_username = username;
        this.m_password = password;
    }

    public VmwareViJavaAccess(String hostname) throws MarshalException, ValidationException, IOException {
        if (this.m_vmwareConfigDao == null) {
            this.m_vmwareConfigDao = (VmwareConfigDao)BeanUtils.getBean((String)"daoContext", (String)"vmwareConfigDao", VmwareConfigDao.class);
        }
        this.m_hostname = hostname;
        if (this.m_vmwareConfigDao == null) {
            this.logger.error("vmwareConfigDao should be a non-null value.");
        } else {
            Map<String, VmwareServer> serverMap = this.m_vmwareConfigDao.getServerMap();
            if (serverMap == null) {
                this.logger.error("Error getting vmware-config.xml's server map.");
            } else {
                VmwareServer vmwareServer = serverMap.get(this.m_hostname);
                if (vmwareServer == null) {
                    this.logger.error("Error getting credentials for VMware management server '{}'.", (Object)this.m_hostname);
                } else {
                    this.m_username = vmwareServer.getUsername();
                    this.m_password = vmwareServer.getPassword();
                }
            }
        }
        if (this.m_username == null) {
            this.logger.error("Error getting username for VMware management server '{}'.", (Object)this.m_hostname);
            this.m_username = "";
        }
        if (this.m_password == null) {
            this.logger.error("Error getting password for VMware management server '{}'.", (Object)this.m_hostname);
            this.m_password = "";
        }
    }

    public void connect() throws MalformedURLException, RemoteException {
        this.relax();
        this.m_serviceInstance = m_serviceInstancePool.retain(this.m_hostname, this.m_username, this.m_password);
    }

    public boolean setTimeout(int timeout) {
        Client client;
        VimPortType vimService;
        ServerConnection serverConnection;
        if (this.m_serviceInstance != null && (serverConnection = this.m_serviceInstance.getServerConnection()) != null && (vimService = serverConnection.getVimService()) != null && (client = vimService.getWsc()) != null) {
            client.setConnectTimeout(timeout);
            client.setReadTimeout(timeout);
            return true;
        }
        return false;
    }

    public void disconnect() {
        m_serviceInstancePool.release(this.m_serviceInstance);
    }

    protected void relax() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        catch (Exception exception) {
            this.logger.warn("Error setting relaxed SSL policy", (Throwable)exception);
        }
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
    }

    private PerformanceManager getPerformanceManager() {
        if (this.m_performanceManager == null) {
            this.m_performanceManager = this.m_serviceInstance.getPerformanceManager();
        }
        return this.m_performanceManager;
    }

    public Map<Integer, PerfCounterInfo> getPerfCounterInfoMap() {
        if (this.m_perfCounterInfoMap == null) {
            PerfCounterInfo[] perfCounterInfos;
            this.m_perfCounterInfoMap = new HashMap<Integer, PerfCounterInfo>();
            for (PerfCounterInfo perfCounterInfo : perfCounterInfos = this.getPerformanceManager().getPerfCounter()) {
                this.m_perfCounterInfoMap.put(perfCounterInfo.getKey(), perfCounterInfo);
            }
        }
        return this.m_perfCounterInfoMap;
    }

    public ManagedEntity getManagedEntityByManagedObjectId(String managedObjectId) {
        ManagedObjectReference managedObjectReference = new ManagedObjectReference();
        managedObjectReference.setType("ManagedEntity");
        managedObjectReference.setVal(managedObjectId);
        ManagedEntity managedEntity = MorUtil.createExactManagedEntity((ServerConnection)this.m_serviceInstance.getServerConnection(), (ManagedObjectReference)managedObjectReference);
        return managedEntity;
    }

    public VirtualMachine getVirtualMachineByManagedObjectId(String managedObjectId) {
        ManagedObjectReference managedObjectReference = new ManagedObjectReference();
        managedObjectReference.setType("VirtualMachine");
        managedObjectReference.setVal(managedObjectId);
        VirtualMachine virtualMachine = (VirtualMachine)MorUtil.createExactManagedEntity((ServerConnection)this.m_serviceInstance.getServerConnection(), (ManagedObjectReference)managedObjectReference);
        return virtualMachine;
    }

    public HostSystem getHostSystemByManagedObjectId(String managedObjectId) {
        ManagedObjectReference managedObjectReference = new ManagedObjectReference();
        managedObjectReference.setType("HostSystem");
        managedObjectReference.setVal(managedObjectId);
        HostSystem hostSystem = (HostSystem)MorUtil.createExactManagedEntity((ServerConnection)this.m_serviceInstance.getServerConnection(), (ManagedObjectReference)managedObjectReference);
        return hostSystem;
    }

    private String getHumanReadableName(PerfCounterInfo perfCounterInfo) {
        return perfCounterInfo.getGroupInfo().getKey() + "." + perfCounterInfo.getNameInfo().getKey() + "." + perfCounterInfo.getRollupType().toString();
    }

    public VmwarePerformanceValues queryPerformanceValues(ManagedEntity managedEntity) throws RemoteException {
        VmwarePerformanceValues vmwarePerformanceValues = new VmwarePerformanceValues();
        int refreshRate = this.getPerformanceManager().queryPerfProviderSummary(managedEntity).getRefreshRate();
        PerfQuerySpec perfQuerySpec = new PerfQuerySpec();
        perfQuerySpec.setEntity(managedEntity.getMOR());
        perfQuerySpec.setMaxSample(Integer.valueOf(1));
        perfQuerySpec.setIntervalId(Integer.valueOf(refreshRate));
        PerfEntityMetricBase[] perfEntityMetricBases = this.getPerformanceManager().queryPerf(new PerfQuerySpec[]{perfQuerySpec});
        if (perfEntityMetricBases != null) {
            for (int i = 0; i < perfEntityMetricBases.length; ++i) {
                PerfMetricSeries[] perfMetricSeries = ((PerfEntityMetric)perfEntityMetricBases[i]).getValue();
                for (int j = 0; perfMetricSeries != null && j < perfMetricSeries.length; ++j) {
                    long[] longs;
                    if (!(perfMetricSeries[j] instanceof PerfMetricIntSeries) || (longs = ((PerfMetricIntSeries)perfMetricSeries[j]).getValue()).length != 1) continue;
                    PerfCounterInfo perfCounterInfo = this.getPerfCounterInfoMap().get(perfMetricSeries[j].getId().getCounterId());
                    String instance = perfMetricSeries[j].getId().getInstance();
                    String name = this.getHumanReadableName(perfCounterInfo);
                    if (instance != null && !"".equals(instance)) {
                        vmwarePerformanceValues.addValue(name, instance, longs[0]);
                        continue;
                    }
                    vmwarePerformanceValues.addValue(name, longs[0]);
                }
            }
        }
        return vmwarePerformanceValues;
    }

    public List<CIMObject> queryCimObjects(HostSystem hostSystem, String cimClass, String primaryIpAddress) throws ConnectException, RemoteException, CIMException {
        ArrayList<CIMObject> cimObjects = new ArrayList<CIMObject>();
        if (!this.m_hostServiceTickets.containsKey(hostSystem)) {
            this.m_hostServiceTickets.put(hostSystem, hostSystem.acquireCimServicesTicket());
        }
        HostServiceTicket hostServiceTicket = this.m_hostServiceTickets.get(hostSystem);
        if (!this.m_hostSystemCimUrls.containsKey(hostSystem)) {
            String ipAddress = primaryIpAddress;
            if (ipAddress == null) {
                ipAddress = this.getPrimaryHostSystemIpAddress(hostSystem);
            }
            if (ipAddress == null) {
                this.logger.warn("Cannot determine ip address for host system '{}'", (Object)hostSystem.getMOR().getVal());
                return cimObjects;
            }
            this.m_hostSystemCimUrls.put(hostSystem, "https://" + ipAddress + ":5989");
        }
        String cimAgentAddress = this.m_hostSystemCimUrls.get(hostSystem);
        String namespace = "root/cimv2";
        UserPrincipal userPr = new UserPrincipal(hostServiceTicket.getSessionId());
        PasswordCredential pwCred = new PasswordCredential(hostServiceTicket.getSessionId().toCharArray());
        CIMNameSpace ns = new CIMNameSpace(cimAgentAddress, namespace);
        CIMClient cimClient = new CIMClient(ns, (Principal)userPr, (Object)pwCred);
        cimClient.getSessionProperties().setHttpTimeOut(3000);
        cimClient.useMPost(false);
        CIMObjectPath rpCOP = new CIMObjectPath(cimClass);
        Enumeration rpEnm = cimClient.enumerateInstances(rpCOP);
        while (rpEnm.hasMoreElements()) {
            CIMObject rp = (CIMObject)rpEnm.nextElement();
            cimObjects.add(rp);
        }
        return cimObjects;
    }

    public List<CIMObject> queryCimObjects(HostSystem hostSystem, String cimClass) throws ConnectException, RemoteException, CIMException {
        return this.queryCimObjects(hostSystem, cimClass, null);
    }

    public String getPrimaryHostSystemIpAddress(HostSystem hostSystem) {
        TreeSet<String> addresses = this.getHostSystemIpAddresses(hostSystem);
        String ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(hostSystem.getName()).getHostAddress();
        }
        catch (Exception e) {
            this.logger.debug("Can't resolve the IP address from {}.", (Object)hostSystem.getName());
        }
        if (ipAddress == null) {
            return addresses.first();
        }
        return addresses.contains(ipAddress) ? ipAddress : addresses.first();
    }

    public TreeSet<String> getHostSystemIpAddresses(HostSystem hostSystem) {
        HostNetworkInfo hostNetworkInfo;
        TreeSet<String> ipAddresses = new TreeSet<String>();
        HostNetworkSystem hostNetworkSystem = null;
        try {
            hostNetworkSystem = hostSystem.getHostNetworkSystem();
        }
        catch (RemoteException e) {
            this.logger.warn("Error fetching network information for Host System '{}' (ID: {})", (Object)hostSystem.getName(), (Object)hostSystem.getMOR().getVal());
            this.logger.warn("Exception thrown while fetching network information: {}", (Throwable)e);
            return ipAddresses;
        }
        if (hostNetworkSystem != null && (hostNetworkInfo = hostNetworkSystem.getNetworkInfo()) != null) {
            HostVirtualNic[] hostVirtualNics = hostNetworkInfo.getConsoleVnic();
            if (hostVirtualNics != null) {
                for (HostVirtualNic hostVirtualNic : hostVirtualNics) {
                    ipAddresses.add(hostVirtualNic.getSpec().getIp().getIpAddress());
                }
            }
            if ((hostVirtualNics = hostNetworkInfo.getVnic()) != null) {
                for (HostVirtualNic hostVirtualNic : hostVirtualNics) {
                    ipAddresses.add(hostVirtualNic.getSpec().getIp().getIpAddress());
                }
            }
        }
        return ipAddresses;
    }

    public TreeSet<String> getVirtualMachineIpAddresses(VirtualMachine virtualMachine) {
        TreeSet<String> ipAddresses = new TreeSet<String>();
        if (virtualMachine.getGuest().getIpAddress() != null) {
            ipAddresses.add(virtualMachine.getGuest().getIpAddress());
        }
        if (virtualMachine.getGuest().getNet() != null) {
            for (GuestNicInfo guestNicInfo : virtualMachine.getGuest().getNet()) {
                if (guestNicInfo.getIpAddress() == null) continue;
                for (String ipAddress : guestNicInfo.getIpAddress()) {
                    ipAddresses.add(ipAddress);
                }
            }
        }
        return ipAddresses;
    }

    public ManagedEntity[] searchManagedEntities(String type) throws RemoteException {
        return new InventoryNavigator((ManagedEntity)this.m_serviceInstance.getRootFolder()).searchManagedEntities(type);
    }

    public int getMajorApiVersion() {
        if (this.m_serviceInstance != null) {
            String apiVersion = this.m_serviceInstance.getAboutInfo().getApiVersion();
            String[] arr = apiVersion.split("\\.");
            if (arr.length > 1) {
                int apiMajorVersion = Integer.valueOf(arr[0]);
                if (apiMajorVersion < 4) {
                    apiMajorVersion = 3;
                }
                return apiMajorVersion;
            }
            this.logger.error("Cannot parse vCenter API version '{}'", (Object)apiVersion);
            return 0;
        }
        return 0;
    }

    public String getPropertyOfCimObject(CIMObject cimObject, String propertyName) {
        if (cimObject == null) {
            return null;
        }
        CIMProperty cimProperty = cimObject.getProperty(propertyName);
        if (cimProperty == null) {
            return null;
        }
        CIMValue cimValue = cimProperty.getValue();
        if (cimValue == null) {
            return null;
        }
        Object object = cimValue.getValue();
        if (object == null) {
            return null;
        }
        return object.toString();
    }
}

