/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.vmware;

import com.vmware.vim25.CustomFieldDef;
import com.vmware.vim25.CustomFieldStringValue;
import com.vmware.vim25.CustomFieldValue;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.DistributedVirtualPortgroup;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.Network;
import com.vmware.vim25.mo.VirtualMachine;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.util.InetAddressUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.url.GenericURLConnection;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAsset;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.protocols.vmware.VmwareViJavaAccess;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareRequisitionUrlConnection
extends GenericURLConnection {
    private Logger logger = LoggerFactory.getLogger(VmwareRequisitionUrlConnection.class);
    private static final String VMWARE_HOSTSYSTEM_SERVICES = "hostSystemServices";
    private static final String VMWARE_VIRTUALMACHINE_SERVICES = "virtualMachineServices";
    private String[] m_hostSystemServices;
    private String[] m_virtualMachineServices;
    private String m_hostname = null;
    private String m_username = null;
    private String m_password = null;
    protected String m_foreignSource = null;
    private boolean m_importVMPoweredOn = true;
    private boolean m_importVMPoweredOff = false;
    private boolean m_importVMSuspended = false;
    private boolean m_importHostPoweredOn = true;
    private boolean m_importHostPoweredOff = false;
    private boolean m_importHostStandBy = false;
    private boolean m_importHostUnknown = false;
    private boolean m_persistIPv4 = true;
    private boolean m_persistIPv6 = true;
    private boolean m_persistVMs = true;
    private boolean m_persistHosts = true;
    private boolean m_topologyPortGroups = false;
    private boolean m_topologyNetworks = true;
    private boolean m_topologyDatastores = true;
    private Map<String, String> m_hostSystemMap = new HashMap<String, String>();
    private Map<String, String> m_args = null;
    private Requisition m_requisition = null;

    public VmwareRequisitionUrlConnection(URL url) throws MalformedURLException, RemoteException {
        super(url);
        this.m_hostname = url.getHost();
        this.m_username = this.getUsername();
        this.m_password = this.getPassword();
        this.m_args = this.getQueryArgs();
        boolean importVMOnly = this.queryParameter("importVMOnly", false);
        boolean importHostOnly = this.queryParameter("importHostOnly", false);
        if (importHostOnly && importVMOnly) {
            throw new MalformedURLException("importHostOnly and importVMOnly can't be true simultaneously");
        }
        if (importHostOnly) {
            this.m_persistVMs = false;
        }
        if (importVMOnly) {
            this.m_persistHosts = false;
        }
        boolean importIPv4Only = this.queryParameter("importIPv4Only", false);
        boolean importIPv6Only = this.queryParameter("importIPv6Only", false);
        if (importIPv4Only && importIPv6Only) {
            throw new MalformedURLException("importIPv4Only and importIPv6Only can't be true simultaneously");
        }
        if (importIPv4Only) {
            this.m_persistIPv6 = false;
        }
        if (importIPv6Only) {
            this.m_persistIPv4 = false;
        }
        this.m_topologyPortGroups = this.queryParameter("topologyPortGroups", false);
        this.m_topologyNetworks = this.queryParameter("topologyNetworks", true);
        this.m_topologyDatastores = this.queryParameter("topologyDatastores", true);
        this.m_importVMPoweredOn = this.queryParameter("importVMPoweredOn", true);
        this.m_importVMPoweredOff = this.queryParameter("importVMPoweredOff", false);
        this.m_importVMSuspended = this.queryParameter("importVMSuspended", false);
        this.m_importHostPoweredOn = this.queryParameter("importHostPoweredOn", true);
        this.m_importHostPoweredOff = this.queryParameter("importHostPoweredOff", false);
        this.m_importHostStandBy = this.queryParameter("importHostStandBy", false);
        this.m_importHostUnknown = this.queryParameter("importHostUnknown", false);
        if (this.queryParameter("importHostAll", false)) {
            this.m_importHostPoweredOn = true;
            this.m_importHostPoweredOff = true;
            this.m_importHostStandBy = true;
            this.m_importHostUnknown = true;
        }
        if (this.queryParameter("importVMAll", false)) {
            this.m_importVMPoweredOff = true;
            this.m_importVMPoweredOn = true;
            this.m_importVMSuspended = true;
        }
        String path = url.getPath();
        path = path.replaceAll("^/", "");
        String[] pathElements = (path = path.replaceAll("/$", "")).split("/");
        if (pathElements.length == 1) {
            this.m_foreignSource = "".equals(pathElements[0]) ? "vmware-" + this.m_hostname : pathElements[0];
        } else {
            throw new MalformedURLException("Error processing path element of URL (vmware://username:password@host[/foreign-source]?keyA=valueA;keyB=valueB;...)");
        }
    }

    private boolean queryParameter(String key, boolean defaultValue) {
        if (this.m_args.get(key) == null) {
            return defaultValue;
        }
        String value = this.m_args.get(key).toLowerCase();
        return "yes".equals(value) || "true".equals(value) || "on".equals(value) || "1".equals(value);
    }

    public void connect() throws IOException {
    }

    private boolean reachableCimService(VmwareViJavaAccess vmwareViJavaAccess, HostSystem hostSystem, String ipAddress) {
        if (!vmwareViJavaAccess.setTimeout(3000)) {
            this.logger.warn("Error setting connection timeout");
        }
        List<CIMObject> cimObjects = null;
        try {
            cimObjects = vmwareViJavaAccess.queryCimObjects(hostSystem, "CIM_NumericSensor", ipAddress);
        }
        catch (ConnectException e) {
            return false;
        }
        catch (RemoteException e) {
            return false;
        }
        catch (CIMException e) {
            return false;
        }
        return cimObjects != null;
    }

    /*
     * Unable to fully structure code
     */
    private RequisitionNode createRequisitionNode(Set<String> ipAddresses, ManagedEntity managedEntity, int apiVersion, VmwareViJavaAccess vmwareViJavaAccess) {
        requisitionNode = new RequisitionNode();
        requisitionNode.setNodeLabel(managedEntity.getName());
        requisitionNode.setForeignId(managedEntity.getMOR().getVal());
        if (managedEntity instanceof VirtualMachine) {
            firstInterface = true;
            for (String ipAddress : ipAddresses) {
                try {
                    if ((!this.m_persistIPv4 || !InetAddressUtils.isIPv4Address((String)ipAddress)) && (!this.m_persistIPv6 || !InetAddressUtils.isIPv6Address((String)ipAddress)) || (inetAddress = InetAddress.getByName(ipAddress)).isLoopbackAddress()) continue;
                    requisitionInterface = new RequisitionInterface();
                    requisitionInterface.setIpAddr(ipAddress);
                    if (firstInterface) {
                        requisitionInterface.setSnmpPrimary(PrimaryType.PRIMARY);
                        for (String service : this.m_virtualMachineServices) {
                            requisitionInterface.insertMonitoredService(new RequisitionMonitoredService(service.trim()));
                        }
                        firstInterface = false;
                    } else {
                        requisitionInterface.setSnmpPrimary(PrimaryType.SECONDARY);
                    }
                    requisitionInterface.setManaged(Boolean.TRUE);
                    requisitionInterface.setStatus(Integer.valueOf(1));
                    requisitionNode.putInterface(requisitionInterface);
                }
                catch (UnknownHostException unknownHostException) {
                    this.logger.warn("Invalid IP address '{}'", (Object)unknownHostException.getMessage());
                }
            }
        } else if (managedEntity instanceof HostSystem) {
            reachableInterfaceFound = false;
            firstInterface = true;
            requisitionInterfaceList = new ArrayList<RequisitionInterface>();
            primaryInterfaceCandidate = null;
            for (String ipAddress : ipAddresses) {
                try {
                    if ((!this.m_persistIPv4 || !InetAddressUtils.isIPv4Address((String)ipAddress)) && (!this.m_persistIPv6 || !InetAddressUtils.isIPv6Address((String)ipAddress)) || (inetAddress = InetAddress.getByName(ipAddress)).isLoopbackAddress()) continue;
                    requisitionInterface = new RequisitionInterface();
                    requisitionInterface.setIpAddr(ipAddress);
                    if (firstInterface) {
                        primaryInterfaceCandidate = requisitionInterface;
                        firstInterface = false;
                    }
                    if (!reachableInterfaceFound && this.reachableCimService(vmwareViJavaAccess, (HostSystem)managedEntity, ipAddress)) {
                        primaryInterfaceCandidate = requisitionInterface;
                        reachableInterfaceFound = true;
                    }
                    requisitionInterface.setManaged(Boolean.TRUE);
                    requisitionInterface.setStatus(Integer.valueOf(1));
                    requisitionInterface.setSnmpPrimary(PrimaryType.SECONDARY);
                    requisitionInterfaceList.add(requisitionInterface);
                }
                catch (UnknownHostException unknownHostException) {
                    this.logger.warn("Invalid IP address '{}'", (Object)unknownHostException.getMessage());
                }
            }
            if (primaryInterfaceCandidate != null) {
                if (reachableInterfaceFound) {
                    this.logger.warn("Found reachable primary interface '{}'", (Object)primaryInterfaceCandidate.getIpAddr());
                } else {
                    this.logger.warn("Only non-reachable interfaces found, using first one for primary interface '{}'", (Object)primaryInterfaceCandidate.getIpAddr());
                }
                primaryInterfaceCandidate.setSnmpPrimary(PrimaryType.PRIMARY);
                for (String service : this.m_hostSystemServices) {
                    if (!reachableInterfaceFound && "VMwareCim-HostSystem".equals(service)) continue;
                    primaryInterfaceCandidate.insertMonitoredService(new RequisitionMonitoredService(service.trim()));
                }
            } else {
                this.logger.warn("No primary interface found");
            }
            for (RequisitionInterface requisitionInterface : requisitionInterfaceList) {
                requisitionNode.putInterface(requisitionInterface);
            }
        } else {
            this.logger.error("Undefined type of managedEntity '{}'", (Object)managedEntity.getMOR().getType());
            return null;
        }
        powerState = "unknown";
        vmwareTopologyInfo = new StringBuffer();
        parentEntity = managedEntity.getParent();
        do {
            if (vmwareTopologyInfo.length() > 0) {
                vmwareTopologyInfo.append(", ");
            }
            try {
                if (parentEntity != null && parentEntity.getMOR() != null) {
                    vmwareTopologyInfo.append(parentEntity.getMOR().getVal() + "/" + URLEncoder.encode(parentEntity.getName(), "UTF-8"));
                    continue;
                }
                this.logger.warn("Can't add topologyInformation because either the parentEntity or the MOR is null for " + managedEntity.getName());
            }
            catch (UnsupportedEncodingException e) {
                this.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
            }
        } while ((parentEntity = parentEntity == null ? null : parentEntity.getParent()) != null);
        if (managedEntity instanceof HostSystem) {
            hostSystem = (HostSystem)managedEntity;
            hostRuntimeInfo = hostSystem.getRuntime();
            if (hostRuntimeInfo == null) {
                this.logger.debug("hostRuntimeInfo=null");
            } else {
                hostSystemPowerState = hostRuntimeInfo.getPowerState();
                if (hostSystemPowerState == null) {
                    this.logger.debug("hostSystemPowerState=null");
                } else {
                    powerState = hostSystemPowerState.toString();
                }
            }
            try {
                if (this.m_topologyDatastores) {
                    for (Datastore datastore : hostSystem.getDatastores()) {
                        if (vmwareTopologyInfo.length() > 0) {
                            vmwareTopologyInfo.append(", ");
                        }
                        try {
                            vmwareTopologyInfo.append(datastore.getMOR().getVal() + "/" + URLEncoder.encode(datastore.getSummary().getName(), "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            this.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
                        }
                    }
                }
            }
            catch (RemoteException e) {
                this.logger.warn("Cannot retrieve datastores for managedEntity '{}': '{}'", (Object)managedEntity.getMOR().getVal(), (Object)e.getMessage());
            }
            try {
                if (!this.m_topologyNetworks) ** GOTO lbl188
                for (Network network : hostSystem.getNetworks()) {
                    if (vmwareTopologyInfo.length() > 0) {
                        vmwareTopologyInfo.append(", ");
                    }
                    try {
                        if (network instanceof DistributedVirtualPortgroup && !this.m_topologyPortGroups) continue;
                        vmwareTopologyInfo.append(network.getMOR().getVal() + "/" + URLEncoder.encode(network.getSummary().getName(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
                    }
                }
            }
            catch (RemoteException e) {
                this.logger.warn("Cannot retrieve networks for managedEntity '{}': '{}'", (Object)managedEntity.getMOR().getVal(), (Object)e.getMessage());
            }
        } else if (managedEntity instanceof VirtualMachine) {
            virtualMachine = (VirtualMachine)managedEntity;
            virtualMachineRuntimeInfo = virtualMachine.getRuntime();
            if (virtualMachineRuntimeInfo == null) {
                this.logger.debug("virtualMachineRuntimeInfo=null");
            } else {
                virtualMachinePowerState = virtualMachineRuntimeInfo.getPowerState();
                if (virtualMachinePowerState == null) {
                    this.logger.debug("virtualMachinePowerState=null");
                } else {
                    powerState = virtualMachinePowerState.toString();
                }
            }
            try {
                if (this.m_topologyDatastores) {
                    for (Datastore datastore : virtualMachine.getDatastores()) {
                        if (vmwareTopologyInfo.length() > 0) {
                            vmwareTopologyInfo.append(", ");
                        }
                        try {
                            vmwareTopologyInfo.append(datastore.getMOR().getVal() + "/" + URLEncoder.encode(datastore.getSummary().getName(), "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            this.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
                        }
                    }
                }
            }
            catch (RemoteException e) {
                this.logger.warn("Cannot retrieve datastores for managedEntity '{}': '{}'", (Object)managedEntity.getMOR().getVal(), (Object)e.getMessage());
            }
            try {
                if (this.m_topologyNetworks) {
                    for (Network network : virtualMachine.getNetworks()) {
                        if (vmwareTopologyInfo.length() > 0) {
                            vmwareTopologyInfo.append(", ");
                        }
                        try {
                            if (network instanceof DistributedVirtualPortgroup && !this.m_topologyPortGroups) continue;
                            vmwareTopologyInfo.append(network.getMOR().getVal() + "/" + URLEncoder.encode(network.getSummary().getName(), "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            this.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
                        }
                    }
                }
            }
            catch (RemoteException e) {
                this.logger.warn("Cannot retrieve networks for managedEntity '{}': '{}'", (Object)managedEntity.getMOR().getVal(), (Object)e.getMessage());
            }
            if (vmwareTopologyInfo.length() > 0) {
                vmwareTopologyInfo.append(", ");
            }
            try {
                vmwareTopologyInfo.append(virtualMachine.getRuntime().getHost().getVal() + "/" + URLEncoder.encode(this.m_hostSystemMap.get(virtualMachine.getRuntime().getHost().getVal()), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
            }
        } else {
            this.logger.error("Undefined type of managedEntity '{}'", (Object)managedEntity.getMOR().getType());
            return null;
        }
lbl188:
        // 5 sources

        requisitionAssetHostname = new RequisitionAsset("vmwareManagementServer", this.m_hostname);
        requisitionNode.putAsset(requisitionAssetHostname);
        requisitionAssetType = new RequisitionAsset("vmwareManagedEntityType", managedEntity instanceof HostSystem != false ? "HostSystem" : "VirtualMachine");
        requisitionNode.putAsset(requisitionAssetType);
        requisitionAssetId = new RequisitionAsset("vmwareManagedObjectId", managedEntity.getMOR().getVal());
        requisitionNode.putAsset(requisitionAssetId);
        requisitionAssetTopologyInfo = new RequisitionAsset("vmwareTopologyInfo", vmwareTopologyInfo.toString());
        requisitionNode.putAsset(requisitionAssetTopologyInfo);
        requisitionAssetState = new RequisitionAsset("vmwareState", powerState);
        requisitionNode.putAsset(requisitionAssetState);
        requisitionNode.putCategory(new RequisitionCategory("VMware" + apiVersion));
        return requisitionNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Requisition buildVMwareRequisition() {
        VmwareViJavaAccess vmwareViJavaAccess = null;
        this.m_requisition = new Requisition(this.m_foreignSource);
        this.logger.debug("Creating new VIJava access object for host {} ...", (Object)this.m_hostname);
        if (this.m_username == null || "".equals(this.m_username) || this.m_password == null || "".equals(this.m_password)) {
            try {
                vmwareViJavaAccess = new VmwareViJavaAccess(this.m_hostname);
            }
            catch (MarshalException e) {
                this.logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)this.m_hostname, (Object)e.getMessage());
                return null;
            }
            catch (ValidationException e) {
                this.logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)this.m_hostname, (Object)e.getMessage());
                return null;
            }
            catch (IOException e) {
                this.logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)this.m_hostname, (Object)e.getMessage());
                return null;
            }
        } else {
            vmwareViJavaAccess = new VmwareViJavaAccess(this.m_hostname, this.m_username, this.m_password);
        }
        this.logger.debug("Successfully created new VIJava access object for host {}", (Object)this.m_hostname);
        this.logger.debug("Connecting VIJava access for host {} ...", (Object)this.m_hostname);
        try {
            vmwareViJavaAccess.connect();
        }
        catch (MalformedURLException e) {
            this.logger.warn("Error connecting VMware management server '{}': '{}'", (Object)this.m_hostname, (Object)e.getMessage());
            return null;
        }
        catch (RemoteException e) {
            this.logger.warn("Error connecting VMware management server '{}': '{}'", (Object)this.m_hostname, (Object)e.getMessage());
            return null;
        }
        this.logger.debug("Successfully connected VIJava access for host {}", (Object)this.m_hostname);
        this.logger.debug("Starting to enumerate VMware managed objects from host {} ...", (Object)this.m_hostname);
        try {
            int apiVersion = vmwareViJavaAccess.getMajorApiVersion();
            this.m_hostSystemServices = this.m_args != null && this.m_args.get(VMWARE_HOSTSYSTEM_SERVICES) != null ? this.m_args.get(VMWARE_HOSTSYSTEM_SERVICES).split(",") : new String[]{"VMware-ManagedEntity", "VMware-HostSystem", "VMwareCim-HostSystem"};
            this.m_virtualMachineServices = this.m_args != null && this.m_args.get(VMWARE_VIRTUALMACHINE_SERVICES) != null ? this.m_args.get(VMWARE_VIRTUALMACHINE_SERVICES).split(",") : new String[]{"VMware-ManagedEntity", "VMware-VirtualMachine"};
            this.logger.debug("Starting to iterate host system managed objects from host {} ...", (Object)this.m_hostname);
            this.iterateHostSystems(vmwareViJavaAccess, apiVersion);
            this.logger.debug("Done iterating host system managed objects from host {}", (Object)this.m_hostname);
            this.logger.debug("Starting to iterate VM managed objects from host {} ...", (Object)this.m_hostname);
            this.iterateVirtualMachines(vmwareViJavaAccess, apiVersion);
            this.logger.debug("Done iterating VM managed objects from host {}", (Object)this.m_hostname);
        }
        catch (RemoteException e) {
            this.logger.warn("Error retrieving managed objects from VMware management server '{}': '{}'", (Object)this.m_hostname, (Object)e.getMessage());
            Requisition requisition = null;
            return requisition;
        }
        finally {
            vmwareViJavaAccess.disconnect();
        }
        return this.m_requisition;
    }

    private boolean checkHostPowerState(HostSystem hostSystem) {
        this.logger.debug("Checking power state for host system {} (ID {})", (Object)hostSystem.getName(), (Object)hostSystem.getMOR().getVal());
        String powerState = hostSystem.getRuntime().getPowerState().toString();
        if ("poweredOn".equals(powerState) && this.m_importHostPoweredOn) {
            return true;
        }
        if ("poweredOff".equals(powerState) && this.m_importHostPoweredOff) {
            return true;
        }
        if ("standBy".equals(powerState) && this.m_importHostStandBy) {
            return true;
        }
        return "unknown".equals(powerState) && this.m_importHostUnknown;
    }

    private boolean checkVMPowerState(VirtualMachine virtualMachine) {
        this.logger.debug("Checking power state for VM {} (ID: {})", (Object)virtualMachine.getName(), (Object)virtualMachine.getMOR().getVal());
        String powerState = virtualMachine.getRuntime().getPowerState().toString();
        if ("poweredOn".equals(powerState) && this.m_importVMPoweredOn) {
            return true;
        }
        if ("poweredOff".equals(powerState) && this.m_importVMPoweredOff) {
            return true;
        }
        return "suspended".equals(powerState) && this.m_importVMSuspended;
    }

    private void iterateHostSystems(VmwareViJavaAccess vmwareViJavaAccess, int apiVersion) throws RemoteException {
        this.logger.debug("Starting to iterate host systems on VMware host {} ...", (Object)this.m_hostname);
        ManagedEntity[] hostSystems = vmwareViJavaAccess.searchManagedEntities("HostSystem");
        if (hostSystems != null) {
            for (ManagedEntity managedEntity : hostSystems) {
                HostSystem hostSystem = (HostSystem)managedEntity;
                this.logger.debug("Iterating host systems on VMware management server {} : {} (ID: {})", new Object[]{this.m_hostname, hostSystem.getName(), hostSystem.getMOR().getVal()});
                this.m_hostSystemMap.put(hostSystem.getMOR().getVal(), hostSystem.getName());
                if (!this.checkHostPowerState(hostSystem) || !this.checkForAttribute((ManagedEntity)hostSystem)) continue;
                this.logger.debug("Adding Host System '{}' (ID: {})", (Object)hostSystem.getName(), (Object)hostSystem.getMOR().getVal());
                TreeSet<String> ipAddresses = vmwareViJavaAccess.getHostSystemIpAddresses(hostSystem);
                RequisitionNode node = this.createRequisitionNode(ipAddresses, (ManagedEntity)hostSystem, apiVersion, vmwareViJavaAccess);
                try {
                    node.putAsset(new RequisitionAsset("cpu", hostSystem.getHardware().getCpuInfo().getNumCpuCores() + " cores"));
                }
                catch (Exception e) {
                    this.logger.debug("Can't find CPU information for {} (ID: {})", (Object)hostSystem.getName(), (Object)hostSystem.getMOR().getVal());
                }
                try {
                    node.putAsset(new RequisitionAsset("ram", Math.round((float)hostSystem.getHardware().getMemorySize() / 1000000.0f) + " MB"));
                }
                catch (Exception e) {
                    this.logger.debug("Can't find Memory information for {} (ID: {})", (Object)hostSystem.getName(), (Object)hostSystem.getMOR().getVal());
                }
                if (node == null || !this.m_persistHosts) continue;
                this.m_requisition.insertNode(node);
            }
        }
    }

    private void iterateVirtualMachines(VmwareViJavaAccess vmwareViJavaAccess, int apiVersion) throws RemoteException {
        ManagedEntity[] virtualMachines = vmwareViJavaAccess.searchManagedEntities("VirtualMachine");
        if (virtualMachines != null) {
            for (ManagedEntity managedEntity : virtualMachines) {
                VirtualMachine virtualMachine = (VirtualMachine)managedEntity;
                this.logger.debug("Iterating host systems on VMware management server {} : {} (ID: {})", new Object[]{this.m_hostname, virtualMachine.getName(), virtualMachine.getMOR().getVal()});
                if (!this.checkVMPowerState(virtualMachine) || !this.checkForAttribute((ManagedEntity)virtualMachine)) continue;
                this.logger.debug("Adding Virtual Machine '{}' (ID: {})", (Object)virtualMachine.getName(), (Object)virtualMachine.getMOR().getVal());
                TreeSet<String> ipAddresses = vmwareViJavaAccess.getVirtualMachineIpAddresses(virtualMachine);
                RequisitionNode node = this.createRequisitionNode(ipAddresses, (ManagedEntity)virtualMachine, apiVersion, vmwareViJavaAccess);
                if (virtualMachine.getGuest().getGuestFullName() != null) {
                    node.putAsset(new RequisitionAsset("operatingSystem", virtualMachine.getGuest().getGuestFullName()));
                }
                try {
                    node.putAsset(new RequisitionAsset("cpu", virtualMachine.getConfig().getHardware().getNumCPU() + " vCPU"));
                }
                catch (Exception e) {
                    this.logger.debug("Can't find CPU information for {} (ID: {})", (Object)virtualMachine.getName(), (Object)virtualMachine.getMOR().getVal());
                }
                try {
                    node.putAsset(new RequisitionAsset("ram", virtualMachine.getConfig().getHardware().getMemoryMB() + " MB"));
                }
                catch (Exception e) {
                    this.logger.debug("Can't find Memory information for {} (ID: {})", (Object)virtualMachine.getName(), (Object)virtualMachine.getMOR().getVal());
                }
                if (node == null || !this.m_persistVMs) continue;
                this.m_requisition.insertNode(node);
            }
        }
    }

    private boolean checkForAttribute(ManagedEntity managedEntity) throws RemoteException {
        this.logger.debug("Getting custom attributes from VMware management server {} : ManagedEntity {} (ID: {})", new Object[]{this.m_hostname, managedEntity.getName(), managedEntity.getMOR().getVal()});
        Map<String, String> attribMap = this.getCustomAttributes(managedEntity);
        TreeSet<String> keySet = new TreeSet<String>();
        for (String k : this.m_args.keySet()) {
            if (!k.startsWith("_")) continue;
            keySet.add(k);
        }
        if (!keySet.isEmpty()) {
            boolean ok = true;
            for (String keyName : keySet) {
                String attribValue = attribMap.get(StringUtils.removeStart((String)keyName, (String)"_"));
                if (attribValue == null) {
                    ok = false;
                    continue;
                }
                String keyValue = this.m_args.get(keyName);
                if (keyValue.startsWith("~")) {
                    ok = ok && attribValue.matches(StringUtils.removeStart((String)keyValue, (String)"~"));
                    continue;
                }
                ok = ok && attribValue.equals(keyValue);
            }
            return ok;
        }
        String key = this.m_args.get("key");
        String value = this.m_args.get("value");
        if (key == null && value == null) {
            return true;
        }
        if (key == null || value == null) {
            return false;
        }
        String attribValue = attribMap.get(key);
        if (attribValue != null) {
            if (value.startsWith("~")) {
                return attribValue.matches(StringUtils.removeStart((String)value, (String)"~"));
            }
            return attribValue.equals(value);
        }
        return false;
    }

    private Map<String, String> getCustomAttributes(ManagedEntity entity) throws RemoteException {
        TreeMap<String, String> attributes = new TreeMap<String, String>();
        this.logger.debug("Getting custom attributes from VMware management server {} : ManagedEntity {} (ID: {})", new Object[]{this.m_hostname, entity.getName(), entity.getMOR().getVal()});
        CustomFieldDef[] defs = entity.getAvailableField();
        CustomFieldValue[] values = entity.getCustomValue();
        for (int i = 0; defs != null && i < defs.length; ++i) {
            String key = defs[i].getName();
            int targetIndex = defs[i].getKey();
            for (int j = 0; values != null && j < values.length; ++j) {
                if (targetIndex != values[j].getKey()) continue;
                attributes.put(key, ((CustomFieldStringValue)values[j]).getValue());
            }
        }
        return attributes;
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayInputStream stream = null;
        try {
            this.logger.debug("Getting existing requisition (if any) for VMware management server {}", (Object)this.m_hostname);
            Requisition curReq = this.getExistingRequisition();
            this.logger.debug("Building new requisition for VMware management server {}", (Object)this.m_hostname);
            Requisition newReq = this.buildVMwareRequisition();
            this.logger.debug("Finished building new requisition for VMware management server {}", (Object)this.m_hostname);
            if (curReq == null) {
                if (newReq == null) {
                    newReq = new Requisition(this.m_foreignSource);
                }
            } else if (newReq == null) {
                newReq = curReq;
            } else {
                for (RequisitionNode newNode : newReq.getNodes()) {
                    for (RequisitionNode curNode : curReq.getNodes()) {
                        if (!newNode.getForeignId().equals(curNode.getForeignId())) continue;
                        for (RequisitionAsset asset : curNode.getAssets()) {
                            if (asset.getName().startsWith("vmware")) continue;
                            newNode.putAsset(asset);
                        }
                        for (RequisitionCategory cat : curNode.getCategories()) {
                            if (cat.getName().startsWith("VMWare")) continue;
                            newNode.putCategory(cat);
                        }
                        for (RequisitionInterface intf : curNode.getInterfaces()) {
                            RequisitionInterface newIntf;
                            List<RequisitionMonitoredService> services = this.getManualyConfiguredServices(intf);
                            if (services.isEmpty() || (newIntf = this.getRequisitionInterface(newNode, intf.getIpAddr())) == null) continue;
                            newIntf.getMonitoredServices().addAll(services);
                        }
                    }
                }
            }
            stream = new ByteArrayInputStream(this.jaxBMarshal(newReq).getBytes());
        }
        catch (Throwable e) {
            this.logger.warn("Problem getting input stream: '{}'", e);
            throw new IOExceptionWithCause("Problem getting input stream: " + e, e);
        }
        return stream;
    }

    protected Requisition getExistingRequisition() {
        Requisition curReq = null;
        try {
            ForeignSourceRepository repository = (ForeignSourceRepository)BeanUtils.getBean((String)"daoContext", (String)"deployedForeignSourceRepository", ForeignSourceRepository.class);
            if (repository != null) {
                curReq = repository.getRequisition(this.m_foreignSource);
            }
        }
        catch (Exception e) {
            this.logger.warn("Can't retrieve requisition {}", (Object)this.m_foreignSource);
        }
        return curReq;
    }

    private RequisitionInterface getRequisitionInterface(RequisitionNode node, String ipAddr) {
        for (RequisitionInterface intf : node.getInterfaces()) {
            if (!ipAddr.equals(intf.getIpAddr())) continue;
            return intf;
        }
        return null;
    }

    private List<RequisitionMonitoredService> getManualyConfiguredServices(RequisitionInterface intf) {
        ArrayList<RequisitionMonitoredService> services = new ArrayList<RequisitionMonitoredService>();
        for (RequisitionMonitoredService svc : intf.getMonitoredServices()) {
            boolean found = false;
            for (String svcName : this.m_hostSystemServices) {
                if (!svcName.trim().equals(svc.getServiceName())) continue;
                found = true;
            }
            for (String svcName : this.m_virtualMachineServices) {
                if (!svcName.trim().equals(svc.getServiceName())) continue;
                found = true;
            }
            if (found) continue;
            services.add(svc);
        }
        return services;
    }

    private String jaxBMarshal(Requisition r) throws JAXBException {
        return JaxbUtils.marshal((Object)r);
    }
}

