/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.vmware.vijava;

import java.io.File;
import org.opennms.netmgt.collectd.vmware.vijava.VmwareCollectionResource;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareMultiInstanceCollectionResource
extends VmwareCollectionResource {
    private final Logger logger = LoggerFactory.getLogger((String)("OpenNMS.VMware." + VmwareMultiInstanceCollectionResource.class.getName()));
    private final String m_inst;
    private final String m_name;

    public VmwareMultiInstanceCollectionResource(CollectionAgent agent, String instance, String name) {
        super(agent);
        this.m_inst = instance;
        this.m_name = name;
    }

    public File getResourceDir(RrdRepository repository) {
        File rrdBaseDir = repository.getRrdBaseDir();
        File nodeDir = new File(rrdBaseDir, this.getParent());
        File typeDir = new File(nodeDir, this.m_name);
        File instDir = new File(typeDir, this.m_inst.replaceAll("/", "_").replaceAll("\\s+", "_").replaceAll(":", "_").replaceAll("\\\\", "_").replaceAll("[\\[\\]]", "_"));
        this.logger.debug("getResourceDir: '{}'", (Object)instDir);
        return instDir;
    }

    @Override
    public String getResourceTypeName() {
        return this.m_name;
    }

    @Override
    public String getInstance() {
        return this.m_inst;
    }

    public String toString() {
        return "Node[" + this.m_agent.getNodeId() + "]/type[" + this.m_name + "]/instance[" + this.m_inst + "]";
    }
}

