/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.vmware.vim25.HostRuntimeInfo;
import com.vmware.vim25.HostSystemPowerState;
import com.vmware.vim25.mo.HostSystem;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.opennms.protocols.vmware.VmwareViJavaAccess;
import org.sblim.wbem.cim.CIMObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareCimMonitor
extends AbstractServiceMonitor {
    private final Logger logger = LoggerFactory.getLogger((String)("OpenNMS.VMware." + VmwareCimMonitor.class.getName()));
    private NodeDao m_nodeDao = null;
    private static HashMap<Integer, String> m_healthStates = new HashMap();
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    public void initialize(Map<String, Object> parameters) {
        this.m_nodeDao = (NodeDao)BeanUtils.getBean((String)"daoContext", (String)"nodeDao", NodeDao.class);
        if (this.m_nodeDao == null) {
            this.logger.error("Node dao should be a non-null value.");
        }
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        OnmsNode onmsNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(svc.getNodeId()));
        String vmwareManagementServer = onmsNode.getAssetRecord().getVmwareManagementServer();
        String vmwareManagedObjectId = onmsNode.getForeignId();
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        PollStatus serviceStatus = PollStatus.unknown();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            VmwareViJavaAccess vmwareViJavaAccess = null;
            try {
                vmwareViJavaAccess = new VmwareViJavaAccess(vmwareManagementServer);
            }
            catch (MarshalException e) {
                this.logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)vmwareManagementServer, (Object)e.getMessage());
                return PollStatus.unavailable((String)("Error initialising VMware connection to '" + vmwareManagementServer + "'"));
            }
            catch (ValidationException e) {
                this.logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)vmwareManagementServer, (Object)e.getMessage());
                return PollStatus.unavailable((String)("Error initialising VMware connection to '" + vmwareManagementServer + "'"));
            }
            catch (IOException e) {
                this.logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)vmwareManagementServer, (Object)e.getMessage());
                return PollStatus.unavailable((String)("Error initialising VMware connection to '" + vmwareManagementServer + "'"));
            }
            try {
                vmwareViJavaAccess.connect();
            }
            catch (MalformedURLException e) {
                this.logger.warn("Error connecting VMware management server '{}': '{}' exception: {} cause: '{}'", new Object[]{vmwareManagementServer, e.getMessage(), e.getClass().getName(), e.getCause()});
                return PollStatus.unavailable((String)("Error connecting VMware management server '" + vmwareManagementServer + "'"));
            }
            catch (RemoteException e) {
                this.logger.warn("Error connecting VMware management server '{}': '{}' exception: {} cause: '{}'", new Object[]{vmwareManagementServer, e.getMessage(), e.getClass().getName(), e.getCause()});
                return PollStatus.unavailable((String)("Error connecting VMware management server '" + vmwareManagementServer + "'"));
            }
            if (!vmwareViJavaAccess.setTimeout(tracker.getConnectionTimeout())) {
                this.logger.warn("Error setting connection timeout for VMware management server '{}'", (Object)vmwareManagementServer);
            }
            HostSystem hostSystem = vmwareViJavaAccess.getHostSystemByManagedObjectId(vmwareManagedObjectId);
            String powerState = null;
            if (hostSystem == null) {
                return PollStatus.unknown((String)"hostSystem=null");
            }
            HostRuntimeInfo hostRuntimeInfo = hostSystem.getRuntime();
            if (hostRuntimeInfo == null) {
                return PollStatus.unknown((String)"hostRuntimeInfo=null");
            }
            HostSystemPowerState hostSystemPowerState = hostRuntimeInfo.getPowerState();
            if (hostSystemPowerState == null) {
                return PollStatus.unknown((String)"hostSystemPowerState=null");
            }
            powerState = hostSystemPowerState.toString();
            if ("poweredOn".equals(powerState)) {
                List<CIMObject> cimObjects = null;
                try {
                    cimObjects = vmwareViJavaAccess.queryCimObjects(hostSystem, "CIM_NumericSensor", svc.getIpAddr());
                }
                catch (Exception e) {
                    this.logger.warn("Error retrieving CIM values from host system '{}'", (Object)vmwareManagedObjectId, (Object)e.getMessage());
                    vmwareViJavaAccess.disconnect();
                    return PollStatus.unavailable((String)("Error retrieving cim values from host system '" + vmwareManagedObjectId + "'"));
                }
                boolean success = true;
                StringBuffer reason = new StringBuffer("VMware CIM query returned: ");
                for (CIMObject cimObject : cimObjects) {
                    int healthStateInt;
                    String healthState = vmwareViJavaAccess.getPropertyOfCimObject(cimObject, "HealthState");
                    String cimObjectName = vmwareViJavaAccess.getPropertyOfCimObject(cimObject, "Name");
                    if (healthState == null || (healthStateInt = Integer.valueOf(healthState).intValue()) == 5) continue;
                    if (!success) {
                        reason.append(", ");
                    }
                    success = false;
                    reason.append(cimObjectName + " ");
                    if (m_healthStates.containsKey(healthStateInt)) {
                        reason.append("(" + m_healthStates.get(healthStateInt) + ")");
                        continue;
                    }
                    reason.append("(" + healthStateInt + ")");
                }
                serviceStatus = success ? PollStatus.available() : PollStatus.unavailable((String)reason.toString());
            } else {
                serviceStatus = PollStatus.unresponsive((String)("Host system's power state is '" + powerState + "'"));
            }
            vmwareViJavaAccess.disconnect();
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    static {
        m_healthStates.put(0, "Unknown");
        m_healthStates.put(5, "OK");
        m_healthStates.put(10, "Degraded/Warning");
        m_healthStates.put(15, "Minor failure");
        m_healthStates.put(20, "Major failure");
        m_healthStates.put(25, "Critical failure");
        m_healthStates.put(30, "Non-recoverable error");
    }
}

