/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.vmware.vim25.HostRuntimeInfo;
import com.vmware.vim25.HostSystemPowerState;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.VirtualMachine;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.opennms.protocols.vmware.VmwareViJavaAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareMonitor
extends AbstractServiceMonitor {
    private final Logger logger = LoggerFactory.getLogger((String)("OpenNMS.VMware." + VmwareMonitor.class.getName()));
    private NodeDao m_nodeDao = null;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    public void initialize(Map<String, Object> parameters) {
        this.m_nodeDao = (NodeDao)BeanUtils.getBean((String)"daoContext", (String)"nodeDao", NodeDao.class);
        if (this.m_nodeDao == null) {
            this.logger.error("Node dao should be a non-null value.");
        }
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        OnmsNode onmsNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(svc.getNodeId()));
        String vmwareManagementServer = onmsNode.getAssetRecord().getVmwareManagementServer();
        String vmwareManagedEntityType = onmsNode.getAssetRecord().getVmwareManagedEntityType();
        String vmwareManagedObjectId = onmsNode.getForeignId();
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        PollStatus serviceStatus = PollStatus.unknown();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            VmwareViJavaAccess vmwareViJavaAccess = null;
            try {
                vmwareViJavaAccess = new VmwareViJavaAccess(vmwareManagementServer);
            }
            catch (MarshalException e) {
                this.logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)vmwareManagementServer, (Object)e.getMessage());
                return PollStatus.unavailable((String)("Error initialising VMware connection to '" + vmwareManagementServer + "'"));
            }
            catch (ValidationException e) {
                this.logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)vmwareManagementServer, (Object)e.getMessage());
                return PollStatus.unavailable((String)("Error initialising VMware connection to '" + vmwareManagementServer + "'"));
            }
            catch (IOException e) {
                this.logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)vmwareManagementServer, (Object)e.getMessage());
                return PollStatus.unavailable((String)("Error initialising VMware connection to '" + vmwareManagementServer + "'"));
            }
            try {
                vmwareViJavaAccess.connect();
            }
            catch (MalformedURLException e) {
                this.logger.warn("Error connecting VMware management server '{}': '{}' exception: {} cause: '{}'", new Object[]{vmwareManagementServer, e.getMessage(), e.getClass().getName(), e.getCause()});
                return PollStatus.unavailable((String)("Error connecting VMware management server '" + vmwareManagementServer + "'"));
            }
            catch (RemoteException e) {
                this.logger.warn("Error connecting VMware management server '{}': '{}' exception: {} cause: '{}'", new Object[]{vmwareManagementServer, e.getMessage(), e.getClass().getName(), e.getCause()});
                return PollStatus.unavailable((String)("Error connecting VMware management server '" + vmwareManagementServer + "'"));
            }
            if (!vmwareViJavaAccess.setTimeout(tracker.getConnectionTimeout())) {
                this.logger.warn("Error setting connection timeout for VMware management server '{}'", (Object)vmwareManagementServer);
            }
            String powerState = "unknown";
            if ("HostSystem".equals(vmwareManagedEntityType)) {
                HostSystem hostSystem = vmwareViJavaAccess.getHostSystemByManagedObjectId(vmwareManagedObjectId);
                if (hostSystem == null) {
                    return PollStatus.unknown((String)"hostSystem=null");
                }
                HostRuntimeInfo hostRuntimeInfo = hostSystem.getRuntime();
                if (hostRuntimeInfo == null) {
                    return PollStatus.unknown((String)"hostRuntimeInfo=null");
                }
                HostSystemPowerState hostSystemPowerState = hostRuntimeInfo.getPowerState();
                if (hostSystemPowerState == null) {
                    return PollStatus.unknown((String)"hostSystemPowerState=null");
                }
                powerState = hostSystemPowerState.toString();
            } else if ("VirtualMachine".equals(vmwareManagedEntityType)) {
                VirtualMachine virtualMachine = vmwareViJavaAccess.getVirtualMachineByManagedObjectId(vmwareManagedObjectId);
                if (virtualMachine == null) {
                    return PollStatus.unknown((String)"virtualMachine=null");
                }
                VirtualMachineRuntimeInfo virtualMachineRuntimeInfo = virtualMachine.getRuntime();
                if (virtualMachineRuntimeInfo == null) {
                    return PollStatus.unknown((String)"virtualMachineRuntimeInfo=null");
                }
                VirtualMachinePowerState virtualMachinePowerState = virtualMachineRuntimeInfo.getPowerState();
                if (virtualMachinePowerState == null) {
                    return PollStatus.unknown((String)"virtualMachinePowerState=null");
                }
                powerState = virtualMachinePowerState.toString();
            } else {
                this.logger.warn("Error getting '{}' for '{}'", (Object)vmwareManagedEntityType, (Object)vmwareManagedObjectId);
                vmwareViJavaAccess.disconnect();
                return serviceStatus;
            }
            serviceStatus = "poweredOn".equals(powerState) ? PollStatus.available() : PollStatus.unavailable((String)("The system's state is '" + powerState + "'"));
            vmwareViJavaAccess.disconnect();
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }
}

