/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.vmware;

import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.opennms.protocols.vmware.VmwareViJavaAccess;
import org.sblim.wbem.cim.CIMObject;

public class VmwareCimQuery {
    public static HashMap<Integer, String> m_healthStates = new HashMap();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void cimQuery(String hostname, String username, String password) {
        ManagedEntity[] hostSystems;
        System.out.print("Trying to connect to " + hostname + "... ");
        VmwareViJavaAccess vmwareViJavaAccess = new VmwareViJavaAccess(hostname, username, password);
        try {
            vmwareViJavaAccess.connect();
        }
        catch (MalformedURLException e) {
            System.out.println("Exception:");
            e.printStackTrace();
            return;
        }
        catch (RemoteException e) {
            System.out.println("Exception:");
            e.printStackTrace();
            return;
        }
        System.out.println("Success!");
        System.out.print(" Querying " + hostname + " for host systems... ");
        try {
            hostSystems = vmwareViJavaAccess.searchManagedEntities("HostSystem");
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            vmwareViJavaAccess.disconnect();
            return;
        }
        if (hostSystems != null) {
            System.out.println(hostSystems.length + " host system(s) found!");
            for (ManagedEntity managedEntity : hostSystems) {
                String ipAddress;
                HostSystem hostSystem;
                block19: {
                    hostSystem = (HostSystem)managedEntity;
                    if (hostSystem.getSummary() != null) {
                        if (hostSystem.getSummary().getRuntime() != null) {
                            String powerState = hostSystem.getSummary().getRuntime().getPowerState().toString();
                            if (!"poweredOn".equals(powerState)) {
                                System.out.println("  Ignoring host system " + hostSystem.getName() + " (powerState=" + powerState + ")... ");
                                continue;
                            }
                            System.out.print("  Determining primary Ip address of host system " + hostSystem.getName() + " (powerState=" + powerState + ")... ");
                            try {
                                ipAddress = vmwareViJavaAccess.getPrimaryHostSystemIpAddress(hostSystem);
                                break block19;
                            }
                            catch (RemoteException remoteException) {
                                System.out.println("Exception:");
                                remoteException.printStackTrace();
                                continue;
                            }
                        }
                        System.out.println("  Ignoring host system " + hostSystem.getName() + " (powerState=unknown)... ");
                        continue;
                    }
                    System.out.println("  Ignoring host system " + hostSystem.getName() + " (powerState=unknown)... ");
                    continue;
                }
                if (ipAddress != null) {
                    List<CIMObject> cimObjects;
                    System.out.print(ipAddress + "\n  Querying host system " + hostSystem.getName() + " for numeric sensors... ");
                    try {
                        cimObjects = vmwareViJavaAccess.queryCimObjects(hostSystem, "CIM_NumericSensor");
                    }
                    catch (RemoteException remoteException) {
                        System.out.println("Exception:");
                        remoteException.printStackTrace();
                        continue;
                    }
                    if (cimObjects != null) {
                        System.out.println(cimObjects.size() + " sensor(s) found!");
                        for (CIMObject cimObject : cimObjects) {
                            String healthState = vmwareViJavaAccess.getPropertyOfCimObject(cimObject, "HealthState");
                            String cimObjectName = vmwareViJavaAccess.getPropertyOfCimObject(cimObject, "Name");
                            System.out.print("   " + cimObjectName);
                            if (healthState != null) {
                                System.out.println(" " + m_healthStates.get(Integer.valueOf(healthState)));
                                continue;
                            }
                            System.out.println();
                        }
                        continue;
                    }
                    System.out.println("NULL - aborting...");
                    continue;
                }
                System.out.println("NULL - aborting...");
            }
        } else {
            System.out.println("NULL - aborting...");
        }
        System.out.println("Cleaning up...");
        vmwareViJavaAccess.disconnect();
    }

    private static void usage(Options options, CommandLine cmd, String error, Exception e) {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter pw = new PrintWriter(System.out);
        if (error != null) {
            pw.println("An error occurred: " + error + "\n");
        }
        formatter.printHelp("Usage: VmwareCimQuery <hostname> <username> <password>", options);
        if (e != null) {
            pw.println(e.getMessage());
            e.printStackTrace(pw);
        }
        pw.close();
    }

    private static void usage(Options options, CommandLine cmd) {
        VmwareCimQuery.usage(options, cmd, null, null);
    }

    public static void main(String[] args) throws ParseException {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        CommandLine cmd = parser.parse(options, args);
        List arguments = cmd.getArgList();
        if (arguments.size() < 3) {
            VmwareCimQuery.usage(options, cmd);
            System.exit(1);
        }
        String hostname = (String)arguments.remove(0);
        String username = (String)arguments.remove(0);
        String password = (String)arguments.remove(0);
        VmwareCimQuery.cimQuery(hostname, username, password);
    }

    static {
        m_healthStates.put(0, "Unknown");
        m_healthStates.put(5, "OK");
        m_healthStates.put(10, "Degraded/Warning");
        m_healthStates.put(15, "Minor failure");
        m_healthStates.put(20, "Major failure");
        m_healthStates.put(25, "Critical failure");
        m_healthStates.put(30, "Non-recoverable error");
    }
}

