/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.vmware;

import com.vmware.vim25.CustomFieldDef;
import com.vmware.vim25.CustomFieldStringValue;
import com.vmware.vim25.CustomFieldValue;
import com.vmware.vim25.GuestNicInfo;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.VirtualMachine;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOExceptionWithCause;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.url.GenericURLConnection;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAsset;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.protocols.vmware.VmwareViJavaAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareRequisitionUrlConnection
extends GenericURLConnection {
    private Logger logger = LoggerFactory.getLogger(VmwareRequisitionUrlConnection.class);
    private static final String VMWARE_HOSTSYSTEM_SERVICES = "hostSystemServices";
    private static final String VMWARE_VIRTUALMACHINE_SERVICES = "virtualMachineServices";
    private String[] m_hostSystemServices;
    private String[] m_virtualMachineServices;
    private String m_hostname = null;
    private String m_username = null;
    private String m_password = null;
    private String m_foreignSource = null;
    private boolean m_importVMPoweredOn = true;
    private boolean m_importVMPoweredOff = false;
    private boolean m_importVMSuspended = false;
    private boolean m_importHostPoweredOn = true;
    private boolean m_importHostPoweredOff = false;
    private boolean m_importHostStandBy = false;
    private boolean m_importHostUnknown = false;
    private Map<String, String> m_hostSystemMap = new HashMap<String, String>();
    private Map<String, String> m_args = null;
    private Requisition m_requisition = null;

    public VmwareRequisitionUrlConnection(URL url) throws MalformedURLException, RemoteException {
        super(url);
        this.m_hostname = url.getHost();
        this.m_username = this.getUsername();
        this.m_password = this.getPassword();
        this.m_args = this.getQueryArgs();
        this.m_importVMPoweredOn = this.queryParameter("importVMPoweredOn", true);
        this.m_importVMPoweredOff = this.queryParameter("importVMPoweredOff", false);
        this.m_importVMSuspended = this.queryParameter("importVMSuspended", false);
        this.m_importHostPoweredOn = this.queryParameter("importHostPoweredOn", true);
        this.m_importHostPoweredOff = this.queryParameter("importHostPoweredOff", false);
        this.m_importHostStandBy = this.queryParameter("importHostStandBy", false);
        this.m_importHostUnknown = this.queryParameter("importHostUnknown", false);
        if (this.queryParameter("importHostAll", false)) {
            this.m_importHostPoweredOn = true;
            this.m_importHostPoweredOff = true;
            this.m_importHostStandBy = true;
            this.m_importHostUnknown = true;
        }
        if (this.queryParameter("importVMAll", false)) {
            this.m_importVMPoweredOff = true;
            this.m_importVMPoweredOn = true;
            this.m_importVMSuspended = true;
        }
        String path = url.getPath();
        path = path.replaceAll("^/", "");
        String[] pathElements = (path = path.replaceAll("/$", "")).split("/");
        if (pathElements.length == 1) {
            this.m_foreignSource = "".equals(pathElements[0]) ? "vmware-" + this.m_hostname : pathElements[0];
        } else {
            throw new MalformedURLException("Error processing path element of URL (vmware://username:password@host[/foreign-source]?keyA=valueA;keyB=valueB;...)");
        }
    }

    private String[] getHostSystemServices(int apiVersion) {
        String[] hostSystemsServices = new String[]{"VMware-ManagedEntity", "VMware" + apiVersion + "-HostSystem", "VMwareCim-HostSystem"};
        if (this.m_args != null && this.m_args.get(VMWARE_HOSTSYSTEM_SERVICES) != null) {
            hostSystemsServices = this.m_args.get(VMWARE_HOSTSYSTEM_SERVICES).split(",");
        }
        return hostSystemsServices;
    }

    private String[] getVirtualMachineServices(int apiVersion) {
        String[] virtualMachineServices = new String[]{"VMware-ManagedEntity", "VMware" + apiVersion + "-VirtualMachine"};
        if (this.m_args != null && this.m_args.get(VMWARE_VIRTUALMACHINE_SERVICES) != null) {
            virtualMachineServices = this.m_args.get(VMWARE_VIRTUALMACHINE_SERVICES).split(",");
        }
        return virtualMachineServices;
    }

    private boolean queryParameter(String key, boolean defaultValue) {
        if (this.m_args.get(key) == null) {
            return defaultValue;
        }
        String value = this.m_args.get(key).toLowerCase();
        return "yes".equals(value) || "true".equals(value) || "on".equals(value) || "1".equals(value);
    }

    public void connect() throws IOException {
    }

    private RequisitionNode createRequisitionNode(Set<String> ipAddresses, ManagedEntity managedEntity, int apiVersion) {
        RequisitionNode requisitionNode = new RequisitionNode();
        requisitionNode.setNodeLabel(managedEntity.getName());
        requisitionNode.setForeignId(managedEntity.getMOR().getVal());
        boolean primary = true;
        for (String ipAddress : ipAddresses) {
            try {
                InetAddress inetAddress = InetAddress.getByName(ipAddress);
                if (inetAddress.isLoopbackAddress()) continue;
                RequisitionInterface requisitionInterface = new RequisitionInterface();
                requisitionInterface.setIpAddr(ipAddress);
                if (primary) {
                    requisitionInterface.setSnmpPrimary(PrimaryType.PRIMARY);
                    if (managedEntity instanceof HostSystem) {
                        for (String string : this.m_hostSystemServices) {
                            requisitionInterface.insertMonitoredService(new RequisitionMonitoredService(string.trim()));
                        }
                    } else if (managedEntity instanceof VirtualMachine) {
                        for (String string : this.m_virtualMachineServices) {
                            requisitionInterface.insertMonitoredService(new RequisitionMonitoredService(string.trim()));
                        }
                    } else {
                        this.logger.error("Undefined type of managedEntity '{}'", (Object)managedEntity.getMOR().getType());
                        return null;
                    }
                    primary = false;
                } else {
                    requisitionInterface.setSnmpPrimary(PrimaryType.SECONDARY);
                }
                requisitionInterface.setManaged(Boolean.TRUE);
                requisitionInterface.setStatus(Integer.valueOf(1));
                requisitionNode.putInterface(requisitionInterface);
            }
            catch (UnknownHostException unknownHostException) {
                this.logger.warn("Invalid IP address '{}'", (Object)unknownHostException.getMessage());
            }
        }
        String vmState = "unknown";
        StringBuffer vmwareTopologyInfo = new StringBuffer();
        ManagedEntity parentEntity = managedEntity.getParent();
        do {
            if (vmwareTopologyInfo.length() > 0) {
                vmwareTopologyInfo.append(", ");
            }
            try {
                vmwareTopologyInfo.append(parentEntity.getMOR().getVal() + "/" + URLEncoder.encode(parentEntity.getName(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
            }
        } while ((parentEntity = parentEntity.getParent()) != null);
        if (managedEntity instanceof HostSystem) {
            HostSystem hostSystem = (HostSystem)managedEntity;
            vmState = hostSystem.getSummary().getRuntime().getPowerState().toString();
            try {
                for (String string : hostSystem.getDatastores()) {
                    if (vmwareTopologyInfo.length() > 0) {
                        vmwareTopologyInfo.append(", ");
                    }
                    try {
                        vmwareTopologyInfo.append(string.getMOR().getVal() + "/" + URLEncoder.encode(string.getSummary().getName(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
                    }
                }
            }
            catch (RemoteException e) {
                this.logger.warn("Cannot retrieve datastores for managedEntity '{}': '{}'", (Object)managedEntity.getMOR().getVal(), (Object)e.getMessage());
            }
            try {
                for (String string : hostSystem.getNetworks()) {
                    if (vmwareTopologyInfo.length() > 0) {
                        vmwareTopologyInfo.append(", ");
                    }
                    try {
                        vmwareTopologyInfo.append(string.getMOR().getVal() + "/" + URLEncoder.encode(string.getSummary().getName(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
                    }
                }
            }
            catch (RemoteException e) {
                this.logger.warn("Cannot retrieve networks for managedEntity '{}': '{}'", (Object)managedEntity.getMOR().getVal(), (Object)e.getMessage());
            }
        } else if (managedEntity instanceof VirtualMachine) {
            VirtualMachine virtualMachine = (VirtualMachine)managedEntity;
            vmState = virtualMachine.getSummary().getRuntime().getPowerState().toString();
            try {
                for (String string : virtualMachine.getDatastores()) {
                    if (vmwareTopologyInfo.length() > 0) {
                        vmwareTopologyInfo.append(", ");
                    }
                    try {
                        vmwareTopologyInfo.append(string.getMOR().getVal() + "/" + URLEncoder.encode(string.getSummary().getName(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
                    }
                }
            }
            catch (RemoteException e) {
                this.logger.warn("Cannot retrieve datastores for managedEntity '{}': '{}'", (Object)managedEntity.getMOR().getVal(), (Object)e.getMessage());
            }
            try {
                for (String string : virtualMachine.getNetworks()) {
                    if (vmwareTopologyInfo.length() > 0) {
                        vmwareTopologyInfo.append(", ");
                    }
                    try {
                        vmwareTopologyInfo.append(string.getMOR().getVal() + "/" + URLEncoder.encode(string.getSummary().getName(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
                    }
                }
            }
            catch (RemoteException e) {
                this.logger.warn("Cannot retrieve networks for managedEntity '{}': '{}'", (Object)managedEntity.getMOR().getVal(), (Object)e.getMessage());
            }
            if (vmwareTopologyInfo.length() > 0) {
                vmwareTopologyInfo.append(", ");
            }
            try {
                vmwareTopologyInfo.append(virtualMachine.getRuntime().getHost().getVal() + "/" + URLEncoder.encode(this.m_hostSystemMap.get(virtualMachine.getRuntime().getHost().getVal()), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.warn("Unsupported encoding '{}'", (Object)e.getMessage());
            }
        } else {
            this.logger.error("Undefined type of managedEntity '{}'", (Object)managedEntity.getMOR().getType());
            return null;
        }
        RequisitionAsset requisitionAssetHostname = new RequisitionAsset("vmwareManagementServer", this.m_hostname);
        requisitionNode.putAsset(requisitionAssetHostname);
        RequisitionAsset requisitionAssetType = new RequisitionAsset("vmwareManagedEntityType", managedEntity instanceof HostSystem ? "HostSystem" : "VirtualMachine");
        requisitionNode.putAsset(requisitionAssetType);
        RequisitionAsset requisitionAssetId = new RequisitionAsset("vmwareManagedObjectId", managedEntity.getMOR().getVal());
        requisitionNode.putAsset(requisitionAssetId);
        RequisitionAsset requisitionAssetTopologyInfo = new RequisitionAsset("vmwareTopologyInfo", vmwareTopologyInfo.toString());
        requisitionNode.putAsset(requisitionAssetTopologyInfo);
        RequisitionAsset requisitionAsset = new RequisitionAsset("vmwareState", vmState);
        requisitionNode.putAsset(requisitionAsset);
        requisitionNode.putCategory(new RequisitionCategory("VMware" + apiVersion));
        return requisitionNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Requisition buildVMwareRequisition() {
        VmwareViJavaAccess vmwareViJavaAccess = null;
        this.m_requisition = new Requisition(this.m_foreignSource);
        if (this.m_username == null || "".equals(this.m_username) || this.m_password == null || "".equals(this.m_password)) {
            try {
                vmwareViJavaAccess = new VmwareViJavaAccess(this.m_hostname);
            }
            catch (MarshalException e) {
                this.logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)this.m_hostname, (Object)e.getMessage());
                return this.m_requisition;
            }
            catch (ValidationException e) {
                this.logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)this.m_hostname, (Object)e.getMessage());
                return this.m_requisition;
            }
            catch (IOException e) {
                this.logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)this.m_hostname, (Object)e.getMessage());
                return this.m_requisition;
            }
        } else {
            vmwareViJavaAccess = new VmwareViJavaAccess(this.m_hostname, this.m_username, this.m_password);
        }
        try {
            vmwareViJavaAccess.connect();
        }
        catch (MalformedURLException e) {
            this.logger.warn("Error connecting VMware management server '{}': '{}'", (Object)this.m_hostname, (Object)e.getMessage());
            return this.m_requisition;
        }
        catch (RemoteException e) {
            this.logger.warn("Error connecting VMware management server '{}': '{}'", (Object)this.m_hostname, (Object)e.getMessage());
            return this.m_requisition;
        }
        try {
            int apiVersion = vmwareViJavaAccess.getMajorApiVersion();
            this.m_hostSystemServices = this.m_args != null && this.m_args.get(VMWARE_HOSTSYSTEM_SERVICES) != null ? this.m_args.get(VMWARE_HOSTSYSTEM_SERVICES).split(",") : new String[]{"VMware-ManagedEntity", "VMware-HostSystem", "VMwareCim-HostSystem"};
            this.m_virtualMachineServices = this.m_args != null && this.m_args.get(VMWARE_VIRTUALMACHINE_SERVICES) != null ? this.m_args.get(VMWARE_VIRTUALMACHINE_SERVICES).split(",") : new String[]{"VMware-ManagedEntity", "VMware-VirtualMachine"};
            this.iterateHostSystems(vmwareViJavaAccess, apiVersion);
            this.iterateVirtualMachines(vmwareViJavaAccess, apiVersion);
        }
        catch (RemoteException e) {
            this.logger.warn("Error retrieving managed objects from VMware management server '{}': '{}'", (Object)this.m_hostname, (Object)e.getMessage());
            Requisition requisition = this.m_requisition;
            return requisition;
        }
        finally {
            vmwareViJavaAccess.disconnect();
        }
        return this.m_requisition;
    }

    private boolean checkHostPowerState(HostSystem hostSystem) {
        String powerState = hostSystem.getSummary().runtime.getPowerState().toString();
        if ("poweredOn".equals(powerState) && this.m_importHostPoweredOn) {
            return true;
        }
        if ("poweredOff".equals(powerState) && this.m_importHostPoweredOff) {
            return true;
        }
        if ("standBy".equals(powerState) && this.m_importHostStandBy) {
            return true;
        }
        return "unknown".equals(powerState) && this.m_importHostUnknown;
    }

    private boolean checkVMPowerState(VirtualMachine virtualMachine) {
        String powerState = virtualMachine.getSummary().runtime.getPowerState().toString();
        if ("poweredOn".equals(powerState) && this.m_importVMPoweredOn) {
            return true;
        }
        if ("poweredOff".equals(powerState) && this.m_importVMPoweredOff) {
            return true;
        }
        return "suspended".equals(powerState) && this.m_importVMSuspended;
    }

    private void iterateHostSystems(VmwareViJavaAccess vmwareViJavaAccess, int apiVersion) throws RemoteException {
        ManagedEntity[] hostSystems = vmwareViJavaAccess.searchManagedEntities("HostSystem");
        if (hostSystems != null) {
            for (ManagedEntity managedEntity : hostSystems) {
                HostSystem hostSystem = (HostSystem)managedEntity;
                this.m_hostSystemMap.put(hostSystem.getMOR().getVal(), hostSystem.getName());
                if (!this.checkHostPowerState(hostSystem) || !this.checkForAttribute((ManagedEntity)hostSystem)) continue;
                this.logger.debug("Adding Host System '{}'", (Object)hostSystem.getName());
                TreeSet<String> ipAddresses = vmwareViJavaAccess.getHostSystemIpAddresses(hostSystem);
                RequisitionNode node = this.createRequisitionNode(ipAddresses, (ManagedEntity)hostSystem, apiVersion);
                if (node == null) continue;
                this.m_requisition.insertNode(node);
            }
        }
    }

    private void iterateVirtualMachines(VmwareViJavaAccess vmwareViJavaAccess, int apiVersion) throws RemoteException {
        ManagedEntity[] virtualMachines = vmwareViJavaAccess.searchManagedEntities("VirtualMachine");
        if (virtualMachines != null) {
            for (ManagedEntity managedEntity : virtualMachines) {
                VirtualMachine virtualMachine = (VirtualMachine)managedEntity;
                if (!this.checkVMPowerState(virtualMachine) || !this.checkForAttribute((ManagedEntity)virtualMachine)) continue;
                this.logger.debug("Adding Virtual Machine '{}'", (Object)virtualMachine.getName());
                LinkedHashSet<String> ipAddresses = new LinkedHashSet<String>();
                ipAddresses.add(virtualMachine.getGuest().getIpAddress());
                if (virtualMachine.getGuest().getNet() != null) {
                    for (GuestNicInfo guestNicInfo : virtualMachine.getGuest().getNet()) {
                        if (guestNicInfo.getIpAddress() == null) continue;
                        for (String ipAddress : guestNicInfo.getIpAddress()) {
                            ipAddresses.add(ipAddress);
                        }
                    }
                }
                RequisitionNode node = this.createRequisitionNode(ipAddresses, (ManagedEntity)virtualMachine, apiVersion);
                if (virtualMachine.getGuest().getGuestFullName() != null) {
                    RequisitionAsset requisitionAsset = new RequisitionAsset("operatingSystem", virtualMachine.getGuest().getGuestFullName());
                    node.putAsset(requisitionAsset);
                }
                if (node == null) continue;
                this.m_requisition.insertNode(node);
            }
        }
    }

    private boolean checkForAttribute(ManagedEntity managedEntity) throws RemoteException {
        String key = this.m_args.get("key");
        String value = this.m_args.get("value");
        if (key == null && value == null) {
            return true;
        }
        if (key == null || value == null) {
            return false;
        }
        CustomFieldValue[] values = managedEntity.getCustomValue();
        CustomFieldDef[] defs = managedEntity.getAvailableField();
        for (int i = 0; defs != null && i < defs.length; ++i) {
            if (!key.equals(defs[i].getName())) continue;
            int targetIndex = defs[i].getKey();
            for (int j = 0; j < values.length; ++j) {
                if (targetIndex != values[j].getKey()) continue;
                return value.equals(((CustomFieldStringValue)values[j]).value);
            }
        }
        return false;
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayInputStream stream = null;
        try {
            Requisition r = this.buildVMwareRequisition();
            stream = new ByteArrayInputStream(this.jaxBMarshal(r).getBytes());
        }
        catch (Throwable e) {
            this.logger.warn("Problem getting input stream: '{}'", e);
            throw new IOExceptionWithCause("Problem getting input stream: " + e, e);
        }
        return stream;
    }

    private String jaxBMarshal(Requisition r) throws JAXBException {
        return JaxbUtils.marshal((Object)r);
    }
}

