/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.vmware.vijava;

import org.opennms.netmgt.collectd.AbstractCollectionAttribute;
import org.opennms.netmgt.collectd.vmware.vijava.VmwareCollectionResource;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionAttributeType;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.ServiceParameters;

public class VmwareCollectionAttribute
extends AbstractCollectionAttribute
implements CollectionAttribute {
    private String m_alias;
    private String m_value;
    private VmwareCollectionResource m_resource;
    private CollectionAttributeType m_attribType;

    public VmwareCollectionAttribute(VmwareCollectionResource resource, CollectionAttributeType attribType, String alias, String value) {
        this.m_resource = resource;
        this.m_attribType = attribType;
        this.m_alias = alias;
        this.m_value = value;
    }

    @Override
    public CollectionAttributeType getAttributeType() {
        return this.m_attribType;
    }

    @Override
    public String getName() {
        return this.m_alias;
    }

    public String getMetricIdentifier() {
        return "Vmware_" + this.m_attribType.getName();
    }

    @Override
    public String getNumericValue() {
        return this.m_value;
    }

    @Override
    public CollectionResource getResource() {
        return this.m_resource;
    }

    @Override
    public String getStringValue() {
        return this.m_value;
    }

    @Override
    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    public String getType() {
        return this.m_attribType.getType();
    }

    public String toString() {
        return "VmwareCollectionAttribute " + this.m_alias + "=" + this.m_value;
    }
}

