/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import com.vmware.vim25.mo.HostSystem;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionException;
import org.opennms.netmgt.collectd.CollectionInitializationException;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.collectd.vmware.cim.VmwareCimCollectionAttributeType;
import org.opennms.netmgt.collectd.vmware.cim.VmwareCimCollectionSet;
import org.opennms.netmgt.collectd.vmware.cim.VmwareCimMultiInstanceCollectionResource;
import org.opennms.netmgt.config.collector.AttributeGroupType;
import org.opennms.netmgt.config.collector.CollectionSet;
import org.opennms.netmgt.config.vmware.cim.Attrib;
import org.opennms.netmgt.config.vmware.cim.VmwareCimCollection;
import org.opennms.netmgt.config.vmware.cim.VmwareCimGroup;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.VmwareCimDatacollectionConfigDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.protocols.vmware.VmwareViJavaAccess;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareCimCollector
implements ServiceCollector {
    private final Logger logger = LoggerFactory.getLogger((String)("OpenNMS.VMware." + VmwareCimCollector.class.getName()));
    private Map<String, AttributeGroupType> m_groupTypeList = new HashMap<String, AttributeGroupType>();
    private Map<String, VmwareCimCollectionAttributeType> m_attribTypeList = new HashMap<String, VmwareCimCollectionAttributeType>();
    private NodeDao m_nodeDao = null;
    VmwareCimDatacollectionConfigDao m_vmwareCimDatacollectionConfigDao;

    @Override
    public void initialize(Map<String, String> parameters) throws CollectionInitializationException {
        if (this.m_nodeDao == null) {
            this.m_nodeDao = (NodeDao)BeanUtils.getBean((String)"daoContext", (String)"nodeDao", NodeDao.class);
        }
        if (this.m_nodeDao == null) {
            this.logger.error("Node dao should be a non-null value.");
        }
        if (this.m_vmwareCimDatacollectionConfigDao == null) {
            this.m_vmwareCimDatacollectionConfigDao = (VmwareCimDatacollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"vmwareCimDatacollectionConfigDao", VmwareCimDatacollectionConfigDao.class);
        }
        if (this.m_nodeDao == null) {
            this.logger.error("vmwareCimDatacollectionConfigDao should be a non-null value.");
        }
        this.initDatabaseConnectionFactory();
        this.initializeRrdRepository();
    }

    private void initializeRrdRepository() {
        this.logger.debug("initializeRrdRepository: Initializing RRD repo from VmwareCimCollector...");
        this.initializeRrdDirs();
    }

    private void initializeRrdDirs() {
        File f = new File(this.m_vmwareCimDatacollectionConfigDao.getRrdPath());
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new RuntimeException("Unable to create RRD file repository.  Path doesn't already exist and could not make directory: " + this.m_vmwareCimDatacollectionConfigDao.getRrdPath());
        }
    }

    private void initDatabaseConnectionFactory() {
        try {
            DataSourceFactory.init();
        }
        catch (Exception e) {
            this.logger.error("initDatabaseConnectionFactory: Error initializing DataSourceFactory. Error message: '{}'", (Object)e.getMessage());
            throw new UndeclaredThrowableException(e);
        }
    }

    private void loadAttributeGroupList(VmwareCimCollection collection) {
        for (VmwareCimGroup vpm : collection.getVmwareCimGroup()) {
            AttributeGroupType attribGroupType1 = new AttributeGroupType(vpm.getName(), "all");
            this.m_groupTypeList.put(vpm.getName(), attribGroupType1);
        }
    }

    private void loadAttributeTypeList(VmwareCimCollection collection) {
        for (VmwareCimGroup vpm : collection.getVmwareCimGroup()) {
            for (Attrib attrib : vpm.getAttrib()) {
                AttributeGroupType attribGroupType = this.m_groupTypeList.get(vpm.getName());
                VmwareCimCollectionAttributeType attribType = new VmwareCimCollectionAttributeType(attrib, attribGroupType);
                this.m_attribTypeList.put(attrib.getName(), attribType);
            }
        }
    }

    @Override
    public void initialize(CollectionAgent agent, Map<String, Object> parameters) throws CollectionInitializationException {
        OnmsNode onmsNode = (OnmsNode)this.m_nodeDao.get(agent.getNodeId());
        String vmwareManagementServer = onmsNode.getAssetRecord().getVmwareManagementServer();
        String vmwareManagedEntityType = onmsNode.getAssetRecord().getVmwareManagedEntityType();
        String vmwareManagedObjectId = onmsNode.getForeignId();
        parameters.put("vmwareManagementServer", vmwareManagementServer);
        parameters.put("vmwareManagedEntityType", vmwareManagedEntityType);
        parameters.put("vmwareManagedObjectId", vmwareManagedObjectId);
    }

    @Override
    public void release() {
    }

    @Override
    public void release(CollectionAgent agent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> parameters) throws CollectionException {
        String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", (String)ParameterMap.getKeyedString(parameters, (String)"vmware-collection", null));
        VmwareCimCollection collection = this.m_vmwareCimDatacollectionConfigDao.getVmwareCimCollection(collectionName);
        String vmwareManagementServer = (String)parameters.get("vmwareManagementServer");
        String vmwareManagedObjectId = (String)parameters.get("vmwareManagedObjectId");
        if (vmwareManagementServer == null || vmwareManagedObjectId == null) {
            return null;
        }
        if ("".equals(vmwareManagementServer) || "".equals(vmwareManagedObjectId)) {
            return null;
        }
        this.loadAttributeGroupList(collection);
        this.loadAttributeTypeList(collection);
        VmwareCimCollectionSet collectionSet = new VmwareCimCollectionSet(agent);
        collectionSet.setCollectionTimestamp(new Date());
        collectionSet.setStatus(2);
        VmwareViJavaAccess vmwareViJavaAccess = null;
        try {
            vmwareViJavaAccess = new VmwareViJavaAccess(vmwareManagementServer);
        }
        catch (MarshalException e) {
            this.logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)vmwareManagementServer, (Object)e.getMessage());
            return collectionSet;
        }
        catch (ValidationException e) {
            this.logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)vmwareManagementServer, (Object)e.getMessage());
            return collectionSet;
        }
        catch (IOException e) {
            this.logger.warn("Error initialising VMware connection to '{}': '{}'", (Object)vmwareManagementServer, (Object)e.getMessage());
            return collectionSet;
        }
        try {
            vmwareViJavaAccess.connect();
        }
        catch (MalformedURLException e) {
            this.logger.warn("Error connection VMware management server '{}': '{}'", (Object)vmwareManagementServer, (Object)e.getMessage());
            return collectionSet;
        }
        catch (RemoteException e) {
            this.logger.warn("Error connection VMware management server '{}': '{}'", (Object)vmwareManagementServer, (Object)e.getMessage());
            return collectionSet;
        }
        HostSystem hostSystem = vmwareViJavaAccess.getHostSystemByManagedObjectId(vmwareManagedObjectId);
        String powerState = hostSystem.getSummary().runtime.getPowerState().toString();
        this.logger.debug("The power state for host system '{}' is '{}'", (Object)vmwareManagedObjectId, (Object)powerState);
        if ("poweredOn".equals(powerState)) {
            HashMap<String, List<CIMObject>> cimObjects = new HashMap<String, List<CIMObject>>();
            for (VmwareCimGroup vmwareCimGroup : collection.getVmwareCimGroup()) {
                List<CIMObject> cimList;
                String cimClass = vmwareCimGroup.getCimClass();
                if (!cimObjects.containsKey(cimClass)) {
                    VmwareCimCollectionSet vmwareCimCollectionSet;
                    cimList = null;
                    try {
                        cimList = vmwareViJavaAccess.queryCimObjects(hostSystem, cimClass);
                    }
                    catch (RemoteException e) {
                        this.logger.warn("Error retrieving cim values from host system '{}'. Error message: '{}'", (Object)vmwareManagedObjectId, (Object)e.getMessage());
                        vmwareCimCollectionSet = collectionSet;
                        return vmwareCimCollectionSet;
                    }
                    catch (CIMException e) {
                        this.logger.warn("Error retrieving CIM values from host system '{}'. Error message: '{}'", (Object)vmwareManagedObjectId, (Object)e.getMessage());
                        vmwareCimCollectionSet = collectionSet;
                        return vmwareCimCollectionSet;
                    }
                    finally {
                        vmwareViJavaAccess.disconnect();
                    }
                    cimObjects.put(cimClass, cimList);
                }
                if ((cimList = (List<CIMObject>)cimObjects.get(cimClass)) == null) {
                    this.logger.warn("Error getting objects of CIM class '{}' from host system '{}'", (Object)cimClass, (Object)vmwareManagedObjectId);
                    continue;
                }
                String keyAttribute = vmwareCimGroup.getKey();
                String attributeValue = vmwareCimGroup.getValue();
                String instanceAttribute = vmwareCimGroup.getInstance();
                for (CIMObject cimObject : cimList) {
                    String cimObjectValue;
                    boolean addObject = false;
                    addObject = keyAttribute != null && attributeValue != null ? attributeValue.equals(cimObjectValue = vmwareViJavaAccess.getPropertyOfCimObject(cimObject, keyAttribute)) : true;
                    if (!addObject) continue;
                    String instance = vmwareViJavaAccess.getPropertyOfCimObject(cimObject, instanceAttribute);
                    VmwareCimMultiInstanceCollectionResource vmwareCollectionResource = new VmwareCimMultiInstanceCollectionResource(agent, instance, vmwareCimGroup.getResourceType());
                    for (Attrib attrib : vmwareCimGroup.getAttrib()) {
                        VmwareCimCollectionAttributeType attribType = this.m_attribTypeList.get(attrib.getName());
                        vmwareCollectionResource.setAttributeValue(attribType, vmwareViJavaAccess.getPropertyOfCimObject(cimObject, attrib.getName()));
                        this.logger.debug("Storing multi instance value " + attrib.getName() + "[" + instance + "]='" + vmwareViJavaAccess.getPropertyOfCimObject(cimObject, attrib.getName()) + "' for node " + agent.getNodeId());
                    }
                    collectionSet.getResources().add(vmwareCollectionResource);
                }
            }
            collectionSet.setStatus(1);
        }
        vmwareViJavaAccess.disconnect();
        return collectionSet;
    }

    @Override
    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_vmwareCimDatacollectionConfigDao.getRrdRepository(collectionName);
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }
}

