/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AbstractCollectionAttribute;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.CollectionSetVisitor;
import org.opennms.netmgt.config.collector.Persister;
import org.opennms.netmgt.config.collector.ServiceParameters;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;

public class SnmpAttribute
extends AbstractCollectionAttribute {
    private CollectionResource m_resource;
    private SnmpAttributeType m_type;
    private SnmpValue m_val;

    public SnmpAttribute(CollectionResource resource, SnmpAttributeType type, SnmpValue val) {
        this.m_resource = resource;
        this.m_type = type;
        this.m_val = val;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SnmpAttribute) {
            SnmpAttribute attr = (SnmpAttribute)obj;
            return this.m_resource.equals(attr.m_resource) && this.m_type.equals(attr.m_type);
        }
        return false;
    }

    public int hashCode() {
        return this.m_resource.hashCode() ^ this.m_type.hashCode();
    }

    @Override
    public void visit(CollectionSetVisitor visitor) {
        if (this.log().isDebugEnabled()) {
            this.log().debug("Visiting attribute " + this);
        }
        visitor.visitAttribute((CollectionAttribute)this);
        visitor.completeAttribute((CollectionAttribute)this);
    }

    @Override
    public SnmpAttributeType getAttributeType() {
        return this.m_type;
    }

    @Override
    public ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public CollectionResource getResource() {
        return this.m_resource;
    }

    public SnmpValue getValue() {
        return this.m_val;
    }

    void store(Persister persister) {
        this.getAttributeType().storeAttribute(this, persister);
    }

    @Override
    public void storeAttribute(Persister persister) {
        this.getAttributeType().storeAttribute(this, persister);
    }

    public String toString() {
        return this.getResource() + "." + this.getAttributeType() + " = " + this.getValue();
    }

    public String getType() {
        return this.getAttributeType().getType();
    }

    @Override
    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    @Override
    public String getName() {
        return this.getAttributeType().getName();
    }

    public String getMetricIdentifier() {
        String instance = this.m_resource.getInstance();
        if (instance == null) {
            instance = this.m_type.getInstance();
        }
        return "SNMP_" + SnmpObjId.get((SnmpObjId)this.m_type.getSnmpObjId(), (String)instance);
    }

    @Override
    public String getNumericValue() {
        if (this.getValue() == null) {
            this.log().debug("No data collected for attribute " + this + ". Skipping");
            return null;
        }
        if (this.getValue().isNumeric()) {
            return Long.toString(this.getValue().toLong());
        }
        try {
            return Double.valueOf(this.getValue().toString()).toString();
        }
        catch (NumberFormatException e) {
            this.log().trace("Unable to process data received for attribute " + this + " maybe this is not a number? See bug 1473 for more information. Skipping.");
            return null;
        }
    }

    @Override
    public String getStringValue() {
        SnmpValue value = this.getValue();
        return value == null ? null : value.toString();
    }
}

