/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.utils.DefaultTimeKeeper;
import org.opennms.core.utils.StringUtils;
import org.opennms.core.utils.TimeKeeper;
import org.opennms.netmgt.collectd.NumericAttributeType;
import org.opennms.netmgt.config.collector.AttributeDefinition;
import org.opennms.netmgt.config.collector.ByNameComparator;
import org.opennms.netmgt.config.collector.ResourceIdentifier;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;

public class PersistOperationBuilder {
    private RrdRepository m_repository;
    private String m_rrdName;
    private ResourceIdentifier m_resource;
    private Map<AttributeDefinition, String> m_declarations = new TreeMap<AttributeDefinition, String>((Comparator<AttributeDefinition>)new ByNameComparator());
    private Map<String, String> m_metaData = new LinkedHashMap<String, String>();
    private TimeKeeper m_timeKeeper = new DefaultTimeKeeper();
    static final String DST_GAUGE = "GAUGE";
    static final String DST_COUNTER = "COUNTER";
    public static final int MAX_DS_NAME_LENGTH = 19;

    public PersistOperationBuilder(RrdRepository repository, ResourceIdentifier resource, String rrdName) {
        this.m_repository = repository;
        this.m_resource = resource;
        this.m_rrdName = rrdName;
    }

    public RrdRepository getRepository() {
        return this.m_repository;
    }

    private File getResourceDir(ResourceIdentifier resource) {
        return resource.getResourceDir(this.getRepository());
    }

    public void declareAttribute(AttributeDefinition attrType) {
        this.m_declarations.put(attrType, "U");
    }

    public void setAttributeValue(AttributeDefinition attrType, String value) {
        this.m_declarations.put(attrType, value);
    }

    public void setAttributeMetadata(String metricIdentifier, String name) {
        this.m_metaData.put(metricIdentifier, name);
    }

    public static String mapType(String objectType) {
        if (objectType.toLowerCase().startsWith("counter")) {
            return DST_COUNTER;
        }
        return DST_GAUGE;
    }

    public void commit() throws RrdException {
        if (this.m_declarations.size() == 0) {
            return;
        }
        RrdUtils.createRRD((String)this.m_resource.getOwnerName(), (String)this.getResourceDir(this.m_resource).getAbsolutePath(), (String)this.m_rrdName, (int)this.getRepository().getStep(), this.getDataSources(), (List)this.getRepository().getRraList(), this.getAttributeMappings());
        RrdUtils.updateRRD((String)this.m_resource.getOwnerName(), (String)this.getResourceDir(this.m_resource).getAbsolutePath(), (String)this.m_rrdName, (long)this.m_timeKeeper.getCurrentTime(), (String)this.getValues());
        RrdUtils.createMetaDataFile((String)this.getResourceDir(this.m_resource).getAbsolutePath(), (String)this.m_rrdName, this.m_metaData);
    }

    private String getValues() {
        boolean first = true;
        StringBuffer values = new StringBuffer();
        for (AttributeDefinition attrDef : this.m_declarations.keySet()) {
            String value = this.m_declarations.get(attrDef);
            if (!first) {
                values.append(':');
            } else {
                first = false;
            }
            values.append(value);
        }
        return values.toString();
    }

    private Map<String, String> getAttributeMappings() {
        return null;
    }

    private List<RrdDataSource> getDataSources() {
        ArrayList<RrdDataSource> dataSources = new ArrayList<RrdDataSource>(this.m_declarations.size());
        for (AttributeDefinition attrDef : this.m_declarations.keySet()) {
            String minval = "U";
            String maxval = "U";
            if (attrDef instanceof NumericAttributeType) {
                minval = ((NumericAttributeType)attrDef).getMinval() != null ? ((NumericAttributeType)attrDef).getMinval() : "U";
                maxval = ((NumericAttributeType)attrDef).getMaxval() != null ? ((NumericAttributeType)attrDef).getMaxval() : "U";
            }
            RrdDataSource rrdDataSource = new RrdDataSource(StringUtils.truncate((String)attrDef.getName(), (int)19), PersistOperationBuilder.mapType(attrDef.getType()), this.getRepository().getHeartBeat(), minval, maxval);
            dataSources.add(rrdDataSource);
        }
        return dataSources;
    }

    public String getName() {
        return this.m_rrdName;
    }

    public TimeKeeper getTimeKeeper() {
        return this.m_timeKeeper;
    }

    public void setTimeKeeper(TimeKeeper timeKeeper) {
        this.m_timeKeeper = timeKeeper;
    }
}

