/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AbstractCollectionSetVisitor;
import org.opennms.netmgt.collectd.NumericAttributeType;
import org.opennms.netmgt.collectd.PersistOperationBuilder;
import org.opennms.netmgt.config.collector.AttributeDefinition;
import org.opennms.netmgt.config.collector.AttributeGroup;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.Persister;
import org.opennms.netmgt.config.collector.ResourceIdentifier;
import org.opennms.netmgt.config.collector.ServiceParameters;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.rrd.RrdException;

public class BasePersister
extends AbstractCollectionSetVisitor
implements Persister {
    private boolean m_ignorePersist = false;
    private ServiceParameters m_params;
    private RrdRepository m_repository;
    private LinkedList<Boolean> m_stack = new LinkedList();
    private PersistOperationBuilder m_builder;

    public BasePersister() {
    }

    public BasePersister(ServiceParameters params, RrdRepository repository) {
        this.m_params = params;
        this.m_repository = repository;
    }

    protected void commitBuilder() {
        if (this.isPersistDisabled()) {
            return;
        }
        String name = this.m_builder.getName();
        try {
            this.m_builder.commit();
            this.m_builder = null;
        }
        catch (RrdException e) {
            this.log().error("Unable to persist data for " + name + ": " + (Object)((Object)e), (Throwable)e);
        }
    }

    private boolean isPersistDisabled() {
        return this.m_params != null && this.m_params.getParameters().containsKey("storing-enabled") && this.m_params.getParameters().get("storing-enabled").equals("false");
    }

    @Override
    public void completeAttribute(CollectionAttribute attribute) {
        this.popShouldPersist();
    }

    @Override
    public void completeGroup(AttributeGroup group) {
        this.popShouldPersist();
    }

    @Override
    public void completeResource(CollectionResource resource) {
        this.popShouldPersist();
    }

    protected void createBuilder(CollectionResource resource, String name, AttributeDefinition attributeType) {
        this.createBuilder(resource, name, Collections.singleton(attributeType));
    }

    protected void createBuilder(CollectionResource resource, String name, Set<AttributeDefinition> attributeTypes) {
        this.m_builder = new PersistOperationBuilder(this.getRepository(), (ResourceIdentifier)resource, name);
        if (resource.getTimeKeeper() != null) {
            this.m_builder.setTimeKeeper(resource.getTimeKeeper());
        }
        for (AttributeDefinition attrType : attributeTypes) {
            if (!(attrType instanceof NumericAttributeType)) continue;
            this.m_builder.declareAttribute(attrType);
        }
    }

    public RrdRepository getRepository() {
        return this.m_repository;
    }

    public void setRepository(RrdRepository repository) {
        this.m_repository = repository;
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void persistNumericAttribute(CollectionAttribute attribute) {
        this.log().debug("Persisting " + attribute + (this.isIgnorePersist() ? ". Ignoring value because of sysUpTime changed" : ""));
        String value = this.isIgnorePersist() ? "U" : attribute.getNumericValue();
        this.m_builder.setAttributeValue((AttributeDefinition)attribute.getAttributeType(), value);
        this.m_builder.setAttributeMetadata(attribute.getMetricIdentifier(), attribute.getName());
    }

    public void persistStringAttribute(CollectionAttribute attribute) {
        this.log().debug("Persisting " + attribute);
        CollectionResource resource = attribute.getResource();
        String value = attribute.getStringValue();
        File resourceDir = resource.getResourceDir(this.getRepository());
        if (value == null) {
            this.log().info("No data collected for attribute " + attribute + ".  Skipping.");
            return;
        }
        String attrName = attribute.getName();
        try {
            ResourceTypeUtils.updateStringProperty((File)resourceDir, (String)value, (String)attrName);
        }
        catch (IOException e) {
            this.log().error("Unable to save string attribute " + attribute + ": " + e, (Throwable)e);
        }
    }

    private boolean pop() {
        boolean top = this.top();
        this.m_stack.removeLast();
        return top;
    }

    protected boolean popShouldPersist() {
        return this.pop();
    }

    private void push(boolean b) {
        this.m_stack.addLast(b);
    }

    protected void pushShouldPersist(CollectionAttribute attribute) {
        this.pushShouldPersist(attribute.shouldPersist(this.m_params));
    }

    protected void pushShouldPersist(AttributeGroup group) {
        this.pushShouldPersist(group.shouldPersist(this.m_params));
    }

    private void pushShouldPersist(boolean shouldPersist) {
        this.push(this.top() && shouldPersist);
    }

    protected void pushShouldPersist(CollectionResource resource) {
        this.push(resource.shouldPersist(this.m_params));
    }

    protected boolean shouldPersist() {
        return this.top();
    }

    protected void storeAttribute(CollectionAttribute attribute) {
        if (this.shouldPersist()) {
            attribute.storeAttribute((Persister)this);
            this.log().debug("Storing attribute " + attribute);
        } else {
            this.log().debug("Not persisting attribute " + attribute + "because shouldPersist is false");
        }
    }

    private boolean top() {
        return this.m_stack.getLast();
    }

    @Override
    public void visitAttribute(CollectionAttribute attribute) {
        this.pushShouldPersist(attribute);
        this.storeAttribute(attribute);
    }

    @Override
    public void visitGroup(AttributeGroup group) {
        this.pushShouldPersist(group);
    }

    @Override
    public void visitResource(CollectionResource resource) {
        this.log().info("Persisting data for resource " + resource);
        this.pushShouldPersist(resource);
    }

    public boolean isIgnorePersist() {
        return this.m_ignorePersist;
    }

    public void setIgnorePersist(boolean ignore) {
        this.m_ignorePersist = ignore;
    }

    public PersistOperationBuilder getBuilder() {
        return this.m_builder;
    }
}

