/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.StringTokenizer;
import org.opennms.core.utils.StreamGobbler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ExecRunner.class);
    private static final String WINDOWS_NT_2000_COMMAND_1 = "cmd.exe";
    private static final String WINDOWS_NT_2000_COMMAND_2 = "/C";
    private static final String WINDOWS_9X_ME_COMMAND_1 = "command.exe";
    private static final String WINDOWS_9X_ME_COMMAND_2 = "/C";
    private static final String MAX_RUN_TIME_EXCEEDED_STRING = "MAX_RUN_TIME_EXCEEDED";
    private String out = "".intern();
    private String err = "".intern();
    private int maxRunTimeSecs = 0;
    private boolean maxRunTimeExceeded = false;
    private static final int POLL_DELAY_MS = 100;

    public ExecRunner() {
    }

    public ExecRunner(String command) throws ExceptionInInitializerError {
        this();
        try {
            this.exec(command);
        }
        catch (Throwable e) {
            throw new ExceptionInInitializerError(e.getMessage());
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exec(String command) throws IOException, InterruptedException {
        StringWriter swOut = null;
        PrintWriter pwOut = null;
        StringWriter swErr = null;
        PrintWriter pwErr = null;
        try {
            swOut = new StringWriter();
            pwOut = new PrintWriter((Writer)swOut, true);
            swErr = new StringWriter();
            pwErr = new PrintWriter((Writer)swErr, true);
            int rc = this.exec(command, pwOut, pwErr);
            this.out = swOut.toString();
            this.err = swErr.toString();
            int n = rc;
            this.closeQuietly(pwErr);
            this.closeQuietly(swErr);
            this.closeQuietly(pwOut);
            this.closeQuietly(swOut);
            return n;
        }
        catch (Throwable throwable) {
            this.closeQuietly(pwErr);
            this.closeQuietly(swErr);
            this.closeQuietly(pwOut);
            this.closeQuietly(swOut);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exec(String command, OutputStream stdoutStream, OutputStream stderrStream) throws IOException, InterruptedException {
        PrintWriter pwOut = null;
        PrintWriter pwErr = null;
        try {
            pwOut = new PrintWriter(stdoutStream, true);
            pwErr = new PrintWriter(stderrStream, true);
            int n = this.exec(command, pwOut, pwErr);
            this.closeQuietly(pwErr);
            this.closeQuietly(pwOut);
            return n;
        }
        catch (Throwable throwable) {
            this.closeQuietly(pwErr);
            this.closeQuietly(pwOut);
            throw throwable;
        }
    }

    public int exec(String command, PrintWriter stdoutWriter, PrintWriter stderrWriter) throws IOException, InterruptedException {
        int exitVal = 1;
        Runtime rt = Runtime.getRuntime();
        String[] cmd = null;
        Date startTime = new Date();
        long startTimeMs = startTime.getTime();
        long maxTimeMs = startTimeMs + (long)(this.maxRunTimeSecs * 1000);
        String osName = System.getProperty("os.name");
        if (osName.equals("Windows 95") || osName.equals("Windows 98") || osName.equals("Windows ME")) {
            cmd = new String[]{WINDOWS_9X_ME_COMMAND_1, "/C", command};
        } else if (osName.contains("Windows")) {
            cmd = new String[]{WINDOWS_NT_2000_COMMAND_1, "/C", command};
        } else {
            StringTokenizer st = new StringTokenizer(command, " ");
            cmd = new String[st.countTokens()];
            int token = 0;
            while (st.hasMoreTokens()) {
                String tokenString = st.nextToken();
                cmd[token++] = tokenString;
            }
        }
        if (cmd == null || cmd.length <= 0) {
            throw new IOException("Insufficient commands!");
        }
        Process proc = rt.exec(cmd);
        StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), stdoutWriter);
        StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), stderrWriter);
        outputGobbler.start();
        errorGobbler.start();
        while (true) {
            try {
                exitVal = proc.exitValue();
            }
            catch (IllegalThreadStateException e) {
                if (this.maxRunTimeSecs <= 0) continue;
                Date endTime = new Date();
                long endTimeMs = endTime.getTime();
                if (endTimeMs > maxTimeMs) {
                    proc.destroy();
                    this.maxRunTimeExceeded = true;
                    stderrWriter.println(MAX_RUN_TIME_EXCEEDED_STRING);
                    outputGobbler.quit();
                    errorGobbler.quit();
                    return exitVal;
                }
                Thread.sleep(100L);
                continue;
            }
            break;
        }
        while (outputGobbler.isAlive() || errorGobbler.isAlive()) {
        }
        stdoutWriter.flush();
        stderrWriter.flush();
        return exitVal;
    }

    public String getErrString() {
        return this.err;
    }

    public boolean isMaxRunTimeExceeded() {
        return this.maxRunTimeExceeded;
    }

    public int getMaxRunTimeSecs() {
        return this.maxRunTimeSecs;
    }

    public String getOutString() {
        return this.out;
    }

    public static void main(String[] args) throws IOException {
        try {
            ExecRunner er = new ExecRunner();
            System.out.println("Testing ExecRunner with StringWriter...");
            er.setMaxRunTimeSecs(1);
            er.exec("dir /s c:\\");
            System.out.println("<STDOUT>\n" + er.getOutString() + "</STDOUT>");
            System.out.println("<STDERR>\n" + er.getErrString() + "</STDERR>");
            System.out.println("Testing Done");
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private final void readObject(ObjectInputStream in) throws IOException {
        throw new IOException("Object cannot be deserialized");
    }

    public void setMaxRunTimeSecs(int max) {
        this.maxRunTimeSecs = max;
    }

    private final void writeObject(ObjectOutputStream out) throws IOException {
        throw new IOException("Object cannot be serialized");
    }

    private void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException closeE) {
                LOG.debug("failed to close", (Throwable)closeE);
            }
        }
    }
}

