/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import org.opennms.core.utils.AlphaNumeric;

public abstract class RrdLabelUtils {
    public static final boolean PREFER_IFDESCR = Boolean.getBoolean("org.opennms.core.utils.preferIfDescr");
    public static final boolean DONT_SANITIZE_IFNAME = Boolean.getBoolean("org.opennms.core.utils.dontSanitizeIfName");

    public static String computeNameForRRD(String ifname, String ifdescr) {
        String firstChoice = PREFER_IFDESCR ? ifdescr : ifname;
        String secondChoice = PREFER_IFDESCR ? ifname : ifdescr;
        String label = null;
        if (firstChoice != null && !"".equals(firstChoice)) {
            label = DONT_SANITIZE_IFNAME ? firstChoice : AlphaNumeric.parseAndReplace(firstChoice, '_');
        } else if (secondChoice != null && !"".equals(secondChoice)) {
            label = DONT_SANITIZE_IFNAME ? secondChoice : AlphaNumeric.parseAndReplace(secondChoice, '_');
        }
        return label;
    }

    public static String computePhysAddrForRRD(String physaddr) {
        String parsedPhysAddr;
        String physAddrForRRD = null;
        if (physaddr != null && !physaddr.equals("") && (parsedPhysAddr = AlphaNumeric.parseAndTrim(physaddr)).length() == 12) {
            physAddrForRRD = parsedPhysAddr;
        }
        return physAddrForRRD;
    }

    public static String computeLabelForRRD(String ifname, String ifdescr, String physaddr) {
        String name = RrdLabelUtils.computeNameForRRD(ifname, ifdescr);
        String physAddrForRRD = RrdLabelUtils.computePhysAddrForRRD(physaddr);
        return physAddrForRRD == null ? name : name + '-' + physAddrForRRD;
    }
}

