/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileSystemView;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StringUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StringUtils.class);
    private static final boolean HEADLESS = Boolean.getBoolean("java.awt.headless");
    private static final Pattern WINDOWS_DRIVE = Pattern.compile("^[A-Za-z]\\:\\\\");

    public static String[] createCommandArray(String s, char delim) {
        return StringUtils.createCommandArray(s);
    }

    public static String[] createCommandArray(String s) {
        return new CommandArrayGenerator(s).getCommandArray();
    }

    public static String truncate(String name, int length) {
        if (name.length() <= length) {
            return name;
        }
        return name.substring(0, length);
    }

    public static boolean isLocalWindowsPath(String path) {
        if (File.separatorChar != '\\') {
            return false;
        }
        if (path.length() < 3) {
            return false;
        }
        char colon = path.charAt(1);
        char slash = path.charAt(2);
        if (colon != ':') {
            return false;
        }
        if (slash != '\\' && slash != '/') {
            return false;
        }
        String drive = path.substring(0, 3);
        if (HEADLESS) {
            return WINDOWS_DRIVE.matcher(drive).matches();
        }
        File file = new File(drive);
        return FileSystemView.getFileSystemView().isFileSystemRoot(file);
    }

    public static String prettyXml(String xml) throws TransformerException {
        StringWriter out = new StringWriter();
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StreamResult result = new StreamResult(out);
        StreamSource source = new StreamSource(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
        transformer.transform(source, result);
        return out.toString().trim();
    }

    public static String iso8601LocalOffsetString(Date d) {
        return StringUtils.iso8601OffsetString(d, ZoneId.systemDefault(), null);
    }

    public static String iso8601OffsetString(Date d, ZoneId zone, ChronoUnit truncateTo) {
        ZonedDateTime zdt = d.toInstant().atZone(zone);
        if (truncateTo != null) {
            zdt = zdt.truncatedTo(truncateTo);
        }
        return zdt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static String stripExtraQuotes(String string) {
        return string.replaceAll("^\"(.*)\"$", "$1");
    }

    public static boolean equalsTrimmed(String a, String b) {
        int i;
        if (a == null) {
            return false;
        }
        int alen = a.length();
        int blen = b.length();
        if (blen > alen) {
            return false;
        }
        for (i = 0; i < alen && a.charAt(i) <= ' '; ++i) {
        }
        for (int j = 0; i < alen && j < blen; ++i, ++j) {
            if (a.charAt(i) == b.charAt(j)) continue;
            return false;
        }
        if (i == alen) {
            return true;
        }
        while (i < alen && a.charAt(alen - 1) <= ' ') {
            --alen;
        }
        return alen - i == 0;
    }

    public static String toStringEfficiently(Date date) {
        long time = date.getTime();
        String retval = date.toString();
        date.setTime(time);
        return retval;
    }

    public static Integer parseDecimalInt(String value) {
        return StringUtils.parseDecimalInt(value, true);
    }

    public static Integer parseDecimalInt(String value, boolean throwExceptions) {
        int length = value.length();
        if (value == null || length < 1) {
            if (throwExceptions) {
                throw new NumberFormatException("Null or empty value");
            }
            return null;
        }
        try {
            int sign = -1;
            int i = 0;
            if (value.charAt(0) == '-') {
                if (length == 1) {
                    if (throwExceptions) {
                        throw new NumberFormatException("No digits in value: " + value);
                    }
                    return null;
                }
                sign = 1;
                i = 1;
            }
            int retval = 0;
            while (i < length) {
                int oldValue = retval;
                char current = value.charAt(i);
                int digit = current - 48;
                if (digit < 0 || digit > 9) {
                    if (throwExceptions) {
                        throw new NumberFormatException("Invalid digit: " + current);
                    }
                    return null;
                }
                if ((retval = retval * 10 - digit) > oldValue) {
                    if (throwExceptions) {
                        throw new NumberFormatException(sign == -1 ? "Overflow" : "Underflow");
                    }
                    return null;
                }
                ++i;
            }
            return sign * retval;
        }
        catch (Exception e) {
            if (throwExceptions) {
                NumberFormatException nfe = new NumberFormatException("Could not parse integer value: " + value);
                nfe.initCause(e);
                throw nfe;
            }
            return null;
        }
    }

    private static class CommandArrayGenerator {
        private final ArrayList<String> m_segments = new ArrayList();
        private boolean m_isInQuotes = false;
        private StringBuilder m_segmentBuffer = new StringBuilder();

        public CommandArrayGenerator(String s) {
            if (s == null) {
                throw new IllegalArgumentException("Cannot take null parameters.");
            }
            for (char c : s.toCharArray()) {
                this.onChar(c);
            }
            this.resetSegment();
        }

        private void onChar(char c) {
            if (c == '\"') {
                this.m_isInQuotes = !this.m_isInQuotes;
            } else if (CommandArrayGenerator.isWhitespace(c)) {
                if (!this.m_isInQuotes) {
                    this.resetSegment();
                } else if (c == ' ') {
                    this.m_segmentBuffer.append(c);
                } else {
                    this.resetSegment();
                }
            } else {
                this.m_segmentBuffer.append(c);
            }
        }

        private void resetSegment() {
            if (this.m_segmentBuffer.length() > 0) {
                this.m_segments.add(this.m_segmentBuffer.toString());
                this.m_segmentBuffer = new StringBuilder();
            }
        }

        public String[] getCommandArray() {
            return this.m_segments.toArray(new String[this.m_segments.size()]);
        }

        private static boolean isWhitespace(char aChar) {
            switch (aChar) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }
    }
}

