/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.network.IPAddress;
import org.opennms.core.utils.ByteArrayComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InetAddressUtils {
    private static final Logger LOG = LoggerFactory.getLogger(InetAddressUtils.class);
    public static final String INVALID_BRIDGE_ADDRESS = "000000000000";
    public static final String INVALID_STP_BRIDGE_ID = "0000000000000000";
    public static final String INVALID_STP_BRIDGE_DESIGNATED_PORT = "0000";
    private static final ByteArrayComparator s_BYTE_ARRAY_COMPARATOR = new ByteArrayComparator();
    public static final InetAddress UNPINGABLE_ADDRESS;
    public static final InetAddress UNPINGABLE_ADDRESS_IPV6;
    public static final InetAddress ZEROS;
    public static final InetAddress TWO_FIFTY_FIVES;
    public static final InetAddress ONE_TWENTY_SEVEN;

    public static InetAddress getLocalHostAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOG.warn("getLocalHostAddress: Could not lookup the host address for the local host machine, address set to '127.0.0.1'.", (Throwable)e);
            return InetAddressUtils.addr("127.0.0.1");
        }
    }

    public static String getLocalHostAddressAsString() {
        String localhost = InetAddressUtils.str(InetAddressUtils.getLocalHostAddress());
        return localhost == null ? "127.0.0.1" : localhost;
    }

    public static String getLocalHostName() {
        InetAddress localHostAddress = InetAddressUtils.getLocalHostAddress();
        if (localHostAddress == null) {
            LOG.warn("getLocalHostName: Could not lookup the host name for the local host machine, name set to 'localhost'.");
            return "localhost";
        }
        return localHostAddress.getHostName();
    }

    public static String incr(String address) throws UnknownHostException {
        return InetAddressUtils.toIpAddrString(InetAddressUtils.incr(InetAddressUtils.toIpAddrBytes(address)));
    }

    public static byte[] incr(byte[] address) throws UnknownHostException {
        BigInteger addr = new BigInteger(1, address).add(BigInteger.ONE);
        return InetAddressUtils.convertBigIntegerIntoInetAddress(addr).getAddress();
    }

    public static String decr(String address) throws UnknownHostException {
        return InetAddressUtils.toIpAddrString(InetAddressUtils.decr(InetAddressUtils.toIpAddrBytes(address)));
    }

    public static byte[] decr(byte[] address) throws UnknownHostException {
        BigInteger addr = new BigInteger(1, address).subtract(BigInteger.ONE);
        return InetAddressUtils.convertBigIntegerIntoInetAddress(addr).getAddress();
    }

    public static InetAddress getInetAddress(int[] octets, int offset, int length) {
        byte[] addressBytes = new byte[length];
        for (int i = 0; i < addressBytes.length; ++i) {
            addressBytes[i] = Integer.valueOf(octets[i + offset]).byteValue();
        }
        return InetAddressUtils.getInetAddress(addressBytes);
    }

    public static InetAddress getInetAddress(byte[] ipAddrOctets) {
        return new IPAddress(ipAddrOctets).toInetAddress();
    }

    public static InetAddress getInetAddress(String dottedNotation) {
        return new IPAddress(dottedNotation).toInetAddress();
    }

    public static byte[] toIpAddrBytes(String dottedNotation) {
        return new IPAddress(dottedNotation).toOctets();
    }

    public static String toIpAddrString(InetAddress addr) {
        return new IPAddress(addr).toDbString();
    }

    public static String toIpAddrString(byte[] addr) {
        return new IPAddress(addr).toDbString();
    }

    public static InetAddress getLowestInetAddress(List<InetAddress> addresses) {
        byte[] originalBytes;
        if (addresses == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        InetAddress lowest = null;
        byte[] lowestBytes = originalBytes = InetAddressUtils.toIpAddrBytes("ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
        for (InetAddress temp : addresses) {
            byte[] tempBytes = temp.getAddress();
            if (s_BYTE_ARRAY_COMPARATOR.compare(tempBytes, lowestBytes) >= 0) continue;
            lowestBytes = tempBytes;
            lowest = temp;
        }
        return s_BYTE_ARRAY_COMPARATOR.compare(originalBytes, lowestBytes) == 0 ? null : lowest;
    }

    public static BigInteger difference(String addr1, String addr2) {
        return InetAddressUtils.difference(InetAddressUtils.getInetAddress(addr1), InetAddressUtils.getInetAddress(addr2));
    }

    public static BigInteger difference(InetAddress addr1, InetAddress addr2) {
        return new BigInteger(1, addr1.getAddress()).subtract(new BigInteger(1, addr2.getAddress()));
    }

    public static boolean isInetAddressInRange(byte[] laddr, String beginString, String endString) {
        byte[] begin = InetAddressUtils.toIpAddrBytes(beginString);
        byte[] end = InetAddressUtils.toIpAddrBytes(endString);
        return InetAddressUtils.isInetAddressInRange(laddr, begin, end);
    }

    public static boolean isInetAddressInRange(String addrString, String beginString, String endString) {
        byte[] begin;
        byte[] addr = InetAddressUtils.toIpAddrBytes(addrString);
        if (s_BYTE_ARRAY_COMPARATOR.compare(addr, begin = InetAddressUtils.toIpAddrBytes(beginString)) > 0) {
            byte[] end = InetAddressUtils.toIpAddrBytes(endString);
            return s_BYTE_ARRAY_COMPARATOR.compare(addr, end) <= 0;
        }
        return s_BYTE_ARRAY_COMPARATOR.compare(addr, begin) == 0;
    }

    public static boolean inSameScope(InetAddress addr1, InetAddress addr2) {
        if (addr1 instanceof Inet4Address) {
            return addr2 instanceof Inet4Address;
        }
        if (addr2 instanceof Inet4Address) {
            return false;
        }
        return Integer.valueOf(((Inet6Address)addr1).getScopeId()).compareTo(((Inet6Address)addr2).getScopeId()) == 0;
    }

    public static InetAddress getNetwork(InetAddress ipaddress, InetAddress netmask) {
        byte[] ipAddress = ipaddress.getAddress();
        byte[] netMask = netmask.getAddress();
        byte[] netWork = new byte[4];
        for (int i = 0; i < 4; ++i) {
            netWork[i] = Integer.valueOf(ipAddress[i] & netMask[i]).byteValue();
        }
        return InetAddressUtils.getInetAddress(netWork);
    }

    public static boolean inSameNetwork(InetAddress addr1, InetAddress addr2, InetAddress mask) {
        if (!(addr1 instanceof Inet4Address && addr2 instanceof Inet4Address && mask instanceof Inet4Address)) {
            return false;
        }
        byte[] ipAddress1 = addr1.getAddress();
        byte[] ipAddress2 = addr2.getAddress();
        byte[] netMask = mask.getAddress();
        for (int i = 0; i < 4; ++i) {
            if ((ipAddress1[i] & netMask[i]) == (ipAddress2[i] & netMask[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isInetAddressInRange(byte[] addr, byte[] begin, byte[] end) {
        if (s_BYTE_ARRAY_COMPARATOR.compare(addr, begin) > 0) {
            return s_BYTE_ARRAY_COMPARATOR.compare(addr, end) <= 0;
        }
        return s_BYTE_ARRAY_COMPARATOR.compare(addr, begin) == 0;
    }

    public static boolean isInetAddressInRange(String ipAddr, byte[] begin, byte[] end) {
        return InetAddressUtils.isInetAddressInRange(InetAddressUtils.toIpAddrBytes(ipAddr), begin, end);
    }

    public static InetAddress convertCidrToInetAddressV4(int cidr) {
        int i;
        if (cidr < 0 || cidr > 32) {
            throw new IllegalArgumentException("Illegal IPv4 CIDR mask length: " + cidr);
        }
        StringBuilder binaryString = new StringBuilder();
        for (i = 0; i < cidr; ++i) {
            binaryString.append('1');
        }
        while (i < 32) {
            binaryString.append('0');
            ++i;
        }
        try {
            return InetAddressUtils.convertBigIntegerIntoInetAddress(new BigInteger(binaryString.toString(), 2));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Could not convert CIDR mask to InetAddress: " + e.getMessage());
        }
    }

    public static InetAddress convertCidrToInetAddressV6(int cidr) {
        int i;
        if (cidr < 0 || cidr > 128) {
            throw new IllegalArgumentException("Illegal IPv6 CIDR mask length: " + cidr);
        }
        StringBuilder binaryString = new StringBuilder();
        for (i = 0; i < cidr; ++i) {
            binaryString.append('1');
        }
        while (i < 128) {
            binaryString.append('0');
            ++i;
        }
        try {
            return InetAddressUtils.convertBigIntegerIntoInetAddress(new BigInteger(binaryString.toString(), 2));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Could not convert CIDR mask to InetAddress: " + e.getMessage());
        }
    }

    public static InetAddress convertBigIntegerIntoInetAddress(BigInteger i) throws UnknownHostException {
        if (i.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("BigInteger is negative, cannot convert into an IP address: " + i.toString());
        }
        byte[] bytes = i.toByteArray();
        if (bytes.length == 0) {
            return InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
        }
        if (bytes.length <= 4) {
            byte[] addressBytes = new byte[4];
            int k = 3;
            int j = bytes.length - 1;
            while (j >= 0) {
                addressBytes[k] = bytes[j];
                --j;
                --k;
            }
            return InetAddress.getByAddress(addressBytes);
        }
        if (bytes.length <= 5 && bytes[0] == 0) {
            byte[] addressBytes = new byte[4];
            int k = 3;
            int j = bytes.length - 1;
            while (j >= 1) {
                addressBytes[k] = bytes[j];
                --j;
                --k;
            }
            return InetAddress.getByAddress(addressBytes);
        }
        if (bytes.length <= 16) {
            byte[] addressBytes = new byte[16];
            int k = 15;
            int j = bytes.length - 1;
            while (j >= 0) {
                addressBytes[k] = bytes[j];
                --j;
                --k;
            }
            return InetAddress.getByAddress(addressBytes);
        }
        if (bytes.length <= 17 && bytes[0] == 0) {
            byte[] addressBytes = new byte[16];
            int k = 15;
            int j = bytes.length - 1;
            while (j >= 1) {
                addressBytes[k] = bytes[j];
                --j;
                --k;
            }
            return InetAddress.getByAddress(addressBytes);
        }
        throw new IllegalArgumentException("BigInteger is too large to convert into an IP address: " + i.toString());
    }

    public static InetAddress addr(String ipAddrString) {
        return ipAddrString == null ? null : InetAddressUtils.getInetAddress(ipAddrString.trim());
    }

    public static String normalize(String ipAddrString) {
        return ipAddrString == null ? null : InetAddressUtils.toIpAddrString(InetAddressUtils.addr(ipAddrString.trim()));
    }

    public static String str(InetAddress addr) {
        return addr == null ? null : InetAddressUtils.toIpAddrString(addr);
    }

    public static BigInteger toInteger(InetAddress ipAddress) {
        return new BigInteger(1, ipAddress.getAddress());
    }

    public static String toOid(InetAddress addr) {
        if (addr == null) {
            return null;
        }
        if (addr instanceof Inet4Address) {
            return InetAddressUtils.str(addr);
        }
        if (addr instanceof Inet6Address) {
            byte[] buf = addr.getAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < buf.length; ++i) {
                sb.append(buf[i] & 0xFF);
                if (i == buf.length - 1) continue;
                sb.append(".");
            }
            return sb.toString();
        }
        LOG.debug("don't know how to handle {}", (Object)addr);
        return null;
    }

    public static byte[] macAddressStringToBytes(String macAddress) {
        if (macAddress == null) {
            throw new IllegalArgumentException("Cannot decode null MAC address");
        }
        byte[] contents = new byte[6];
        String[] digits = macAddress.split(":");
        if (digits.length != 6) {
            if (macAddress.length() == 12) {
                digits = new String[]{macAddress.substring(0, 2), macAddress.substring(2, 4), macAddress.substring(4, 6), macAddress.substring(6, 8), macAddress.substring(8, 10), macAddress.substring(10)};
            } else {
                throw new IllegalArgumentException("Cannot decode MAC address: '" + macAddress + "'");
            }
        }
        for (int i = 0; i < 6; ++i) {
            contents[i] = Integer.decode("0x" + digits[i]).byteValue();
        }
        return contents;
    }

    public static String macAddressBytesToString(byte[] macAddress) {
        if (macAddress.length != 6) {
            throw new IllegalArgumentException("Cannot decode MAC address: " + Arrays.toString(macAddress));
        }
        return String.format("%02x%02x%02x%02x%02x%02x", macAddress[0], macAddress[1], macAddress[2], macAddress[3], macAddress[4], macAddress[5]);
    }

    public static String normalizeMacAddress(String macAddress) {
        return InetAddressUtils.macAddressBytesToString(InetAddressUtils.macAddressStringToBytes(macAddress));
    }

    public static boolean isValidStpDesignatedPort(String bridgeDesignatedPort) {
        if (bridgeDesignatedPort == null || bridgeDesignatedPort.equals(INVALID_STP_BRIDGE_DESIGNATED_PORT)) {
            return false;
        }
        Pattern pattern = Pattern.compile("([0-9a-f]{4})");
        Matcher matcher = pattern.matcher(bridgeDesignatedPort);
        return matcher.matches();
    }

    public static int getBridgeDesignatedPortNumber(String stpPortDesignatedPort) {
        return 0x1FFF & Integer.parseInt(stpPortDesignatedPort, 16);
    }

    public static boolean isValidBridgeAddress(String bridgeAddress) {
        if (bridgeAddress == null || bridgeAddress.equals(INVALID_BRIDGE_ADDRESS)) {
            return false;
        }
        Pattern pattern = Pattern.compile("([0-9a-f]{12})");
        Matcher matcher = pattern.matcher(bridgeAddress);
        return matcher.matches();
    }

    public static boolean isValidStpBridgeId(String bridgeId) {
        if (bridgeId == null || bridgeId.equals(INVALID_STP_BRIDGE_ID)) {
            return false;
        }
        Pattern pattern = Pattern.compile("([0-9a-f]{16})");
        Matcher matcher = pattern.matcher(bridgeId);
        return matcher.matches();
    }

    public static String getBridgeAddressFromStpBridgeId(String bridgeId) {
        return bridgeId.substring(4, 16);
    }

    public static InetAddress getIpAddressByHexString(String ipaddrhexstrng) {
        long ipAddr = Long.parseLong(ipaddrhexstrng, 16);
        byte[] bytes = new byte[4];
        bytes[3] = (byte)(ipAddr & 0xFFL);
        bytes[2] = (byte)(ipAddr >> 8 & 0xFFL);
        bytes[1] = (byte)(ipAddr >> 16 & 0xFFL);
        bytes[0] = (byte)(ipAddr >> 24 & 0xFFL);
        return InetAddressUtils.getInetAddress(bytes);
    }

    static {
        ZEROS = InetAddressUtils.addr("0.0.0.0");
        TWO_FIFTY_FIVES = InetAddressUtils.addr("255.255.255.255");
        ONE_TWENTY_SEVEN = InetAddressUtils.addr("127.0.0.1");
        try {
            UNPINGABLE_ADDRESS = InetAddress.getByAddress(new byte[]{-64, 0, 2, 123});
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
        try {
            UNPINGABLE_ADDRESS_IPV6 = InetAddress.getByName("fd25:28a0:ba2f:6b78:0000:0000:0000:0001");
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    public static enum AddressType {
        IPv4,
        IPv6;

    }
}

