/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;

public abstract class IPLike {
    public static boolean matches(InetAddress address, String pattern) {
        return IPLike.matches(InetAddressUtils.str(address), pattern);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean matches(String address, String pattern) {
        String[] hostOctets = null;
        String[] matchOctets = null;
        Object var4_4 = null;
        int numberOfOctets = 4;
        if (address.indexOf(58) >= 0) {
            String[] patternAndScope = pattern.split("%");
            pattern = patternAndScope[0];
            String[] addressAndScope = address.split("%");
            address = addressAndScope[0];
            if (patternAndScope.length >= 2) {
                if (patternAndScope.length != 2) throw new IllegalArgumentException("Illegal scope identifier filter: " + pattern);
                if (addressAndScope.length < 2) {
                    return false;
                }
                if (addressAndScope.length != 2) throw new IllegalArgumentException("Illegal scope identifier in address: " + address);
                if (!IPLike.matchNumericListOrRange(addressAndScope[1], patternAndScope[1], new DecimalRangeMatcher())) {
                    return false;
                }
            }
            hostOctets = address.split("\\:", 0);
            matchOctets = pattern.split("\\:", 0);
            numberOfOctets = 8;
            HexRangeMatcher hexRangeMatcher = new HexRangeMatcher();
        } else {
            hostOctets = address.split("\\.", 0);
            matchOctets = pattern.split("\\.", 0);
            numberOfOctets = 4;
            DecimalRangeMatcher decimalRangeMatcher = new DecimalRangeMatcher();
        }
        if (hostOctets.length != numberOfOctets) {
            throw new IllegalArgumentException("Malformatted IP address: " + address);
        }
        if (matchOctets.length != numberOfOctets) {
            throw new IllegalArgumentException("Malformatted IPLIKE match expression: " + pattern);
        }
        for (int i = 0; i < numberOfOctets; ++i) {
            void var4_7;
            if (IPLike.matchNumericListOrRange(hostOctets[i], matchOctets[i], (RangeMatcher)var4_7)) continue;
            return false;
        }
        return true;
    }

    public static boolean matchNumericListOrRange(String value, String patterns) {
        return IPLike.matchNumericListOrRange(value, patterns, new DecimalRangeMatcher());
    }

    public static boolean matchNumericListOrRange(String value, String patterns, RangeMatcher matcher) {
        String[] patternList;
        for (String element : patternList = patterns.split(",", 0)) {
            if (!matcher.match(value, element)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchRange(String value, String pattern) {
        int dashCount = IPLike.countChar('-', pattern);
        if ("*".equals(pattern)) {
            return true;
        }
        if (dashCount == 0) {
            return Long.parseLong(pattern, 10) == Long.parseLong(value, 10);
        }
        if (dashCount > 1) {
            return false;
        }
        if (dashCount == 1) {
            String[] ar = pattern.split("-");
            long rangeBegin = Long.parseLong(ar[0]);
            long rangeEnd = Long.parseLong(ar[1]);
            long ip = Long.parseLong(value);
            return ip >= rangeBegin && ip <= rangeEnd;
        }
        return false;
    }

    public static boolean matchRangeHex(String value, String pattern) {
        int dashCount = IPLike.countChar('-', pattern);
        if ("*".equals(pattern)) {
            return true;
        }
        if (dashCount == 0) {
            return Long.parseLong(pattern, 16) == Long.parseLong(value, 16);
        }
        if (dashCount > 1) {
            return false;
        }
        if (dashCount == 1) {
            String[] ar = pattern.split("-");
            long rangeBegin = Long.parseLong(ar[0], 16);
            long rangeEnd = Long.parseLong(ar[1], 16);
            long ip = Long.parseLong(value, 16);
            return ip >= rangeBegin && ip <= rangeEnd;
        }
        return false;
    }

    public static int countChar(char charIn, String stingIn) {
        int charCount = 0;
        int charIndex = 0;
        for (int i = 0; i < stingIn.length(); ++i) {
            charIndex = stingIn.indexOf(charIn, i);
            if (charIndex == -1) continue;
            ++charCount;
            i = charIndex + 1;
        }
        return charCount;
    }

    private static class DecimalRangeMatcher
    implements RangeMatcher {
        private DecimalRangeMatcher() {
        }

        @Override
        public boolean match(String value, String range) {
            return IPLike.matchRange(value, range);
        }
    }

    private static class HexRangeMatcher
    implements RangeMatcher {
        private HexRangeMatcher() {
        }

        @Override
        public boolean match(String value, String range) {
            return IPLike.matchRangeHex(value, range);
        }
    }

    private static interface RangeMatcher {
        public boolean match(String var1, String var2);
    }
}

