/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils.url;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericURLConnection
extends URLConnection {
    private final Logger logger = LoggerFactory.getLogger(GenericURLConnection.class);
    private URL m_url;
    private static final String USERINFO_DELIMITER = ":";
    private static final String UTF8_ENCODING = "UTF-8";
    private static final String URL_QUERY_ARGS_DELIMITERS = "[&;]";
    private static final String KEY_VALUE_DELIMITER = "=";
    private static final String EMPTY_STRING = "";

    protected GenericURLConnection(URL url) {
        super(url);
        this.m_url = url;
    }

    protected String getUsername() {
        String userInfo = this.m_url.getUserInfo();
        if (userInfo != null) {
            if (userInfo.contains(USERINFO_DELIMITER)) {
                String[] userName = userInfo.split(USERINFO_DELIMITER);
                return userName[0];
            }
            this.logger.warn("Only user name without password configured. Return user info: '{}'", (Object)userInfo);
            return userInfo;
        }
        this.logger.warn("No credentials for URL connection configured.");
        return null;
    }

    protected String getPassword() {
        String userInfo = this.m_url.getUserInfo();
        if (userInfo != null) {
            if (userInfo.contains(USERINFO_DELIMITER)) {
                String[] userPass = userInfo.split(USERINFO_DELIMITER);
                return userPass[1];
            }
            this.logger.warn("Only user name without password configured. Return empty string as password");
            return EMPTY_STRING;
        }
        this.logger.warn("No credentials for URL connection configured.");
        return null;
    }

    protected Map<String, String> getQueryArgs() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String queryString = this.m_url.getQuery();
        if (queryString != null) {
            String[] queryArgs;
            try {
                queryString = URLDecoder.decode(queryString, UTF8_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("Unsupported UTF-8 encoding for URL query string: '{}'. Error message: '{}'", (Object)queryString, (Object)e.getMessage());
            }
            String[] stringArray = queryArgs = queryString.split(URL_QUERY_ARGS_DELIMITERS);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String queryArg;
                String key = queryArg = stringArray[i];
                String value = EMPTY_STRING;
                if (queryArg.contains(KEY_VALUE_DELIMITER)) {
                    String[] keyValue = queryArg.split(KEY_VALUE_DELIMITER);
                    key = keyValue[0];
                    value = keyValue[1];
                }
                if (EMPTY_STRING.equals(key)) continue;
                hashMap.put(key, value);
                this.logger.debug("Key: '{}' : Value: '{}'", (Object)key, (Object)value);
            }
        }
        return hashMap;
    }
}

