/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.ThreadCategory;

public abstract class StringReplaceOperation {
    protected String m_pattern;
    protected String m_replacement;

    public StringReplaceOperation(String spec) {
        Matcher specMatcher;
        if (spec == null) {
            spec = "";
        }
        if (!(specMatcher = Pattern.compile("^s/([^/]+)/([^/]*)/$").matcher(spec)).matches()) {
            throw new IllegalArgumentException("Specification '" + spec + "' is invalid; must be of the form s/pattern/replacement/ with no trailing modifiers");
        }
        this.m_pattern = specMatcher.group(1).intern();
        this.m_replacement = specMatcher.group(2).intern();
    }

    public String getPattern() {
        return this.m_pattern;
    }

    public String getReplacement() {
        return this.m_replacement;
    }

    public String toString() {
        return "Class: " + this.getClass().getName() + "; Pattern: " + this.m_pattern + "; Replacement: " + this.m_replacement;
    }

    public abstract String replace(String var1);

    protected ThreadCategory log() {
        return ThreadCategory.getInstance();
    }
}

