/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import org.opennms.core.utils.AlphaNumeric;

public abstract class RrdLabelUtils {
    public static String computeNameForRRD(String ifname, String ifdescr) {
        String label = null;
        if (ifname != null && !ifname.equals("")) {
            label = AlphaNumeric.parseAndReplace(ifname, '_');
        } else if (ifdescr != null && !ifdescr.equals("")) {
            label = AlphaNumeric.parseAndReplace(ifdescr, '_');
        }
        return label;
    }

    public static String computePhysAddrForRRD(String physaddr) {
        String parsedPhysAddr;
        String physAddrForRRD = null;
        if (physaddr != null && !physaddr.equals("") && (parsedPhysAddr = AlphaNumeric.parseAndTrim(physaddr)).length() == 12) {
            physAddrForRRD = parsedPhysAddr;
        }
        return physAddrForRRD;
    }

    public static String computeLabelForRRD(String ifname, String ifdescr, String physaddr) {
        String name = RrdLabelUtils.computeNameForRRD(ifname, ifdescr);
        String physAddrForRRD = RrdLabelUtils.computePhysAddrForRRD(physaddr);
        return physAddrForRRD == null ? name : name + '-' + physAddrForRRD;
    }
}

