/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.text.DecimalFormat;

public class SIUtils {
    private static final DecimalFormat s_oneDigitAfterDecimal = new DecimalFormat("0.0##");
    private static final DecimalFormat s_noDigitsAfterDecimal = new DecimalFormat("0");

    public static String getHumanReadableIfSpeed(long ifSpeed) {
        String units;
        double displaySpeed;
        DecimalFormat formatter;
        if (ifSpeed >= 1000000000L) {
            formatter = ifSpeed % 1000000000L == 0L ? s_noDigitsAfterDecimal : s_oneDigitAfterDecimal;
            displaySpeed = (double)ifSpeed / 1.0E9;
            units = "Gbps";
        } else if (ifSpeed >= 1000000L) {
            formatter = ifSpeed % 1000000L == 0L ? s_noDigitsAfterDecimal : s_oneDigitAfterDecimal;
            displaySpeed = (double)ifSpeed / 1000000.0;
            units = "Mbps";
        } else if (ifSpeed >= 1000L) {
            formatter = ifSpeed % 1000L == 0L ? s_noDigitsAfterDecimal : s_oneDigitAfterDecimal;
            displaySpeed = (double)ifSpeed / 1000.0;
            units = "kbps";
        } else {
            formatter = s_noDigitsAfterDecimal;
            displaySpeed = ifSpeed;
            units = "bps";
        }
        return formatter.format(displaySpeed) + " " + units;
    }
}

