/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit;

import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.cassandraunit.CQLDataLoader;
import org.cassandraunit.CassandraCQLUnit;
import org.cassandraunit.JUnitNewtsCassandra;
import org.cassandraunit.dataset.CQLDataSet;
import org.cassandraunit.dataset.cql.FileCQLDataSet;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;
import org.opennms.newts.cassandra.search.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class JUnitNewtsCassandraExecutionListener
extends AbstractTestExecutionListener {
    private static final Logger LOG = LoggerFactory.getLogger(JUnitNewtsCassandraExecutionListener.class);
    private static final String KEYSPACE_PLACEHOLDER = "$KEYSPACE$";
    private CassandraCQLUnit m_cassandraUnit;
    private boolean m_initialized = false;
    private Session m_session;
    private Cluster m_cluster;

    public void beforeTestClass(TestContext testContext) throws Exception {
        JUnitNewtsCassandra config = JUnitNewtsCassandraExecutionListener.findNewtsCassandraAnnotation(testContext);
        if (config == null) {
            return;
        }
        this.m_cassandraUnit = new MyCassandraCQLUnit(JUnitNewtsCassandraExecutionListener.getDataSet(config.keyspace()), config.configurationFileName());
        if (!this.m_initialized) {
            this.m_cassandraUnit.before();
            this.m_session = this.m_cassandraUnit.session;
            this.m_cluster = this.m_cassandraUnit.cluster;
            this.m_initialized = true;
        }
    }

    public void afterTestClass(TestContext testContext) throws Exception {
        JUnitNewtsCassandra config = JUnitNewtsCassandraExecutionListener.findNewtsCassandraAnnotation(testContext);
        if (config == null) {
            return;
        }
        if (this.m_session != null) {
            LOG.debug("session shutdown");
            CloseFuture closeFuture = this.m_session.closeAsync();
            closeFuture.force();
        }
        if (this.m_cluster != null) {
            LOG.debug("cluster shutdown");
            this.m_cluster.close();
        }
    }

    private static JUnitNewtsCassandra findNewtsCassandraAnnotation(TestContext testContext) {
        JUnitNewtsCassandra config;
        Method testMethod = testContext.getTestMethod();
        if (testMethod != null && (config = testMethod.getAnnotation(JUnitNewtsCassandra.class)) != null) {
            return config;
        }
        Class testClass = testContext.getTestClass();
        return testClass.getAnnotation(JUnitNewtsCassandra.class);
    }

    public static CQLDataSet getDataSet(String keyspace) {
        try {
            Schema searchSchema = new Schema();
            org.opennms.newts.persistence.cassandra.Schema samplesSchema = new org.opennms.newts.persistence.cassandra.Schema();
            ArrayList schemas = Lists.newArrayList((Object[])new org.opennms.newts.cassandra.Schema[]{searchSchema, samplesSchema});
            String schemasString = "";
            for (org.opennms.newts.cassandra.Schema schema : schemas) {
                schemasString = schemasString + IOUtils.toString((InputStream)schema.getInputStream());
            }
            schemasString = schemasString.replace(KEYSPACE_PLACEHOLDER, keyspace);
            String[] lines = schemasString.split("\\r?\\n");
            StringBuffer sb = new StringBuffer();
            boolean foundCreateKeyspace = false;
            boolean skipNextLine = false;
            for (String line : lines) {
                if (line.startsWith("CREATE KEYSPACE")) {
                    if (!foundCreateKeyspace) {
                        foundCreateKeyspace = true;
                        sb.append(line);
                        sb.append("\n");
                        continue;
                    }
                    skipNextLine = true;
                    continue;
                }
                if (skipNextLine) {
                    skipNextLine = false;
                    continue;
                }
                sb.append(line);
                sb.append("\n");
            }
            File schemaFile = File.createTempFile("schema-", ".cql", new File("target"));
            schemaFile.deleteOnExit();
            Files.write((CharSequence)sb.toString(), (File)schemaFile, (Charset)Charsets.UTF_8);
            return new FileCQLDataSet(schemaFile.getAbsolutePath(), false, true, keyspace);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static class MyCassandraCQLUnit
    extends CassandraCQLUnit {
        private final CQLDataSet dataSet;

        public MyCassandraCQLUnit(CQLDataSet dataSet, String configurationFileName) {
            super(dataSet, configurationFileName);
            this.dataSet = dataSet;
        }

        protected void load() {
            String hostIp = EmbeddedCassandraServerHelper.getHost();
            int port = EmbeddedCassandraServerHelper.getNativeTransportPort();
            this.cluster = new Cluster.Builder().addContactPoint(hostIp).withPort(port).build();
            this.session = this.cluster.connect();
            CQLDataLoader dataLoader = new CQLDataLoader(this.session);
            dataLoader.load(this.dataSet);
            this.session = dataLoader.getSession();
        }
    }
}

