/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.test;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.core.utils.PropertiesUtils;
import org.springframework.beans.factory.InitializingBean;

public class DaoTestConfigBean
implements InitializingBean {
    private String m_relativeHomeDirectory = null;
    private String m_rrdBinary = "/bin/true";
    private String m_relativeRrdBaseDirectory = "target/test/opennms-home/share/rrd";
    private static final String m_relativeImporterDirectory = "target/test/opennms-home/etc/imports";
    private static final String m_relativeForeignSourceDirectory = "target/test/opennms-home/etc/foreign-sources";

    public void afterPropertiesSet() {
        if (System.getProperty("org.opennms.netmgt.icmp.pingerClass") == null) {
            System.setProperty("org.opennms.netmgt.icmp.pingerClass", "org.opennms.netmgt.icmp.jna.JnaPinger");
        }
        if (System.getProperty("activemq.data") == null) {
            System.setProperty("activemq.data", "target/test/activemq");
        }
        Properties opennmsProperties = new Properties();
        try {
            opennmsProperties.load(ConfigurationTestUtils.getInputStreamForConfigFile((String)"opennms.properties"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Properties substitutions = new Properties();
        substitutions.setProperty("install.database.name", "opennms");
        substitutions.setProperty("install.database.driver", "org.postgres.Driver");
        substitutions.setProperty("install.share.dir", "target/test/share");
        substitutions.setProperty("install.logs.dir", "target/test/logs");
        for (Map.Entry<Object, Object> entry : opennmsProperties.entrySet()) {
            System.setProperty((String)entry.getKey(), PropertiesUtils.substitute((String)((String)entry.getValue()), (Properties[])new Properties[]{substitutions}));
        }
        if (this.m_relativeHomeDirectory != null) {
            ConfigurationTestUtils.setRelativeHomeDirectory((String)this.m_relativeHomeDirectory);
        } else {
            ConfigurationTestUtils.setAbsoluteHomeDirectory((String)ConfigurationTestUtils.getDaemonEtcDirectory().getParentFile().getAbsolutePath());
        }
        ConfigurationTestUtils.setRrdBinary((String)this.m_rrdBinary);
        ConfigurationTestUtils.setRelativeRrdBaseDirectory((String)this.m_relativeRrdBaseDirectory);
        ConfigurationTestUtils.setRelativeImporterDirectory((String)m_relativeImporterDirectory);
        ConfigurationTestUtils.setRelativeForeignSourceDirectory((String)m_relativeForeignSourceDirectory);
    }

    public String getRelativeHomeDirectory() {
        return this.m_relativeHomeDirectory;
    }

    public void setRelativeHomeDirectory(String relativeHomeDirectory) {
        this.m_relativeHomeDirectory = relativeHomeDirectory;
    }

    public String getRelativeRrdBaseDirectory() {
        return this.m_relativeRrdBaseDirectory;
    }

    public void setRelativeRrdBaseDirectory(String rrdBaseDirectory) {
        this.m_relativeRrdBaseDirectory = rrdBaseDirectory;
    }

    public String getRrdBinary() {
        return this.m_rrdBinary;
    }

    public void setRrdBinary(String rrdBinary) {
        this.m_rrdBinary = rrdBinary;
    }
}

