/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAnticipator
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(FileAnticipator.class);
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private List<File> m_expecting = new LinkedList<File>();
    private List<File> m_expectingPrefixes = new LinkedList<File>();
    private Map<File, List<String>> m_suffixesToExclude = new HashMap<File, List<String>>();
    private List<File> m_deleteMe = new LinkedList<File>();
    private File m_tempDir = null;
    private boolean m_initialized = false;

    public FileAnticipator() throws IOException {
        this(true);
    }

    public FileAnticipator(boolean initialize) throws IOException {
        if (initialize) {
            this.initialize();
        }
    }

    protected void finalize() throws Throwable {
        this.tearDown();
        super.finalize();
    }

    public void tearDown() {
        if (!this.isInitialized()) {
            return;
        }
        try {
            this.deleteExpected(true);
            ListIterator<File> i = this.m_deleteMe.listIterator(this.m_deleteMe.size());
            while (i.hasPrevious()) {
                File f = i.previous();
                if (!f.exists() || FileUtils.deleteQuietly((File)f)) continue;
                StringBuffer b = new StringBuffer();
                b.append("Could not delete " + f.getAbsolutePath() + ": is it a non-empty directory?");
                b.append("\nDirectory listing:");
                if (f.listFiles() != null) {
                    for (File file : f.listFiles()) {
                        b.append("\n\t");
                        b.append(file.getName());
                    }
                }
                FileAnticipator.fail((String)b.toString());
            }
            if (this.m_tempDir != null) {
                FileAnticipator.assertFalse((String)(this.m_tempDir + " exists"), (boolean)this.m_tempDir.exists());
            }
        }
        catch (Throwable t) {
            if (this.m_tempDir != null && this.m_tempDir.exists()) {
                try {
                    FileUtils.forceDelete((File)this.m_tempDir);
                    return;
                }
                catch (IOException innerThrowable) {
                    LOG.warn("an error occurred while forcibly removing temporary directory {}", (Object)this.m_tempDir, (Object)innerThrowable);
                }
            } else {
                LOG.warn("does not exist? {}", (Object)this.m_tempDir, (Object)t);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public void initialize() throws IOException {
        if (this.m_initialized) {
            return;
        }
        String systemTempDir = System.getProperty(JAVA_IO_TMPDIR);
        FileAnticipator.assertNotNull((String)"java.io.tmpdir system property is not set, but must be", (Object)systemTempDir);
        File f = new File(systemTempDir);
        FileAnticipator.assertTrue((String)("path specified in system property java.io.tmpdir, \"" + systemTempDir + "\" is not a directory"), (boolean)f.isDirectory());
        String tempFileName = "FileAnticipator_temp_" + System.currentTimeMillis() + "_" + FileAnticipator.generateRandomHexString(8);
        this.m_tempDir = this.internalTempDir(f, tempFileName);
        this.m_initialized = true;
    }

    protected static String generateRandomHexString(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length argument is " + length + " and cannot be below zero");
        }
        Random random = new Random();
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        StringBuffer sb = new StringBuffer();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public File getTempDir() {
        this.assertInitialized();
        return this.m_tempDir;
    }

    private void assertInitialized() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("not initialized");
        }
    }

    public File tempFile(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        this.assertInitialized();
        return this.internalTempFile(this.m_tempDir, name);
    }

    public File tempFile(File parent, String name) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("parent argument cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        this.assertInitialized();
        return this.internalTempFile(parent, name);
    }

    public File tempFile(String name, String contents) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        if (contents == null) {
            throw new IllegalArgumentException("contents argument cannot be null");
        }
        this.assertInitialized();
        return this.internalTempFile(this.m_tempDir, name, contents);
    }

    public File tempFile(File parent, String name, String contents) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("parent argument cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        if (contents == null) {
            throw new IllegalArgumentException("contents argument cannot be null");
        }
        this.assertInitialized();
        return this.internalTempFile(parent, name, contents);
    }

    private File internalTempDir(File parent, String name) throws IOException {
        File f = new File(parent, name);
        FileAnticipator.assertFalse((String)("temporary directory exists but it shouldn't: " + f.getAbsolutePath()), (boolean)f.exists());
        FileAnticipator.assertTrue((String)("could not create temporary directory: " + f.getAbsolutePath()), (boolean)f.mkdir());
        this.m_deleteMe.add(f);
        return f;
    }

    private File internalTempFile(File parent, String name) throws IOException {
        File f = new File(parent, name);
        FileAnticipator.assertFalse((String)("temporary file exists but it shouldn't: " + f.getAbsolutePath()), (boolean)f.exists());
        FileAnticipator.assertTrue((String)("createNewFile: " + f.getAbsolutePath()), (boolean)f.createNewFile());
        this.m_deleteMe.add(f);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File internalTempFile(File parent, String name, String contents) throws IOException {
        File f = this.internalTempFile(parent, name);
        FileOutputStream out = null;
        OutputStreamWriter writer = null;
        PrintWriter printWriter = null;
        try {
            out = new FileOutputStream(f);
            writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
            printWriter = new PrintWriter(writer);
            printWriter.print(contents);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(printWriter);
            IOUtils.closeQuietly(writer);
            IOUtils.closeQuietly((OutputStream)out);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)printWriter);
        IOUtils.closeQuietly((Writer)writer);
        IOUtils.closeQuietly((OutputStream)out);
        return f;
    }

    public File tempDir(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        return this.tempDir(this.m_tempDir, name);
    }

    public File tempDir(File parent, String name) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("parent argument cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        this.assertInitialized();
        return this.internalTempDir(parent, name);
    }

    public File expecting(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        this.assertInitialized();
        return this.internalExpecting(this.m_tempDir, name);
    }

    public File expecting(File parent, String name) {
        if (parent == null) {
            throw new IllegalArgumentException("parent argument cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        this.assertInitialized();
        return this.internalExpecting(parent, name);
    }

    public void expectingFileWithPrefix(File parent, String prefix, String ... suffixesToExclude) {
        if (parent == null) {
            throw new IllegalArgumentException("parent argument cannot be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("prefix argument cannot be null");
        }
        this.assertInitialized();
        this.internalExpectingFileWithPrefix(parent, prefix, suffixesToExclude);
    }

    private File internalExpecting(File parent, String name) {
        File f = new File(parent, name);
        this.m_expecting.add(f);
        return f;
    }

    private File internalExpectingFileWithPrefix(File parent, String prefix, String[] suffixesToExclude) {
        File f = new File(parent, prefix);
        this.m_expectingPrefixes.add(f);
        this.m_suffixesToExclude.put(f, Arrays.asList(suffixesToExclude));
        return f;
    }

    public void deleteExpected() {
        this.deleteExpected(false);
    }

    public void deleteExpected(boolean ignoreNonExistantFiles) {
        File f;
        this.assertInitialized();
        Collections.sort(this.m_expecting, new Comparator<File>(){

            @Override
            public int compare(File a, File b) {
                return a.getAbsolutePath().compareTo(b.getAbsolutePath());
            }
        });
        ArrayList<String> errors = new ArrayList<String>();
        ListIterator<File> i = this.m_expectingPrefixes.listIterator(this.m_expectingPrefixes.size());
        while (i.hasPrevious()) {
            f = i.previous();
            List<Path> matches = this.getMatches(f);
            if (matches.size() < 1 && !ignoreNonExistantFiles) {
                errors.add("Expected prefix that needs to be deleted does not exist: " + f.getAbsolutePath());
            }
            for (Path match : matches) {
                if (match.toFile().delete()) continue;
                errors.add("Could not delete expected file: " + match.toAbsolutePath());
            }
            i.remove();
        }
        i = this.m_expecting.listIterator(this.m_expecting.size());
        while (i.hasPrevious()) {
            f = i.previous();
            if (!f.exists()) {
                if (!ignoreNonExistantFiles) {
                    errors.add("Expected file that needs to be deleted does not exist: " + f.getAbsolutePath());
                }
            } else if (f.isDirectory()) {
                String[] files = f.list();
                if (files.length > 0) {
                    StringBuffer fileList = new StringBuffer("{ ");
                    fileList.append(files[0]);
                    for (int j = 1; j < files.length; ++j) {
                        fileList.append(", ").append(files[j]);
                    }
                    fileList.append(" }");
                    errors.add("Directory was not empty: " + f.getAbsolutePath() + ": " + fileList.toString());
                } else if (!f.delete()) {
                    errors.add("Could not delete directory: " + f.getAbsolutePath());
                }
            } else if (!f.delete()) {
                errors.add("Could not delete expected file: " + f.getAbsolutePath());
            }
            i.remove();
        }
        FileAnticipator.assertEquals((String)"No expected files left over", (long)this.m_expecting.size(), (long)0L);
        if (errors.size() > 0) {
            StringBuffer errorString = new StringBuffer();
            for (String error : errors) {
                errorString.append(error).append("\n");
            }
            FileAnticipator.fail((String)("Errors occurred inside FileAnticipator:\n" + errorString.toString().trim()));
        }
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public boolean foundExpected() {
        LOG.debug("checking for {} expected files...", (Object)(this.m_expecting.size() + this.m_expectingPrefixes.size()));
        for (File expected : this.m_expecting) {
            if (expected.exists()) continue;
            return false;
        }
        for (File expected : this.m_expectingPrefixes) {
            if (this.getMatches(expected).size() >= 1) continue;
            return false;
        }
        return true;
    }

    private List<Path> getMatches(File expectedFileWithPrefix) {
        List matches;
        LinkedList<Path> filteredMatches = new LinkedList<Path>();
        String prefix = expectedFileWithPrefix.getName();
        File parent = expectedFileWithPrefix.getParentFile();
        try {
            matches = Files.list(parent.toPath()).filter(p -> p.getFileName().toString().startsWith(prefix)).collect(Collectors.toList());
        }
        catch (IOException e) {
            return filteredMatches;
        }
        List<String> suffixesToExclude = this.m_suffixesToExclude.get(expectedFileWithPrefix);
        if (suffixesToExclude == null) {
            suffixesToExclude = new ArrayList<String>(0);
        }
        for (Path match : matches) {
            boolean shouldAdd = true;
            for (String suffix : suffixesToExclude) {
                if (!match.getFileName().toString().endsWith(suffix)) continue;
                shouldAdd = false;
                break;
            }
            if (!shouldAdd) continue;
            filteredMatches.add(match);
        }
        return filteredMatches;
    }
}

