/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

public class ThrowableAnticipator
extends Assert {
    public static final String IGNORE_MESSAGE = "*** ThrowableAnticipator ignore Throwable.getMessage() ***";
    private List<Throwable> m_anticipated;
    private List<Throwable> m_unanticipated;
    private boolean m_failFast;

    public ThrowableAnticipator() {
        this(true);
    }

    public ThrowableAnticipator(boolean failFast) {
        this.init();
        this.m_failFast = failFast;
    }

    private void init() {
        this.m_anticipated = new ArrayList<Throwable>();
        this.m_unanticipated = new ArrayList<Throwable>();
        this.m_failFast = true;
    }

    public void anticipate(Throwable t) {
        this.m_anticipated.add(t);
    }

    public void throwableReceived(Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException("Throwable must not be null");
        }
        boolean foundMatch = false;
        for (Throwable our : this.m_anticipated) {
            if (!t.getClass().isAssignableFrom(our.getClass()) || !IGNORE_MESSAGE.equals(our.getMessage()) && (t.getMessage() != null || our.getMessage() != null) && (t.getMessage() == null || !t.getMessage().equals(our.getMessage()))) continue;
            this.m_anticipated.remove(our);
            foundMatch = true;
            break;
        }
        if (!foundMatch) {
            this.throwableFailedMatch(t);
        }
    }

    private void throwableFailedMatch(Throwable t) {
        if (this.m_failFast) {
            this.fail("Received an unexpected Exception: " + t.toString(), t);
        } else {
            this.m_unanticipated.add(t);
        }
    }

    public void setFailFast(boolean failFast) throws AssertionFailedError {
        if (!this.m_failFast && failFast && this.m_unanticipated.size() > 0) {
            ThrowableAnticipator.fail((String)("failFast is being changed from false to true and unanticipated exceptions have been received:\n" + this.listUnanticipated()));
        }
        this.m_failFast = failFast;
    }

    public boolean isFailFast() {
        return this.m_failFast;
    }

    public void reset() {
        this.init();
    }

    public void verifyAnticipated() throws AssertionFailedError {
        StringBuffer error = new StringBuffer();
        if (this.m_anticipated.size() != 0) {
            error.append("Anticipated list is non-zero (has " + this.m_anticipated.size() + " entries):\n");
            error.append(this.listAnticipated());
        }
        if (this.m_unanticipated.size() != 0) {
            error.append("Unanticipated list is non-zero (has " + this.m_unanticipated.size() + " entries):\n");
            error.append(this.listUnanticipated());
        }
        if (error.length() > 0) {
            ThrowableAnticipator.fail((String)error.toString());
        }
    }

    private StringBuffer listAnticipated() {
        return this.makeList(this.m_anticipated, "Anticipated but unreceived Throwable: ", "\n");
    }

    private StringBuffer listUnanticipated() {
        return this.makeList(this.m_unanticipated, "Unanticipated Throwable: ", "\n");
    }

    private StringBuffer makeList(List<Throwable> list, String before, String after) {
        StringBuffer output = new StringBuffer();
        for (Throwable t : list) {
            output.append(before + t.toString() + after);
            StringWriter w = new StringWriter();
            PrintWriter pw = new PrintWriter(w);
            t.printStackTrace(pw);
            output.append(w.getBuffer());
            output.append("\n");
        }
        return output;
    }

    public void fail(String message, Throwable t) throws AssertionFailedError {
        AssertionFailedError error = new AssertionFailedError(message);
        error.initCause(t);
        throw error;
    }
}

