/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.test;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.test.ConfigurationTestUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DaoTestConfigBean
implements InitializingBean {
    private String m_relativeHomeDirectory = null;
    private final String m_absoluteHomeDirectory;
    private String m_rrdBinary = "/bin/true";
    private String m_relativeRrdBaseDirectory = "target/test/opennms-home/share/rrd";
    private final String m_relativeImporterDirectory = "target/test/opennms-home/etc/imports";
    private final String m_relativeForeignSourceDirectory = "target/test/opennms-home/etc/foreign-sources";

    public DaoTestConfigBean() {
        this.m_absoluteHomeDirectory = null;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_relativeHomeDirectory == null || this.m_absoluteHomeDirectory == null ? 1 : 0) != 0, (String)"Only one of the properties relativeHomeDirectory and absoluteHomeDirectory can be set.");
        if (System.getProperty("org.opennms.netmgt.icmp.pingerClass") == null) {
            System.setProperty("org.opennms.netmgt.icmp.pingerClass", "org.opennms.netmgt.icmp.jna.JnaPinger");
        }
        Properties opennmsProperties = new Properties();
        try {
            opennmsProperties.load(ConfigurationTestUtils.getInputStreamForConfigFile("opennms.properties"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Properties substitutions = new Properties();
        substitutions.setProperty("install.share.dir", "target/test/share");
        substitutions.setProperty("install.webapplogs.dir", "target/test/logs/webapp");
        for (Map.Entry<Object, Object> entry : opennmsProperties.entrySet()) {
            System.setProperty((String)entry.getKey(), PropertiesUtils.substitute((String)((String)entry.getValue()), (Properties[])new Properties[]{substitutions}));
        }
        if (this.m_absoluteHomeDirectory != null) {
            ConfigurationTestUtils.setAbsoluteHomeDirectory(this.m_absoluteHomeDirectory);
        } else if (this.m_relativeHomeDirectory != null) {
            ConfigurationTestUtils.setRelativeHomeDirectory(this.m_relativeHomeDirectory);
        } else {
            ConfigurationTestUtils.setAbsoluteHomeDirectory(ConfigurationTestUtils.getDaemonEtcDirectory().getParentFile().getAbsolutePath());
        }
        System.setProperty("snmp4j.LogFactory", "org.snmp4j.log.NoLogger");
        ConfigurationTestUtils.setRrdBinary(this.m_rrdBinary);
        ConfigurationTestUtils.setRelativeRrdBaseDirectory(this.m_relativeRrdBaseDirectory);
        ConfigurationTestUtils.setRelativeImporterDirectory("target/test/opennms-home/etc/imports");
        ConfigurationTestUtils.setRelativeForeignSourceDirectory("target/test/opennms-home/etc/foreign-sources");
    }

    public String getRelativeHomeDirectory() {
        return this.m_relativeHomeDirectory;
    }

    public void setRelativeHomeDirectory(String relativeHomeDirectory) {
        this.m_relativeHomeDirectory = relativeHomeDirectory;
    }

    public String getRelativeRrdBaseDirectory() {
        return this.m_relativeRrdBaseDirectory;
    }

    public void setRelativeRrdBaseDirectory(String rrdBaseDirectory) {
        this.m_relativeRrdBaseDirectory = rrdBaseDirectory;
    }

    public String getRrdBinary() {
        return this.m_rrdBinary;
    }

    public void setRrdBinary(String rrdBinary) {
        this.m_rrdBinary = rrdBinary;
    }
}

