/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.tags;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;
import java.util.Optional;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.opennms.core.time.CentralizedDateTimeFormat;

public class DateTimeTag
extends SimpleTagSupport {
    private Instant instant;

    public void doTag() throws IOException {
        String output = Optional.ofNullable(new CentralizedDateTimeFormat().format(this.instant, this.getZoneId())).orElse("");
        this.getJspContext().getOut().write(output);
    }

    public void setInstant(Instant instant) {
        this.instant = instant;
    }

    @Deprecated
    public void setDate(Date date) {
        if (date != null) {
            this.instant = date.toInstant();
        }
    }

    private ZoneId getZoneId() {
        ZoneId timeZoneId = (ZoneId)this.getJspContext().getAttribute("org.opennms.ui.timezoneid", 3);
        if (timeZoneId == null) {
            timeZoneId = ZoneId.systemDefault();
        }
        return timeZoneId;
    }
}

