/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.TrapdConfig;
import org.opennms.netmgt.config.trapd.Snmpv3User;
import org.opennms.netmgt.config.trapd.TrapdConfiguration;
import org.opennms.netmgt.snmp.SnmpV3User;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class TrapdConfigFactory
implements TrapdConfig {
    private static TrapdConfig m_singleton = null;
    private TrapdConfiguration m_config;
    private static boolean m_loaded = false;

    private TrapdConfigFactory(String configFile) throws IOException {
        this.m_config = (TrapdConfiguration)JaxbUtils.unmarshal(TrapdConfiguration.class, (Resource)new FileSystemResource(configFile));
    }

    public TrapdConfigFactory(InputStream stream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            this.m_config = (TrapdConfiguration)JaxbUtils.unmarshal(TrapdConfiguration.class, (Reader)reader);
        }
    }

    public static synchronized void init() throws IOException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.TRAPD_CONFIG_FILE_NAME);
        m_singleton = new TrapdConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException {
        m_singleton = null;
        m_loaded = false;
        TrapdConfigFactory.init();
    }

    public static synchronized TrapdConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(TrapdConfig config) {
        m_singleton = config;
        m_loaded = true;
    }

    @Override
    public synchronized String getSnmpTrapAddress() {
        return this.m_config.getSnmpTrapAddress();
    }

    @Override
    public synchronized int getSnmpTrapPort() {
        return this.m_config.getSnmpTrapPort();
    }

    @Override
    public synchronized boolean getNewSuspectOnTrap() {
        return this.m_config.getNewSuspectOnTrap();
    }

    @Override
    public synchronized List<SnmpV3User> getSnmpV3Users() {
        ArrayList<SnmpV3User> snmpUsers = new ArrayList<SnmpV3User>();
        for (Snmpv3User user : this.m_config.getSnmpv3UserCollection()) {
            snmpUsers.add(new SnmpV3User(user.getEngineId(), user.getSecurityName(), user.getAuthProtocol(), user.getAuthPassphrase(), user.getPrivacyProtocol(), user.getPrivacyPassphrase()));
        }
        return snmpUsers;
    }

    @Override
    public boolean isIncludeRawMessage() {
        return this.m_config.isIncludeRawMessage();
    }

    @Override
    public int getNumThreads() {
        if (this.m_config.getThreads() <= 0) {
            return Runtime.getRuntime().availableProcessors() * 2;
        }
        return this.m_config.getThreads();
    }

    @Override
    public int getQueueSize() {
        return this.m_config.getQueueSize();
    }

    @Override
    public int getBatchSize() {
        return this.m_config.getBatchSize();
    }

    @Override
    public int getBatchIntervalMs() {
        return this.m_config.getBatchInterval();
    }

    @Override
    public boolean shouldUseAddressFromVarbind() {
        return this.m_config.shouldUseAddressFromVarbind();
    }

    @Override
    public void update(TrapdConfig config) {
        this.m_config.setSnmpTrapAddress(config.getSnmpTrapAddress());
        this.m_config.setSnmpTrapPort(config.getSnmpTrapPort());
        this.m_config.setNewSuspectOnTrap(config.getNewSuspectOnTrap());
        this.m_config.setQueueSize(config.getQueueSize());
        this.m_config.setBatchSize(config.getBatchSize());
        this.m_config.setBatchInterval(config.getBatchIntervalMs());
        this.m_config.setThreads(config.getNumThreads());
        this.m_config.setIncludeRawMessage(config.isIncludeRawMessage());
        List snmpv3Users = config.getSnmpV3Users().stream().map(u -> {
            Snmpv3User newUser = new Snmpv3User();
            newUser.setEngineId(u.getEngineId());
            newUser.setSecurityName(u.getSecurityName());
            newUser.setSecurityLevel(u.getSecurityLevel());
            newUser.setAuthProtocol(u.getAuthProtocol());
            newUser.setAuthPassphrase(u.getAuthPassPhrase());
            newUser.setPrivacyProtocol(u.getPrivProtocol());
            newUser.setPrivacyPassphrase(u.getPrivPassPhrase());
            return newUser;
        }).collect(Collectors.toList());
        this.m_config.setSnmpv3User(snmpv3Users);
    }

    public TrapdConfiguration getConfig() {
        return this.m_config;
    }
}

