/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.Querier;
import org.opennms.core.utils.RowProcessor;
import org.opennms.core.utils.SingleResultQuerier;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.NotifdConfigManager;
import org.opennms.netmgt.config.notifications.Header;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.config.notifications.Notifications;
import org.opennms.netmgt.config.notifications.Parameter;
import org.opennms.netmgt.events.api.EventConstants;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.api.FilterParseException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Tticket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class NotificationManager {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationManager.class);
    public Notifications m_notifications;
    private long m_notifTasksQueued = 0L;
    private long m_binaryNoticesAttempted = 0L;
    private long m_javaNoticesAttempted = 0L;
    private long m_binaryNoticesSucceeded = 0L;
    private long m_javaNoticesSucceeded = 0L;
    private long m_binaryNoticesFailed = 0L;
    private long m_javaNoticesFailed = 0L;
    private long m_binaryNoticesInterrupted = 0L;
    private long m_javaNoticesInterrupted = 0L;
    private long m_unknownNoticesInterrupted = 0L;
    private Header oldHeader;
    public static final String PARAM_TYPE = "-t";
    public static final String PARAM_DESTINATION = "-d";
    public static final String PARAM_TEXT_MSG = "-tm";
    public static final String PARAM_NUM_MSG = "-nm";
    public static final String PARAM_RESPONSE = "-r";
    public static final String PARAM_NODE = "-nodeid";
    public static final String PARAM_INTERFACE = "-interface";
    public static final String PARAM_SERVICE = "-service";
    public static final String PARAM_SUBJECT = "-subject";
    public static final String PARAM_EMAIL = "-email";
    public static final String PARAM_PAGER_EMAIL = "-pemail";
    public static final String PARAM_XMPP_ADDRESS = "-xmpp";
    public static final String PARAM_TEXT_PAGER_PIN = "-tp";
    public static final String PARAM_NUM_PAGER_PIN = "-np";
    public static final String PARAM_WORK_PHONE = "-wphone";
    public static final String PARAM_HOME_PHONE = "-hphone";
    public static final String PARAM_MOBILE_PHONE = "-mphone";
    public static final String PARAM_TUI_PIN = "-tuipin";
    public static final String PARAM_MICROBLOG_USERNAME = "-ublog";
    NotifdConfigManager m_configManager;
    private DataSource m_dataSource;

    public static String expandNotifParms(String input, Map<String, String> paramMap) {
        String noticeId;
        if (input.contains("%noticeid%") && (noticeId = paramMap.get("noticeid")) != null) {
            return input.replaceAll("%noticeid%", noticeId);
        }
        return input;
    }

    protected NotificationManager(NotifdConfigManager configManager, DataSource dcf) {
        this.m_configManager = configManager;
        this.m_dataSource = dcf;
    }

    @Deprecated
    public synchronized void parseXML(Reader reader) {
        this.m_notifications = (Notifications)JaxbUtils.unmarshal(Notifications.class, (Reader)reader, (boolean)true);
        this.oldHeader = this.m_notifications.getHeader();
    }

    public synchronized void parseXML(InputStream stream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            this.m_notifications = (Notifications)JaxbUtils.unmarshal(Notifications.class, (Reader)reader, (boolean)true);
        }
        this.oldHeader = this.m_notifications.getHeader();
    }

    public boolean hasUei(String uei) throws IOException {
        this.update();
        for (Notification notif : this.m_notifications.getNotifications()) {
            if (uei.equals(notif.getUei()) || "MATCH-ANY-UEI".equals(notif.getUei())) {
                return true;
            }
            if (notif.getUei().charAt(0) != '~' || !uei.matches(notif.getUei().substring(1))) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Notification[] getNotifForEvent(Event event) throws IOException {
        this.update();
        ArrayList<Notification> notifList = new ArrayList<Notification>();
        boolean matchAll = this.getConfigManager().getNotificationMatch();
        if (event == null) {
            LOG.warn("unable to get notification for null event!");
            return null;
        }
        if (event.getLogmsg() != null && !event.getLogmsg().getNotify().booleanValue()) {
            LOG.debug("Event {} is configured to suppress notifications.", (Object)event.getUei());
            return null;
        }
        for (Notification curNotif : this.m_notifications.getNotifications()) {
            block13: {
                LOG.trace("Checking notification {} against event {} with UEI {}", new Object[]{curNotif.getUei(), event.getDbid(), event.getUei()});
                if (event.getUei().equals(curNotif.getUei()) || "MATCH-ANY-UEI".equals(curNotif.getUei())) {
                    LOG.debug("Exact match using notification UEI {} for event UEI: {}", (Object)curNotif.getUei(), (Object)event.getUei());
                } else {
                    if (curNotif.getUei().charAt(0) == '~') {
                        if (event.getUei().matches(curNotif.getUei().substring(1))) {
                            LOG.debug("Regex hit using notification UEI {} for event UEI: {}", (Object)curNotif.getUei(), (Object)event.getUei());
                            break block13;
                        } else {
                            LOG.trace("Notification regex {} failed to match event UEI: {}", (Object)event.getUei(), (Object)curNotif.getUei());
                            continue;
                        }
                    }
                    LOG.debug("Notification UEI {} did not match UEI of event {}: {}", new Object[]{curNotif.getUei(), event.getDbid(), event.getUei()});
                    continue;
                }
            }
            LOG.trace("Checking event severity: {} against notification severity: {}", curNotif.getEventSeverity().orElse(null), (Object)event.getSeverity());
            if (curNotif.getEventSeverity().isPresent() && !event.getSeverity().toLowerCase().matches(((String)curNotif.getEventSeverity().get()).toLowerCase())) {
                LOG.debug("Event severity: {} did not match notification severity: {}", curNotif.getEventSeverity().orElse(null), (Object)event.getSeverity());
                continue;
            }
            if (curNotif.getStatus().equals("on")) {
                if (this.nodeInterfaceServiceValid(curNotif, event)) {
                    boolean parmsmatched = this.getConfigManager().matchNotificationParameters(event, curNotif);
                    if (!parmsmatched) {
                        LOG.debug("Event {} did not match parameters for notice {}", (Object)event.getUei(), (Object)curNotif.getName());
                        continue;
                    }
                    notifList.add(curNotif);
                    LOG.debug("Event {} matched notice {}", (Object)event.getUei(), (Object)curNotif.getName());
                    if (matchAll) continue;
                    break;
                }
                LOG.debug("Node/interface/service combination in the event was invalid");
                continue;
            }
            LOG.debug("Current notification with UEI {} is turned off.", (Object)curNotif.getUei());
        }
        if (!notifList.isEmpty()) {
            return notifList.toArray(new Notification[0]);
        }
        return null;
    }

    protected NotifdConfigManager getConfigManager() {
        return this.m_configManager;
    }

    protected boolean nodeInterfaceServiceValid(Notification notif, Event event) {
        Assert.notNull((Object)notif, (String)"notif argument must not be null");
        Assert.notNull((Object)event, (String)"event argument must not be null");
        Assert.notNull((Object)notif.getRule(), (String)"getRule() on notif argument must not return null");
        if (event.getNodeid() == 0L && event.getInterface() == null && event.getService() == null) {
            if ("MATCH-ANY-UEI".equals(notif.getUei())) {
                return "ipaddr != '0.0.0.0'".equals(notif.getRule().toLowerCase()) || "ipaddr iplike *.*.*.*".equals(notif.getRule().toLowerCase());
            }
            return true;
        }
        StringBuilder constraints = new StringBuilder();
        if (event.getNodeid() != 0L) {
            constraints.append(" & (nodeId == " + event.getNodeid() + ")");
        }
        if (event.getInterface() != null && !"0.0.0.0".equals(event.getInterface())) {
            constraints.append(" & (ipAddr == '" + event.getInterface() + "')");
            if (event.getService() != null) {
                constraints.append(" & (serviceName == '" + event.getService() + "')");
            }
        }
        String rule = "((" + notif.getRule() + ")" + constraints + ")";
        return this.isRuleMatchingFilter(notif, rule);
    }

    private boolean isRuleMatchingFilter(Notification notif, String rule) {
        try {
            return FilterDaoFactory.getInstance().isRuleMatching(rule);
        }
        catch (FilterParseException e) {
            LOG.error("Invalid filter rule for notification {}: {}", new Object[]{notif.getName(), notif.getRule(), e});
            throw e;
        }
    }

    private Connection getConnection() throws SQLException {
        return this.m_dataSource.getConnection();
    }

    public int getNoticeId() throws SQLException, IOException {
        return this.getNxtId(this.m_configManager.getNextNotifIdSql());
    }

    public int getUserNotifId() throws SQLException, IOException {
        return this.getNxtId(this.m_configManager.getNextUserNotifIdSql());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNxtId(String sql) throws SQLException {
        int id = 0;
        Connection connection = null;
        try {
            connection = this.getConnection();
            Statement stmt = connection.createStatement();
            ResultSet results = stmt.executeQuery(sql);
            results.next();
            id = results.getInt(1);
            stmt.close();
            results.close();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noticeOutstanding(int noticeId) throws IOException {
        boolean outstanding = false;
        Connection connection = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            connection = this.getConnection();
            d.watch((Object)connection);
            PreparedStatement statement = connection.prepareStatement(this.getConfigManager().getConfiguration().getOutstandingNoticesSql());
            d.watch((Object)statement);
            statement.setInt(1, noticeId);
            ResultSet results = statement.executeQuery();
            d.watch((Object)results);
            int count = 0;
            while (results.next()) {
                ++count;
            }
            if (count == 0) {
                outstanding = true;
            }
        }
        catch (SQLException e) {
            LOG.error("Error getting notice status", (Throwable)e);
        }
        finally {
            d.cleanUp();
        }
        return outstanding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Integer> acknowledgeNotice(Event event, String uei, String[] matchList) throws SQLException, IOException {
        List<Integer> notifIDs = new LinkedList<Integer>();
        DBUtils dbUtils = new DBUtils(this.getClass());
        try {
            int i;
            boolean matchParameters = false;
            for (int i2 = 0; i2 < matchList.length; ++i2) {
                if (!matchList[i2].startsWith("parm[")) continue;
                matchParameters = true;
                break;
            }
            LinkedHashMap<String, String> eventParametersToMatch = new LinkedHashMap<String, String>();
            StringBuilder sql = new StringBuilder("SELECT n.eventid FROM notifications n ");
            if (matchParameters) {
                sql.append("INNER JOIN events as e on e.eventid = n.eventid ");
                for (i = 0; i < matchList.length; ++i) {
                    if (!matchList[i].startsWith("parm[")) continue;
                    if (NotificationManager.appendParameterNameAndValue(matchList[i], event, eventParametersToMatch)) {
                        sql.append(String.format("INNER JOIN event_parameters as ep%d on ep%d.eventid = n.eventid and ep%d.name=? and ep%d.value=? ", i, i, i, i));
                        continue;
                    }
                    LOG.warn("No parameter matching {} was found on {}. No notices with UEI {} will be acknowledged.", new Object[]{matchList[i], event, uei});
                    List<Integer> list = Collections.emptyList();
                    return list;
                }
                LOG.debug("Matching notices with UEI {} against event parameters: {}", (Object)uei, eventParametersToMatch);
            }
            sql.append("WHERE n.eventuei=? ");
            for (i = 0; i < matchList.length; ++i) {
                if (matchList[i].startsWith("parm[")) continue;
                sql.append("AND n.").append(matchList[i]).append("=? ");
            }
            sql.append("ORDER BY eventid desc limit 1");
            Connection connection = this.getConnection();
            dbUtils.watch((Object)connection);
            PreparedStatement statement = connection.prepareStatement(sql.toString());
            dbUtils.watch((Object)statement);
            int offset = 1;
            for (Map.Entry eventParameterToMatch : eventParametersToMatch.entrySet()) {
                statement.setString(offset++, (String)eventParameterToMatch.getKey());
                statement.setString(offset++, (String)eventParameterToMatch.getValue());
            }
            statement.setString(offset++, uei);
            for (int i3 = 0; i3 < matchList.length; ++i3) {
                if (matchList[i3].equals("nodeid")) {
                    statement.setLong(offset++, event.getNodeid());
                    continue;
                }
                if (matchList[i3].equals("interfaceid")) {
                    statement.setString(offset++, event.getInterface());
                    continue;
                }
                if (matchList[i3].equals("serviceid")) {
                    statement.setInt(offset++, this.getServiceId(event.getService()));
                    continue;
                }
                if (matchList[i3].startsWith("parm[")) continue;
                LOG.warn("Unknown match statement {} for UEI {}.", (Object)matchList[i3], (Object)uei);
            }
            ResultSet results = statement.executeQuery();
            dbUtils.watch((Object)results);
            if (results != null && results.next()) {
                int eventID = results.getInt(1);
                notifIDs = this.doAcknowledgeNotificationsFromEvent(connection, dbUtils, eventID);
            } else {
                LOG.debug("No matching DOWN eventID found");
            }
        }
        finally {
            dbUtils.cleanUp();
        }
        return notifIDs;
    }

    private static boolean appendParameterNameAndValue(String match, Event event, Map<String, String> eventParametersToMatch) {
        String key = null;
        String param = null;
        String value = null;
        try {
            key = match.substring(match.indexOf(91) + 1, match.indexOf(93));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (key != null) {
            int numkey = 0;
            if (key.startsWith("#")) {
                try {
                    numkey = Integer.parseInt(key.substring(1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int idx = 1;
            for (Parm p : event.getParmCollection()) {
                if (numkey > 0) {
                    if (numkey == idx) {
                        param = p.getParmName();
                        value = p.getValue().getContent();
                    }
                } else if (p.getParmName().equalsIgnoreCase(key)) {
                    param = p.getParmName();
                    value = p.getValue().getContent();
                }
                ++idx;
            }
        }
        if (param == null || value == null) {
            return false;
        }
        eventParametersToMatch.put(param, value);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Integer> acknowledgeNoticeBasedOnAlarms(Event event) throws SQLException, IOException {
        TreeSet<Integer> notifIDs = new TreeSet<Integer>();
        if (event.getAlarmData() == null || event.getAlarmData().getAlarmType() != 2) {
            return notifIDs;
        }
        DBUtils dbUtils = new DBUtils(this.getClass());
        try {
            Connection connection = this.getConnection();
            dbUtils.watch((Object)connection);
            PreparedStatement statement = connection.prepareStatement("SELECT e.eventId FROM events e, alarms a WHERE e.alarmid = a.alarmid AND a.reductionkey= ?");
            dbUtils.watch((Object)statement);
            String resolvingKey = event.getAlarmData().getClearKey() == null ? event.getAlarmData().getReductionKey() : event.getAlarmData().getClearKey();
            statement.setString(1, resolvingKey);
            ResultSet results = statement.executeQuery();
            dbUtils.watch((Object)results);
            while (results.next()) {
                int eventID = results.getInt(1);
                notifIDs.addAll(this.doAcknowledgeNotificationsFromEvent(connection, dbUtils, eventID));
            }
        }
        finally {
            dbUtils.cleanUp();
        }
        return notifIDs;
    }

    private List<Integer> doAcknowledgeNotificationsFromEvent(Connection connection, DBUtils dbUtils, int eventID) throws SQLException, IOException {
        LinkedList<Integer> notifIDs = new LinkedList<Integer>();
        LOG.debug("EventID for notice(s) to be acked: {}", (Object)eventID);
        PreparedStatement statement = connection.prepareStatement("SELECT notifyid, answeredby, respondtime FROM notifications WHERE eventID=?");
        dbUtils.watch((Object)statement);
        statement.setInt(1, eventID);
        ResultSet results = statement.executeQuery();
        boolean wasAcked = false;
        if (results != null) {
            dbUtils.watch((Object)results);
            while (results.next()) {
                int notifID = results.getInt(1);
                String ansBy = results.getString(2);
                Timestamp ts = results.getTimestamp(3);
                if (ansBy == null) {
                    ansBy = "auto-acknowledged";
                    ts = new Timestamp(new Date().getTime());
                } else {
                    if (ansBy.indexOf("auto-acknowledged") > -1) {
                        LOG.debug("Notice has previously been auto-acknowledged. Skipping...");
                        continue;
                    }
                    wasAcked = true;
                    ansBy = ansBy + "/auto-acknowledged";
                }
                LOG.debug("Matching DOWN notifyID = {}, was acked by user = {}, ansBy = {}", new Object[]{notifID, wasAcked, ansBy});
                PreparedStatement update = connection.prepareStatement(this.getConfigManager().getConfiguration().getAcknowledgeUpdateSql());
                dbUtils.watch((Object)update);
                update.setString(1, ansBy);
                update.setTimestamp(2, ts);
                update.setInt(3, notifID);
                update.executeUpdate();
                update.close();
                if (wasAcked) {
                    notifIDs.add(-1 * notifID);
                    continue;
                }
                notifIDs.add(notifID);
            }
        }
        return notifIDs;
    }

    public List<Integer> getActiveNodes() throws SQLException {
        final ArrayList<Integer> allNodes = new ArrayList<Integer>();
        Querier querier = new Querier(this.m_dataSource, "SELECT n.nodeid FROM node n WHERE n.nodetype != 'D' ORDER BY n.nodelabel", new RowProcessor(){

            public void processRow(ResultSet rs) throws SQLException {
                allNodes.add(rs.getInt(1));
            }
        });
        querier.execute(new Object[0]);
        return allNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServiceNoticeStatus(String nodeID, String ipaddr, String service) throws SQLException {
        String notify = "Y";
        String query = "SELECT notify FROM ifservices, ipInterface, node, service WHERE ifServices.ipInterfaceId = ipInterface.id AND ipInterface.nodeId = node.nodeId AND node.nodeid=? AND ipInterface.ipaddr=? AND ifservices.serviceid=service.serviceid AND service.servicename=?";
        Connection connection = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            connection = this.getConnection();
            d.watch((Object)connection);
            PreparedStatement statement = connection.prepareStatement("SELECT notify FROM ifservices, ipInterface, node, service WHERE ifServices.ipInterfaceId = ipInterface.id AND ipInterface.nodeId = node.nodeId AND node.nodeid=? AND ipInterface.ipaddr=? AND ifservices.serviceid=service.serviceid AND service.servicename=?");
            d.watch((Object)statement);
            statement.setInt(1, Integer.parseInt(nodeID));
            statement.setString(2, ipaddr);
            statement.setString(3, service);
            ResultSet rs = statement.executeQuery();
            d.watch((Object)rs);
            if (rs.next() && rs.getString("notify") != null && (notify = rs.getString("notify")) == null) {
                notify = "Y";
            }
            String string = notify;
            return string;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNoticeWithUserInfo(String userId, int noticeId, String media, String contactInfo, String autoNotify) throws SQLException, IOException {
        if (noticeId < 0) {
            return;
        }
        int userNotifId = this.getUserNotifId();
        LOG.debug("updating usersnotified: ID = {} User = {}, notice ID = {}, contactinfo = {}, media = {}, autoNotify = {}", new Object[]{autoNotify, userNotifId, userId, noticeId, contactInfo, media});
        Connection connection = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            connection = this.getConnection();
            d.watch((Object)connection);
            PreparedStatement insert = connection.prepareStatement("INSERT INTO usersNotified (id, userid, notifyid, notifytime, media, contactinfo, autonotify) values (?,?,?,?,?,?,?)");
            d.watch((Object)insert);
            insert.setInt(1, userNotifId);
            insert.setString(2, userId);
            insert.setInt(3, noticeId);
            insert.setTimestamp(4, new Timestamp(new Date().getTime()));
            insert.setString(5, media);
            insert.setString(6, contactInfo);
            insert.setString(7, autoNotify);
            insert.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertNotice(int notifyId, Map<String, String> params, String queueID, Notification notification) throws SQLException {
        Connection connection = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            connection = this.getConnection();
            d.watch((Object)connection);
            PreparedStatement statement = connection.prepareStatement("INSERT INTO notifications (textmsg, numericmsg, notifyid, pagetime, nodeid, interfaceid, serviceid, eventid, eventuei, subject, queueID, notifConfigName) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            d.watch((Object)statement);
            statement.setString(1, params.get(PARAM_TEXT_MSG));
            String numMsg = params.get(PARAM_NUM_MSG);
            if (numMsg != null && numMsg.length() > 256) {
                LOG.warn("numericmsg too long, it will be truncated");
                numMsg = numMsg.substring(0, 256);
            }
            statement.setString(2, numMsg);
            statement.setInt(3, notifyId);
            statement.setTimestamp(4, new Timestamp(new Date().getTime()));
            String node = params.get(PARAM_NODE);
            if (!(node == null || node.trim().equals("") || node.equalsIgnoreCase("null") || node.equalsIgnoreCase("%nodeid%"))) {
                statement.setInt(5, Integer.parseInt(node));
            } else {
                statement.setNull(5, 4);
            }
            String ipaddr = params.get(PARAM_INTERFACE);
            if (!(ipaddr == null || ipaddr.trim().equals("") || ipaddr.equalsIgnoreCase("null") || ipaddr.equalsIgnoreCase("%interface%"))) {
                statement.setString(6, ipaddr);
            } else {
                statement.setString(6, null);
            }
            String service = params.get(PARAM_SERVICE);
            if (!(service == null || service.trim().equals("") || service.equalsIgnoreCase("null") || service.equalsIgnoreCase("%service%"))) {
                statement.setInt(7, this.getServiceId(service));
            } else {
                statement.setNull(7, 4);
            }
            String eventID = params.get("eventID");
            if (!(eventID == null || eventID.trim().equals("") || eventID.trim().equals("0") || eventID.equalsIgnoreCase("null") || eventID.equalsIgnoreCase("%eventid%"))) {
                statement.setInt(8, Integer.parseInt(eventID));
            } else {
                statement.setNull(8, 4);
            }
            statement.setString(9, params.get("eventUEI"));
            statement.setString(10, params.get(PARAM_SUBJECT));
            statement.setString(11, queueID);
            statement.setString(12, notification.getName());
            statement.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getServiceId(String service) throws SQLException {
        int serviceID = 0;
        Connection connection = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            connection = this.getConnection();
            d.watch((Object)connection);
            PreparedStatement statement = connection.prepareStatement("SELECT serviceID from service where serviceName = ?");
            d.watch((Object)statement);
            statement.setString(1, service);
            ResultSet results = statement.executeQuery();
            d.watch((Object)results);
            if (!results.next()) {
                throw new SQLException("No serviceID found for service with serviceName: " + service);
            }
            int n = serviceID = results.getInt(1);
            return n;
        }
        finally {
            d.cleanUp();
        }
    }

    public Map<String, Notification> getNotifications() throws IOException {
        this.update();
        HashMap<String, Notification> newMap = new HashMap<String, Notification>();
        for (Notification notif : this.m_notifications.getNotifications()) {
            newMap.put(notif.getName(), notif);
        }
        return Collections.unmodifiableMap(newMap);
    }

    public List<String> getServiceNames() throws SQLException {
        final ArrayList<String> services = new ArrayList<String>();
        Querier querier = new Querier(this.m_dataSource, "SELECT servicename FROM service", new RowProcessor(){

            public void processRow(ResultSet rs) throws SQLException {
                services.add(rs.getString(1));
            }
        });
        querier.execute(new Object[0]);
        return services;
    }

    public Notification getNotification(String name) throws IOException {
        this.update();
        return this.getNotifications().get(name);
    }

    public List<String> getNotificationNames() throws IOException {
        this.update();
        ArrayList<String> notificationNames = new ArrayList<String>();
        for (Notification curNotif : this.m_notifications.getNotifications()) {
            notificationNames.add(curNotif.getName());
        }
        return notificationNames;
    }

    public synchronized void removeNotification(String name) throws IOException, ClassNotFoundException {
        this.m_notifications.removeNotification(this.getNotification(name));
        this.saveCurrent();
    }

    public synchronized void addNotification(Notification notice) throws IOException, ClassNotFoundException {
        this.m_notifications.removeNotification(this.getNotification(notice.getName()));
        this.m_notifications.addNotification(notice);
        this.saveCurrent();
    }

    public synchronized void replaceNotification(String oldName, Notification newNotice) throws IOException, ClassNotFoundException {
        Notification notice = this.getNotification(oldName);
        if (notice != null) {
            notice.setWriteable(newNotice.getWriteable());
            notice.setName(newNotice.getName());
            notice.setDescription((String)newNotice.getDescription().orElse(null));
            notice.setUei(newNotice.getUei());
            notice.setRule(newNotice.getRule());
            notice.setDestinationPath(newNotice.getDestinationPath());
            notice.setNoticeQueue((String)newNotice.getNoticeQueue().orElse(null));
            notice.setTextMessage(newNotice.getTextMessage());
            notice.setSubject((String)newNotice.getSubject().orElse(null));
            notice.setNumericMessage((String)newNotice.getNumericMessage().orElse(null));
            notice.setStatus(newNotice.getStatus());
            notice.setVarbind(newNotice.getVarbind());
            notice.getParameters().clear();
            for (Parameter parameter : newNotice.getParameters()) {
                Parameter newParam = new Parameter();
                newParam.setName(parameter.getName());
                newParam.setValue(parameter.getValue());
                notice.addParameter(newParam);
            }
            this.saveCurrent();
        } else {
            this.addNotification(newNotice);
        }
    }

    public synchronized void updateStatus(String name, String status) throws IOException, ClassNotFoundException {
        if (!"on".equals(status) && !"off".equals(status)) {
            throw new IllegalArgumentException("Status must be on|off, not " + status);
        }
        Notification notice = this.getNotification(name);
        notice.setStatus(status);
        this.saveCurrent();
    }

    public synchronized void saveCurrent() throws IOException, ClassNotFoundException {
        this.m_notifications.setHeader(this.rebuildHeader());
        String xmlString = JaxbUtils.marshal((Object)this.m_notifications);
        this.saveXML(xmlString);
        this.update();
    }

    protected abstract void saveXML(String var1) throws IOException;

    private Header rebuildHeader() {
        Header header = this.oldHeader;
        header.setCreated(EventConstants.formatToString((Date)new Date()));
        return header;
    }

    public abstract void update() throws IOException;

    public Map<String, String> rebuildParameterMap(final int notifId, final String resolutionPrefix, final boolean skipNumericPrefix) throws Exception {
        final HashMap<String, String> parmMap = new HashMap<String, String>();
        Querier querier = new Querier(this.m_dataSource, "select notifications.*, service.* from notifications left outer join service on notifications.serviceID = service.serviceID  where notifyId = ?"){

            public void processRow(ResultSet rs) throws SQLException {
                parmMap.put(NotificationManager.PARAM_TEXT_MSG, NotificationManager.expandNotifParms(resolutionPrefix, Collections.singletonMap("noticeid", String.valueOf(notifId))) + rs.getString("textMsg"));
                if (skipNumericPrefix) {
                    parmMap.put(NotificationManager.PARAM_NUM_MSG, rs.getString("numericMsg"));
                } else {
                    parmMap.put(NotificationManager.PARAM_NUM_MSG, NotificationManager.expandNotifParms(resolutionPrefix, Collections.singletonMap("noticeid", String.valueOf(notifId))) + rs.getString("numericMsg"));
                }
                parmMap.put(NotificationManager.PARAM_SUBJECT, NotificationManager.expandNotifParms(resolutionPrefix, Collections.singletonMap("noticeid", String.valueOf(notifId))) + rs.getString("subject"));
                parmMap.put(NotificationManager.PARAM_NODE, rs.getString("nodeID"));
                parmMap.put(NotificationManager.PARAM_INTERFACE, rs.getString("interfaceID"));
                parmMap.put(NotificationManager.PARAM_SERVICE, rs.getString("serviceName"));
                parmMap.put("noticeid", rs.getString("notifyID"));
                parmMap.put("eventID", rs.getString("eventID"));
                parmMap.put("eventUEI", rs.getString("eventUEI"));
                Notification notification = null;
                try {
                    notification = NotificationManager.this.getNotification(rs.getObject("notifConfigName").toString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (notification != null) {
                    NotificationManager.addNotificationParams(parmMap, notification);
                }
            }
        };
        querier.execute(new Object[]{notifId});
        return parmMap;
    }

    public static void addNotificationParams(Map<String, String> paramMap, Notification notification) {
        List parameters = notification.getParameters();
        for (Parameter parameter : parameters) {
            paramMap.put(parameter.getName(), parameter.getValue());
        }
    }

    public void forEachUserNotification(int notifId, RowProcessor rp) {
        Querier querier = new Querier(this.m_dataSource, "select * from usersNotified where notifyId = ? order by notifytime", rp);
        querier.execute(new Object[]{notifId});
    }

    public String getQueueForNotification(int notifId) {
        SingleResultQuerier querier = new SingleResultQuerier(this.m_dataSource, "select queueID from notifications where notifyId = ?");
        querier.execute(new Object[]{notifId});
        return (String)querier.getResult();
    }

    public Event getEvent(int eventid) {
        final Event event = new Event();
        Querier querier = new Querier(this.m_dataSource, "select * from events where eventid = ?", new RowProcessor(){

            public void processRow(ResultSet rs) throws SQLException {
                event.setDbid(Integer.valueOf(rs.getInt("eventid")));
                event.setUei(rs.getString("eventuei"));
                event.setNodeid(Long.valueOf(rs.getLong("nodeid")));
                event.setTime((Date)rs.getDate("eventtime"));
                event.setHost(rs.getString("eventhost"));
                event.setInterface(rs.getString("ipaddr"));
                event.setSnmphost(rs.getString("eventsnmphost"));
                event.setService(this.getServiceName(rs.getInt("serviceid")));
                event.setCreationTime((Date)rs.getDate("eventcreatetime"));
                event.setSeverity(rs.getString("eventseverity"));
                event.setPathoutage(rs.getString("eventpathoutage"));
                Tticket tticket = new Tticket();
                tticket.setContent(rs.getString("eventtticket"));
                tticket.setState(rs.getString("eventtticketstate"));
                event.setTticket(tticket);
                event.setSource(rs.getString("eventsource"));
            }

            private String getServiceName(int serviceid) {
                SingleResultQuerier querier = new SingleResultQuerier(NotificationManager.this.m_dataSource, "select servicename from service where serviceid = ?");
                return (String)querier.getResult();
            }
        });
        querier.execute(new Object[]{eventid});
        return event;
    }

    public void incrementTasksQueued() {
        ++this.m_notifTasksQueued;
    }

    public void incrementAttempted(boolean isBinary) {
        if (isBinary) {
            ++this.m_binaryNoticesAttempted;
        } else {
            ++this.m_javaNoticesAttempted;
        }
    }

    public void incrementSucceeded(boolean isBinary) {
        if (isBinary) {
            ++this.m_binaryNoticesSucceeded;
        } else {
            ++this.m_javaNoticesSucceeded;
        }
    }

    public void incrementFailed(boolean isBinary) {
        if (isBinary) {
            ++this.m_binaryNoticesFailed;
        } else {
            ++this.m_javaNoticesFailed;
        }
    }

    public void incrementInterrupted(boolean isBinary) {
        if (isBinary) {
            ++this.m_binaryNoticesInterrupted;
        } else {
            ++this.m_javaNoticesInterrupted;
        }
    }

    public void incrementUnknownInterrupted() {
        ++this.m_unknownNoticesInterrupted;
    }

    public long getNotificationTasksQueued() {
        return this.m_notifTasksQueued;
    }

    public long getBinaryNoticesAttempted() {
        return this.m_binaryNoticesAttempted;
    }

    public long getJavaNoticesAttempted() {
        return this.m_javaNoticesAttempted;
    }

    public long getBinaryNoticesSucceeded() {
        return this.m_binaryNoticesSucceeded;
    }

    public long getJavaNoticesSucceeded() {
        return this.m_javaNoticesSucceeded;
    }

    public long getBinaryNoticesFailed() {
        return this.m_binaryNoticesFailed;
    }

    public long getJavaNoticesFailed() {
        return this.m_javaNoticesFailed;
    }

    public long getBinaryNoticesInterrupted() {
        return this.m_binaryNoticesInterrupted;
    }

    public long getJavaNoticesInterrupted() {
        return this.m_javaNoticesInterrupted;
    }

    public long getUnknownNoticesInterrupted() {
        return this.m_unknownNoticesInterrupted;
    }
}

