/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.snmp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.model.HwEntityAttributeType;
import org.opennms.netmgt.model.OnmsHwEntity;
import org.opennms.netmgt.provision.snmp.EntityPhysicalTableRow;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityPhysicalTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(EntityPhysicalTableTracker.class);
    private List<OnmsHwEntity> entities = new ArrayList<OnmsHwEntity>();
    private Map<SnmpObjId, HwEntityAttributeType> vendorAttributes;
    private Map<String, String> replacementMap;

    public EntityPhysicalTableTracker(Map<SnmpObjId, HwEntityAttributeType> vendorAttributes, SnmpObjId[] oids, Map<String, String> replacementMap) {
        super(oids);
        this.vendorAttributes = vendorAttributes;
        this.replacementMap = replacementMap;
    }

    public EntityPhysicalTableTracker(RowCallback rowProcessor, SnmpObjId[] oids) {
        super(rowProcessor, oids);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        LOG.debug("createRowResult: processing instance {}", (Object)instance);
        return new EntityPhysicalTableRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        OnmsHwEntity entity = ((EntityPhysicalTableRow)row).getOnmsHwEntity(this.vendorAttributes, this.replacementMap);
        LOG.debug("rowCompleted: found entity {}, index: {}, parent: {}", new Object[]{entity.getEntPhysicalName(), entity.getEntPhysicalIndex(), entity.getEntPhysicalContainedIn()});
        if (entity.getEntPhysicalContainedIn() != null && entity.getEntPhysicalContainedIn() > 0) {
            for (OnmsHwEntity e : this.entities) {
                if (e.getEntPhysicalIndex() != entity.getEntPhysicalContainedIn()) continue;
                LOG.debug("rowCompleted: adding child index {} to parent index {}", (Object)entity.getEntPhysicalIndex(), (Object)e.getEntPhysicalIndex());
                e.addChildEntity(entity);
                break;
            }
        }
        this.entities.add(entity);
    }

    public OnmsHwEntity getRootEntity() {
        for (OnmsHwEntity entity : this.entities) {
            if (!entity.isRoot()) continue;
            return entity;
        }
        return null;
    }
}

