/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.snmp;

import java.util.Map;
import org.opennms.netmgt.model.HwEntityAttributeType;
import org.opennms.netmgt.model.OnmsHwEntity;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public class EntityPhysicalTableRow
extends SnmpRowResult {
    public static final SnmpObjId entPhysicalDescr = SnmpObjId.get((String)".1.3.6.1.2.1.47.1.1.1.1.2");
    public static final SnmpObjId entPhysicalVendorType = SnmpObjId.get((String)".1.3.6.1.2.1.47.1.1.1.1.3");
    public static final SnmpObjId entPhysicalContainedIn = SnmpObjId.get((String)".1.3.6.1.2.1.47.1.1.1.1.4");
    public static final SnmpObjId entPhysicalClass = SnmpObjId.get((String)".1.3.6.1.2.1.47.1.1.1.1.5");
    public static final SnmpObjId entPhysicalParentRelPos = SnmpObjId.get((String)".1.3.6.1.2.1.47.1.1.1.1.6");
    public static final SnmpObjId entPhysicalName = SnmpObjId.get((String)".1.3.6.1.2.1.47.1.1.1.1.7");
    public static final SnmpObjId entPhysicalHardwareRev = SnmpObjId.get((String)".1.3.6.1.2.1.47.1.1.1.1.8");
    public static final SnmpObjId entPhysicalFirmwareRev = SnmpObjId.get((String)".1.3.6.1.2.1.47.1.1.1.1.9");
    public static final SnmpObjId entPhysicalSoftwareRev = SnmpObjId.get((String)".1.3.6.1.2.1.47.1.1.1.1.10");
    public static final SnmpObjId entPhysicalSerialNum = SnmpObjId.get((String)".1.3.6.1.2.1.47.1.1.1.1.11");
    public static final SnmpObjId entPhysicalMfgName = SnmpObjId.get((String)".1.3.6.1.2.1.47.1.1.1.1.12");
    public static final SnmpObjId entPhysicalModelName = SnmpObjId.get((String)".1.3.6.1.2.1.47.1.1.1.1.13");
    public static final SnmpObjId entPhysicalAlias = SnmpObjId.get((String)".1.3.6.1.2.1.47.1.1.1.1.14");
    public static final SnmpObjId entPhysicalAssetID = SnmpObjId.get((String)".1.3.6.1.2.1.47.1.1.1.1.15");
    public static final SnmpObjId entPhysicalIsFRU = SnmpObjId.get((String)".1.3.6.1.2.1.47.1.1.1.1.16");
    public static final SnmpObjId entPhysicalMfgDate = SnmpObjId.get((String)".1.3.6.1.2.1.47.1.1.1.1.17");
    public static final SnmpObjId entPhysicalUris = SnmpObjId.get((String)".1.3.6.1.2.1.47.1.1.1.1.18");
    public static final SnmpObjId[] ELEMENTS = new SnmpObjId[]{entPhysicalDescr, entPhysicalVendorType, entPhysicalContainedIn, entPhysicalClass, entPhysicalParentRelPos, entPhysicalName, entPhysicalHardwareRev, entPhysicalFirmwareRev, entPhysicalSoftwareRev, entPhysicalSerialNum, entPhysicalMfgName, entPhysicalModelName, entPhysicalAlias, entPhysicalAssetID, entPhysicalIsFRU, entPhysicalMfgDate, entPhysicalUris};
    public static final String[] CLASSES = new String[]{null, "other", "unknown", "chassis", "backplane", "container", "powerSupply", "fan", "sensor", "module", "port", "stack", "cpu"};

    public EntityPhysicalTableRow(int columnCount, SnmpInstId instance) {
        super(columnCount, instance);
    }

    public int getEntPhysicalIndex() {
        return this.getInstance().getLastSubId();
    }

    public OnmsHwEntity getOnmsHwEntity(Map<SnmpObjId, HwEntityAttributeType> vendorAttributes, Map<String, String> replacementMap) {
        SnmpValue v = null;
        OnmsHwEntity entity = new OnmsHwEntity();
        entity.setEntPhysicalIndex(Integer.valueOf(this.getEntPhysicalIndex()));
        entity.setEntPhysicalClass(this.getEntPhysicalClass());
        v = this.getValue(entPhysicalDescr);
        if (v != null && !v.toDisplayString().trim().isEmpty()) {
            entity.setEntPhysicalDescr(v.toDisplayString().trim());
        }
        if ((v = this.getValue(entPhysicalVendorType)) != null && !v.toDisplayString().trim().isEmpty()) {
            entity.setEntPhysicalVendorType(v.toDisplayString().trim());
        }
        if ((v = this.getValue(entPhysicalContainedIn)) != null) {
            entity.setEntPhysicalContainedIn(Integer.valueOf(v.toInt()));
        }
        if ((v = this.getValue(entPhysicalParentRelPos)) != null) {
            entity.setEntPhysicalParentRelPos(Integer.valueOf(v.toInt()));
        }
        if ((v = this.getValue(entPhysicalName)) != null && !v.toDisplayString().trim().isEmpty()) {
            entity.setEntPhysicalName(v.toDisplayString().trim().trim());
        }
        if ((v = this.getValue(entPhysicalHardwareRev)) != null && !v.toDisplayString().trim().isEmpty()) {
            entity.setEntPhysicalHardwareRev(v.toDisplayString().trim());
        }
        if ((v = this.getValue(entPhysicalFirmwareRev)) != null && !v.toDisplayString().trim().isEmpty()) {
            entity.setEntPhysicalFirmwareRev(v.toDisplayString().trim());
        }
        if ((v = this.getValue(entPhysicalSoftwareRev)) != null && !v.toDisplayString().trim().isEmpty()) {
            entity.setEntPhysicalSoftwareRev(v.toDisplayString().trim());
        }
        if ((v = this.getValue(entPhysicalSerialNum)) != null && !v.toDisplayString().trim().isEmpty()) {
            entity.setEntPhysicalSerialNum(v.toDisplayString().trim());
        }
        if ((v = this.getValue(entPhysicalMfgName)) != null && !v.toDisplayString().trim().isEmpty()) {
            entity.setEntPhysicalMfgName(v.toDisplayString().trim());
        }
        if ((v = this.getValue(entPhysicalModelName)) != null && !v.toDisplayString().trim().isEmpty()) {
            entity.setEntPhysicalModelName(v.toDisplayString().trim());
        }
        if ((v = this.getValue(entPhysicalAlias)) != null && !v.toDisplayString().trim().isEmpty()) {
            entity.setEntPhysicalAlias(v.toDisplayString().trim());
        }
        if ((v = this.getValue(entPhysicalAssetID)) != null && !v.toDisplayString().trim().isEmpty()) {
            entity.setEntPhysicalAssetID(v.toDisplayString().trim());
        }
        if ((v = this.getValue(entPhysicalIsFRU)) != null) {
            entity.setEntPhysicalIsFRU(Boolean.valueOf(v.toInt() == 1));
        }
        if ((v = this.getValue(entPhysicalUris)) != null && !v.toDisplayString().trim().isEmpty()) {
            entity.setEntPhysicalUris(v.toDisplayString());
        }
        if (vendorAttributes != null && vendorAttributes.size() > 0) {
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)entity);
            for (Map.Entry<SnmpObjId, HwEntityAttributeType> entry : vendorAttributes.entrySet()) {
                v = this.getValue(entry.getKey());
                if (v == null || v.toDisplayString().trim().isEmpty()) continue;
                String typeName = entry.getValue().getName();
                if (replacementMap.containsKey(typeName)) {
                    String property = replacementMap.get(typeName);
                    if (!wrapper.isWritableProperty(property)) continue;
                    wrapper.setPropertyValue(property, (Object)v.toDisplayString().trim());
                    continue;
                }
                entity.addAttribute(entry.getValue(), v.toDisplayString().trim());
            }
        }
        return entity;
    }

    private String getEntPhysicalClass() {
        int index;
        SnmpValue v = this.getValue(entPhysicalClass);
        if (v != null && (index = v.toInt()) < CLASSES.length) {
            return CLASSES[index];
        }
        return CLASSES[2];
    }
}

