/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.HashSet;
import java.util.Iterator;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.netmgt.config.SnmpHwInventoryAdapterConfigDao;
import org.opennms.netmgt.config.hardware.HwExtension;
import org.opennms.netmgt.config.hardware.HwInventoryAdapterConfiguration;
import org.opennms.netmgt.config.hardware.MibObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSnmpHwInventoryAdapterConfigDao
extends AbstractJaxbConfigDao<HwInventoryAdapterConfiguration, HwInventoryAdapterConfiguration>
implements SnmpHwInventoryAdapterConfigDao {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSnmpHwInventoryAdapterConfigDao.class);

    public DefaultSnmpHwInventoryAdapterConfigDao() {
        super(HwInventoryAdapterConfiguration.class, "hardware-inventory-adapter-configuration");
    }

    @Override
    public HwInventoryAdapterConfiguration getConfiguration() {
        return (HwInventoryAdapterConfiguration)this.getContainer().getObject();
    }

    @Override
    public void reload() {
        this.getContainer().reload();
    }

    protected HwInventoryAdapterConfiguration translateConfig(HwInventoryAdapterConfiguration config) {
        HashSet<String> oids = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        for (HwExtension ext : config.getExtensions()) {
            Iterator it = ext.getMibObjects().iterator();
            while (it.hasNext()) {
                MibObj obj = (MibObj)it.next();
                String oid = obj.getOid().toString();
                if (oids.contains(oid)) {
                    LOG.warn("Duplicate OID detected, ignoring {} (please fix the configuration file)", (Object)obj);
                    it.remove();
                    continue;
                }
                oids.add(oid);
                if (names.contains(obj.getAlias())) {
                    LOG.warn("Duplicate Alias detected, ignoring {} (please fix the configuration file)", (Object)obj);
                    it.remove();
                    continue;
                }
                names.add(obj.getAlias());
            }
        }
        return config;
    }
}

