/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.opennms.netmgt.config.SnmpHwInventoryAdapterConfigDao;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.config.hardware.HwExtension;
import org.opennms.netmgt.config.hardware.MibObj;
import org.opennms.netmgt.dao.api.HwEntityAttributeTypeDao;
import org.opennms.netmgt.dao.api.HwEntityDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.HwEntityAttributeType;
import org.opennms.netmgt.model.OnmsHwEntity;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.provision.ProvisioningAdapterException;
import org.opennms.netmgt.provision.SimplerQueuedProvisioningAdapter;
import org.opennms.netmgt.provision.SnmpHardwareInventoryException;
import org.opennms.netmgt.provision.snmp.EntityPhysicalTableRow;
import org.opennms.netmgt.provision.snmp.EntityPhysicalTableTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

@EventListener(name="SnmpHardwareInventoryProvisioningAdapter")
public class SnmpHardwareInventoryProvisioningAdapter
extends SimplerQueuedProvisioningAdapter
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpHardwareInventoryProvisioningAdapter.class);
    public static final String PREFIX = "Provisiond.";
    public static final String NAME = "SnmpHardwareInventoryProvisioningAdapter";
    private NodeDao m_nodeDao;
    private HwEntityDao m_hwEntityDao;
    private HwEntityAttributeTypeDao m_hwEntityAttributeTypeDao;
    private EventForwarder m_eventForwarder;
    private SnmpAgentConfigFactory m_snmpConfigDao;
    private SnmpHwInventoryAdapterConfigDao m_hwInventoryAdapterConfigDao;
    private Map<SnmpObjId, HwEntityAttributeType> m_vendorAttributes = new HashMap<SnmpObjId, HwEntityAttributeType>();

    public SnmpHardwareInventoryProvisioningAdapter() {
        super(NAME);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_nodeDao, (String)"Node DAO cannot be null");
        Assert.notNull((Object)this.m_hwEntityDao, (String)"Hardware Entity DAO cannot be null");
        Assert.notNull((Object)this.m_hwEntityAttributeTypeDao, (String)"Hardware Entity Attribute Type DAO cannot be null");
        Assert.notNull((Object)this.m_snmpConfigDao, (String)"SNMP Configuration DAO cannot be null");
        Assert.notNull((Object)this.m_hwInventoryAdapterConfigDao, (String)"Hardware Inventory Configuration DAO cannot be null");
        Assert.notNull((Object)this.m_eventForwarder, (String)"Event Forwarder cannot be null");
        this.initializeVendorAttributes();
    }

    public void doAddNode(int nodeId) throws ProvisioningAdapterException {
        LOG.debug("doAdd: adding nodeid: {}", (Object)nodeId);
        this.synchronizeInventory(nodeId);
    }

    public void doUpdateNode(int nodeId) throws ProvisioningAdapterException {
        LOG.debug("doUpdate: updating nodeid: {}", (Object)nodeId);
        this.synchronizeInventory(nodeId);
    }

    private void synchronizeInventory(int nodeId) {
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (node == null) {
            throw new ProvisioningAdapterException("Failed to return node for given nodeId: " + nodeId);
        }
        OnmsIpInterface intf = node.getPrimaryInterface();
        if (intf == null) {
            throw new ProvisioningAdapterException("Can't find the SNMP Primary IP address for nodeId: " + nodeId);
        }
        InetAddress ipAddress = intf.getIpAddress();
        EventBuilder ebldr = null;
        try {
            if (node.getSysObjectId() == null) {
                LOG.warn("Skiping hardware discover because the node {} doesn't support SNMP", (Object)nodeId);
                return;
            }
            SnmpAgentConfig agentConfig = this.m_snmpConfigDao.getAgentConfig(ipAddress);
            OnmsHwEntity newRoot = this.getRootEntity(agentConfig, node);
            newRoot.setNode(node);
            OnmsHwEntity currentRoot = this.m_hwEntityDao.findRootByNodeId(node.getId());
            if (newRoot.equals((Object)currentRoot)) {
                LOG.info("No changes detected on the hardware inventory for nodeId {}", (Object)nodeId);
                return;
            }
            if (currentRoot == null) {
                LOG.info("Saving hardware inventory for nodeId {}", (Object)nodeId);
            } else {
                LOG.info("Updating hardware inventory for nodeId {}", (Object)nodeId);
                this.m_hwEntityDao.delete((Object)currentRoot);
                this.m_hwEntityDao.flush();
            }
            this.m_hwEntityDao.saveOrUpdate((Object)newRoot);
            ebldr = new EventBuilder("uei.opennms.org/internal/discovery/hardwareInventorySuccessful", "Provisiond.SnmpHardwareInventoryProvisioningAdapter");
        }
        catch (Throwable e) {
            ebldr = new EventBuilder("uei.opennms.org/internal/discovery/hardwareInventoryFailed", "Provisiond.SnmpHardwareInventoryProvisioningAdapter");
            ebldr.addParam("reason", e.getMessage());
        }
        if (ebldr != null) {
            ebldr.setNodeid((long)nodeId);
            ebldr.setInterface(ipAddress);
            this.getEventForwarder().sendNow(ebldr.getEvent());
        }
    }

    private void initializeVendorAttributes() {
        this.m_vendorAttributes.clear();
        for (HwEntityAttributeType type : this.m_hwEntityAttributeTypeDao.findAll()) {
            LOG.debug("Loading attribute type {}", (Object)type);
            this.m_vendorAttributes.put(type.getSnmpObjId(), type);
        }
        for (HwExtension ext : this.m_hwInventoryAdapterConfigDao.getConfiguration().getExtensions()) {
            for (MibObj obj : ext.getMibObjects()) {
                HwEntityAttributeType type = this.m_vendorAttributes.get(obj.getOid());
                if (type != null) continue;
                type = new HwEntityAttributeType(obj.getOid().toString(), obj.getAlias(), obj.getType());
                LOG.info("Creating attribute type {}", (Object)type);
                this.m_hwEntityAttributeTypeDao.save((Object)type);
                this.m_vendorAttributes.put(type.getSnmpObjId(), type);
            }
        }
    }

    private OnmsHwEntity getRootEntity(SnmpAgentConfig agentConfig, OnmsNode node) throws SnmpHardwareInventoryException {
        LOG.debug("getRootEntity: Getting ENTITY-MIB using {}", (Object)agentConfig);
        List vendorOidList = this.m_hwInventoryAdapterConfigDao.getConfiguration().getVendorOid(node.getSysObjectId());
        Map replacementMap = this.m_hwInventoryAdapterConfigDao.getConfiguration().getReplacementMap();
        Object[] vendorOids = vendorOidList.toArray(new SnmpObjId[vendorOidList.size()]);
        SnmpObjId[] allOids = (SnmpObjId[])ArrayUtils.addAll((Object[])EntityPhysicalTableRow.ELEMENTS, (Object[])vendorOids);
        EntityPhysicalTableTracker tracker = new EntityPhysicalTableTracker(this.m_vendorAttributes, allOids, replacementMap);
        String trackerName = ((Object)((Object)tracker)).getClass().getSimpleName() + '_' + node.getLabel();
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)trackerName, (CollectionTracker)tracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                throw new SnmpHardwareInventoryException("Aborting entities scan: Agent timed out while scanning the " + trackerName + " table");
            }
            if (walker.failed()) {
                LOG.error("Aborting entities scan for " + agentConfig, walker.getErrorThrowable());
                throw new SnmpHardwareInventoryException("Aborting entities scan: Agent failed while scanning the " + trackerName + " table: " + walker.getErrorMessage());
            }
        }
        catch (InterruptedException e) {
            throw new SnmpHardwareInventoryException("ENTITY-MIB node collection interrupted, exiting");
        }
        OnmsHwEntity root = tracker.getRootEntity();
        if (root == null) {
            throw new SnmpHardwareInventoryException("Cannot get root entity for node " + node.getLabel() + ", it seems like its SNMP agent does not have an implementation for the entPhysicalTable of the ENTITY-MIB, or it has an incorrect implementation of it.");
        }
        return root;
    }

    public void doNotifyConfigChange(int nodeId) throws ProvisioningAdapterException {
        LOG.debug("doNodeConfigChanged: nodeid: {}", (Object)nodeId);
    }

    public HwEntityDao getHwEntityDao() {
        return this.m_hwEntityDao;
    }

    public void setHwEntityDao(HwEntityDao hwEntityDao) {
        this.m_hwEntityDao = hwEntityDao;
    }

    public HwEntityAttributeTypeDao getHwEntityAttributeTypeDao() {
        return this.m_hwEntityAttributeTypeDao;
    }

    public void setHwEntityAttributeTypeDao(HwEntityAttributeTypeDao hwEntityAttributeTypeDao) {
        this.m_hwEntityAttributeTypeDao = hwEntityAttributeTypeDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao dao) {
        this.m_nodeDao = dao;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public SnmpAgentConfigFactory getSnmpPeerFactory() {
        return this.m_snmpConfigDao;
    }

    public void setSnmpPeerFactory(SnmpAgentConfigFactory snmpConfigDao) {
        this.m_snmpConfigDao = snmpConfigDao;
    }

    public SnmpHwInventoryAdapterConfigDao getHwAdapterConfigDao() {
        return this.m_hwInventoryAdapterConfigDao;
    }

    public void setHwInventoryAdapterConfigDao(SnmpHwInventoryAdapterConfigDao hwInventoryAdapterConfigDao) {
        this.m_hwInventoryAdapterConfigDao = hwInventoryAdapterConfigDao;
    }

    public String getName() {
        return NAME;
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(Event event) {
        if (this.isReloadConfigEventTarget(event)) {
            EventBuilder ebldr = null;
            LOG.debug("Reloading the Hardware Inventory adapter configuration");
            try {
                this.m_hwInventoryAdapterConfigDao.reload();
                this.initializeVendorAttributes();
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", "Provisiond.SnmpHardwareInventoryProvisioningAdapter");
                ebldr.addParam("daemonName", "Provisiond.SnmpHardwareInventoryProvisioningAdapter");
            }
            catch (Throwable e) {
                LOG.warn("Unable to reload Hardware Inventory adapter configuration", e);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", "Provisiond.SnmpHardwareInventoryProvisioningAdapter");
                ebldr.addParam("daemonName", "Provisiond.SnmpHardwareInventoryProvisioningAdapter");
                ebldr.addParam("reason", e.getMessage());
            }
            if (ebldr != null) {
                this.getEventForwarder().sendNow(ebldr.getEvent());
            }
        }
    }

    private boolean isReloadConfigEventTarget(Event event) {
        boolean isTarget = false;
        for (Parm parm : event.getParmCollection()) {
            if (!"daemonName".equals(parm.getParmName()) || !"Provisiond.SnmpHardwareInventoryProvisioningAdapter".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        LOG.debug("isReloadConfigEventTarget: Provisiond. {} was target of reload event: {}", (Object)NAME, (Object)isTarget);
        return isTarget;
    }

    protected Map<SnmpObjId, HwEntityAttributeType> getVendorAttributeMap() {
        return this.m_vendorAttributes;
    }
}

