/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.netmgt.config.SnmpAssetAdapterConfig;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.config.snmpAsset.adapter.AssetField;
import org.opennms.netmgt.config.snmpAsset.adapter.MibObj;
import org.opennms.netmgt.config.snmpAsset.adapter.MibObjs;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.model.events.snmp.SyntaxToEvent;
import org.opennms.netmgt.provision.ProvisioningAdapterException;
import org.opennms.netmgt.provision.SimpleQueuedProvisioningAdapter;
import org.opennms.netmgt.provision.SimplerQueuedProvisioningAdapter;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.util.Assert;

@EventListener(name="SnmpAssetProvisioningAdapter")
public class SnmpAssetProvisioningAdapter
extends SimplerQueuedProvisioningAdapter
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpAssetProvisioningAdapter.class);
    private NodeDao m_nodeDao;
    private EventForwarder m_eventForwarder;
    private SnmpAssetAdapterConfig m_config;
    private SnmpAgentConfigFactory m_snmpConfigDao;
    public static final String NAME = "SnmpAssetProvisioningAdapter";

    public SnmpAssetProvisioningAdapter() {
        super(NAME);
        this.setDelay(300L);
        this.setTimeUnit(TimeUnit.SECONDS);
    }

    SimpleQueuedProvisioningAdapter.AdapterOperationSchedule createScheduleForNode(int nodeId, SimpleQueuedProvisioningAdapter.AdapterOperationType adapterOperationType) {
        SimpleQueuedProvisioningAdapter.AdapterOperationSchedule aos = new SimpleQueuedProvisioningAdapter.AdapterOperationSchedule(this.m_delay, 60L, 3, this.m_timeUnit);
        LOG.info("createScheduleForNode: Scheduling {} for nodeid {} with schedule: {}", new Object[]{aos, adapterOperationType, nodeId});
        return aos;
    }

    public boolean isNodeReady(SimpleQueuedProvisioningAdapter.AdapterOperation op) {
        boolean readyState = false;
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)op.getNodeId());
        if (node != null && node.getSysObjectId() != null) {
            readyState = true;
        }
        return readyState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAddNode(int nodeId) throws ProvisioningAdapterException {
        LOG.debug("doAdd: adding nodeid: {}", (Object)nodeId);
        final OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        Assert.notNull((Object)node, (String)("doAdd: failed to return node for given nodeId:" + nodeId));
        InetAddress ipaddress = (InetAddress)this.m_template.execute((TransactionCallback)new TransactionCallback<InetAddress>(){

            public InetAddress doInTransaction(TransactionStatus arg0) {
                return SnmpAssetProvisioningAdapter.this.getIpForNode(node);
            }
        });
        SnmpAgentConfig agentConfig = null;
        agentConfig = this.m_snmpConfigDao.getAgentConfig(ipaddress);
        OnmsAssetRecord asset = node.getAssetRecord();
        this.m_config.getReadLock().lock();
        try {
            for (AssetField field : this.m_config.getAssetFieldsForAddress(ipaddress, node.getSysObjectId())) {
                try {
                    String value = SnmpAssetProvisioningAdapter.fetchSnmpAssetString(agentConfig, field.getMibObjs(), field.getFormatString());
                    LOG.debug("doAdd: Setting asset field \" {} \" to value: {}", (Object)field.getName(), (Object)value);
                    BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)asset);
                    try {
                        wrapper.setPropertyValue(field.getName(), (Object)value);
                    }
                    catch (BeansException e) {
                        LOG.warn("doAdd: Could not set property \" {} \" on asset object {}", new Object[]{field.getName(), e.getMessage(), e});
                    }
                }
                catch (MissingFormatArgumentException e) {
                    LOG.warn("doAdd: Could not set value for asset field \" {} \": {}", new Object[]{field.getName(), e.getMessage(), e});
                }
            }
        }
        finally {
            this.m_config.getReadLock().unlock();
        }
        node.setAssetRecord(asset);
        this.m_nodeDao.saveOrUpdate((Object)node);
        this.m_nodeDao.flush();
    }

    private static String fetchSnmpAssetString(SnmpAgentConfig agentConfig, MibObjs mibObjs, String formatString) throws MissingFormatArgumentException {
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<SnmpObjId> objs = new ArrayList<SnmpObjId>();
        for (MibObj mibobj : mibObjs.getMibObj()) {
            aliases.add(mibobj.getAlias());
            objs.add(SnmpObjId.get((String)mibobj.getOid()));
        }
        SnmpValue[] values = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId[])objs.toArray(new SnmpObjId[0]));
        if (values.length == aliases.size()) {
            Properties substitutions = new Properties();
            boolean foundAValue = false;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null || values[i].isError()) continue;
                foundAValue = true;
                Parm parm = SyntaxToEvent.processSyntax((String)((String)aliases.get(i)), (SnmpValue)values[i]);
                substitutions.setProperty((String)aliases.get(i), parm.getValue().getContent());
            }
            if (!foundAValue) {
                LOG.debug("fetchSnmpAssetString: Failed to fetch any SNMP values for system {}", (Object)agentConfig);
                throw new MissingFormatArgumentException("fetchSnmpAssetString: Failed to fetch any SNMP values for system " + agentConfig.toString());
            }
            LOG.debug("fetchSnmpAssetString: Fetched asset properties from SNMP agent:\n {}", (Object)SnmpAssetProvisioningAdapter.formatPropertiesAsString(substitutions));
            if (objs.size() != substitutions.size()) {
                LOG.warn("fetchSnmpAssetString: Unexpected number of properties returned from SNMP GET:\n {}", (Object)SnmpAssetProvisioningAdapter.formatPropertiesAsString(substitutions));
            }
            return PropertiesUtils.substitute((String)formatString, (Properties[])new Properties[]{substitutions});
        }
        LOG.warn("fetchSnmpAssetString: Invalid number of SNMP parameters returned: {} != {}", (Object)aliases.size(), (Object)values.length);
        throw new MissingFormatArgumentException("fetchSnmpAssetString: Invalid number of SNMP parameters returned: " + values.length + " != " + aliases.size());
    }

    protected static String formatPropertiesAsString(Properties props) {
        StringBuffer propertyValues = new StringBuffer();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            propertyValues.append("  ");
            propertyValues.append(entry.getKey().toString());
            propertyValues.append(" => ");
            propertyValues.append(entry.getValue().toString());
            propertyValues.append("\n");
        }
        return propertyValues.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdateNode(int nodeId) throws ProvisioningAdapterException {
        LOG.debug("doUpdate: updating nodeid: {}", (Object)nodeId);
        final OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        Assert.notNull((Object)node, (String)("doUpdate: failed to return node for given nodeId:" + nodeId));
        InetAddress ipaddress = (InetAddress)this.m_template.execute((TransactionCallback)new TransactionCallback<InetAddress>(){

            public InetAddress doInTransaction(TransactionStatus arg0) {
                return SnmpAssetProvisioningAdapter.this.getIpForNode(node);
            }
        });
        SnmpAgentConfig agentConfig = this.m_snmpConfigDao.getAgentConfig(ipaddress);
        OnmsAssetRecord asset = node.getAssetRecord();
        this.m_config.getReadLock().lock();
        try {
            for (AssetField field : this.m_config.getAssetFieldsForAddress(ipaddress, node.getSysObjectId())) {
                try {
                    String value = SnmpAssetProvisioningAdapter.fetchSnmpAssetString(agentConfig, field.getMibObjs(), field.getFormatString());
                    LOG.debug("doUpdate: Setting asset field \" {} \" to value: {}", (Object)value, (Object)field.getName());
                    BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)asset);
                    try {
                        wrapper.setPropertyValue(field.getName(), (Object)value);
                    }
                    catch (BeansException e) {
                        LOG.warn("doUpdate: Could not set property \" {} \" on asset object: {}", new Object[]{field.getName(), e.getMessage(), e});
                    }
                }
                catch (MissingFormatArgumentException e) {
                    LOG.warn("doUpdate: Could not set value for asset field \" {} \": {}", new Object[]{field.getName(), e.getMessage(), e});
                }
            }
        }
        finally {
            this.m_config.getReadLock().unlock();
        }
        node.setAssetRecord(asset);
        this.m_nodeDao.saveOrUpdate((Object)node);
        this.m_nodeDao.flush();
    }

    public void doNotifyConfigChange(int nodeId) throws ProvisioningAdapterException {
        LOG.debug("doNodeConfigChanged: nodeid: {}", (Object)nodeId);
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao dao) {
        this.m_nodeDao = dao;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public SnmpAgentConfigFactory getSnmpPeerFactory() {
        return this.m_snmpConfigDao;
    }

    public void setSnmpPeerFactory(SnmpAgentConfigFactory snmpConfigDao) {
        this.m_snmpConfigDao = snmpConfigDao;
    }

    public SnmpAssetAdapterConfig getSnmpAssetAdapterConfig() {
        return this.m_config;
    }

    public void setSnmpAssetAdapterConfig(SnmpAssetAdapterConfig mConfig) {
        this.m_config = mConfig;
    }

    public String getName() {
        return NAME;
    }

    private InetAddress getIpForNode(OnmsNode node) {
        LOG.debug("getIpForNode: node: {} Foreign Source: {}", (Object)node.getNodeId(), (Object)node.getForeignSource());
        OnmsIpInterface primaryInterface = node.getPrimaryInterface();
        InetAddress ipaddr = InetAddressUtils.getLocalHostAddress();
        if (primaryInterface == null) {
            LOG.debug("getIpForNode: found null SNMP Primary Interface, getting interfaces");
            Set ipInterfaces = node.getIpInterfaces();
            for (OnmsIpInterface onmsIpInterface : ipInterfaces) {
                LOG.debug("getIpForNode: trying Interface with id: {}", (Object)onmsIpInterface.getId());
                if (InetAddressUtils.str((InetAddress)onmsIpInterface.getIpAddress()) != null) {
                    ipaddr = onmsIpInterface.getIpAddress();
                    continue;
                }
                LOG.debug("getIpForNode: found null ip address on Interface with id: {}", (Object)onmsIpInterface.getId());
            }
        } else {
            LOG.debug("getIpForNode: found SNMP Primary Interface");
            if (InetAddressUtils.str((InetAddress)primaryInterface.getIpAddress()) != null) {
                ipaddr = primaryInterface.getIpAddress();
            } else {
                LOG.debug("getIpForNode: found null ip address on Primary Interface");
            }
        }
        return ipaddr;
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(Event event) {
        if (this.isReloadConfigEventTarget(event)) {
            EventBuilder ebldr = null;
            LOG.debug("Reloading the SNMP asset adapter configuration");
            try {
                this.m_config.update();
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", "Provisiond.SnmpAssetProvisioningAdapter");
                ebldr.addParam("daemonName", "Provisiond.SnmpAssetProvisioningAdapter");
            }
            catch (Throwable e) {
                LOG.info("Unable to reload SNMP asset adapter configuration", e);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", "Provisiond.SnmpAssetProvisioningAdapter");
                ebldr.addParam("daemonName", "Provisiond.SnmpAssetProvisioningAdapter");
                ebldr.addParam("reason", e.getLocalizedMessage().substring(1, 128));
            }
            if (ebldr != null) {
                this.getEventForwarder().sendNow(ebldr.getEvent());
            }
        }
    }

    private boolean isReloadConfigEventTarget(Event event) {
        boolean isTarget = false;
        for (Parm parm : event.getParmCollection()) {
            if (!"daemonName".equals(parm.getParmName()) || !"Provisiond.SnmpAssetProvisioningAdapter".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        LOG.debug("isReloadConfigEventTarget: Provisiond. {} was target of reload event: {}", (Object)isTarget, (Object)NAME);
        return isTarget;
    }

    public void afterPropertiesSet() throws Exception {
    }
}

